/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.views.types;

import com.jrockit.mc.components.ui.base.AbstractUIComponent;
import com.jrockit.mc.components.ui.components.UIScope;
import com.jrockit.mc.components.ui.design.actions.ExportAction;
import com.jrockit.mc.components.ui.design.actions.ImportAction;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.flightrecorder.ui.FlightRecorderUI;
import com.jrockit.mc.flightrecorder.ui.components.range.INavigatorSelectionChangeListener;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.ui.views.types.ITypeVisibilityChange;
import com.jrockit.mc.flightrecorder.ui.views.types.PropertiesAction;
import com.jrockit.mc.flightrecorder.ui.views.types.SetFilter;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeContentProvider;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeDescriptor;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeDescriptorWizardPage;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeFolder;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeFolderWizardPage;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeLabelProvider;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeRespository;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeTreeVieweListener;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeViewerComparator;
import com.jrockit.mc.flightrecorder.ui.views.types.visitor.CheckSetter;
import com.jrockit.mc.flightrecorder.ui.views.types.visitor.CheckedVisitor;
import com.jrockit.mc.flightrecorder.ui.views.types.visitor.ExpansionVisitor;
import com.jrockit.mc.flightrecorder.ui.views.types.visitor.IVisitable;
import com.jrockit.mc.flightrecorder.ui.views.types.visitor.MatchingVisitor;
import com.jrockit.mc.ui.misc.ColorProvider;
import com.jrockit.mc.ui.misc.IToolTipTextProvider;
import com.jrockit.mc.ui.misc.ToolTipMouseTrackAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;

public class TypeComponent
extends AbstractUIComponent
implements INavigatorSelectionChangeListener,
ITreeViewerListener,
SelectionListener {
    private static final String DEFAULT_TYPE_TREE_FILENAME = "typeTree.xml";
    private CheckboxTreeViewer m_viewer;
    private ColorProvider m_colorProvider;
    private ArrayList<TreeItem> m_treeItems = new ArrayList();
    private Text m_filterText;
    private MatchingVisitor m_matchFilter;

    public boolean initialize(IServiceLocator serviceLocator) {
        super.initialize(serviceLocator);
        IServiceLocator locator = serviceLocator.getParent();
        locator.registerService((Object)this.getTypeRespoitory());
        this.m_matchFilter = new MatchingVisitor("");
        return true;
    }

    private void pushEventTypeChange() {
        CheckedVisitor cv = new CheckedVisitor();
        this.getTypeRespoitory().getRootFolder().accept(cv);
        this.pushEventtypeCheckStatus(TypeComponent.pathify(cv.getAll()), new ArrayList<String>());
    }

    public void pushEventtypeCheckStatus(List<String> shown, List<String> hidden) {
        for (ITypeVisibilityChange tp : this.getComponents().getTopScope().getComponentsInAncestorScopes(ITypeVisibilityChange.class)) {
            tp.setTypeVisibilityChange(shown, hidden);
        }
    }

    private boolean hasValidViewer() {
        return this.m_viewer != null && this.m_viewer.getControl() != null && !this.m_viewer.getControl().isDisposed();
    }

    private void addListeners() {
        if (this.hasValidViewer()) {
            this.getViewer().addTreeListener((ITreeViewerListener)this);
            this.getViewer().getTree().addSelectionListener((SelectionListener)this);
        }
    }

    private void removeViewerListeners() {
        if (this.hasValidViewer()) {
            this.getViewer().removeTreeListener((ITreeViewerListener)this);
            this.getViewer().getTree().removeSelectionListener((SelectionListener)this);
        }
    }

    public Control createPart(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        container.setLayout((Layout)layout);
        this.m_colorProvider = this.createColorProvider(container.getDisplay());
        Composite filterContainer = this.createFilterContainer(container);
        filterContainer.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_viewer = this.createViewer(container, this.m_colorProvider);
        this.m_viewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.setupContextMenu();
        this.hookMenuManagwer();
        this.updateInput();
        this.addListeners();
        return container;
    }

    private Composite createFilterContainer(Composite parent) {
        Composite client = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginRight = 14;
        layout.verticalSpacing = 0;
        client.setLayout((Layout)layout);
        this.m_filterText = this.createFilterText(client);
        this.m_filterText.setLayoutData((Object)new GridData(4, 4, true, true));
        return client;
    }

    private Text createFilterText(Composite container) {
        final Text text = new Text(container, 2048);
        text.setToolTipText(Messages.EVENT_TYPES_VIEW_FILTER_DESCRIPTION_TEXT);
        final ControlDecoration cd = this.createClearDecoration(text);
        cd.hide();
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TypeComponent.this.updateFilter();
                if (text.getText().length() > 0) {
                    cd.show();
                } else {
                    cd.hide();
                }
            }
        });
        return text;
    }

    private ControlDecoration createClearDecoration(final Text text) {
        ControlDecoration cd = new ControlDecoration((Control)text, 131072);
        cd.setImage(FlightRecorderUI.getDefault().getImage("clear_co.gif"));
        cd.setDescriptionText(Messages.EVENT_TYPES_VIEW_FILTER_CLEAR_TEXT);
        cd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                text.setText("");
            }
        });
        return cd;
    }

    private void updateFilter() {
        this.getViewer().getTree().setRedraw(false);
        if (this.m_filterText.getText().length() != 0) {
            this.m_matchFilter.setFilterText(this.m_filterText.getText());
            this.getTypeRespoitory().accept(this.m_matchFilter);
            this.getTypeRespoitory().accept(new ExpansionVisitor(true));
            this.getViewer().setFilters(new ViewerFilter[]{new SetFilter(this.m_matchFilter.getMatching())});
        } else {
            this.m_matchFilter.setFilterText("");
            this.getViewer().setFilters(new ViewerFilter[0]);
            this.getTypeRespoitory().accept(new ExpansionVisitor(false));
        }
        this.updateInput();
        this.getViewer().getTree().setRedraw(true);
    }

    private TypeRespository getTypeRespoitory() {
        return (TypeRespository)this.getServiceLocator().getService(TypeRespository.class);
    }

    private ColorProvider createColorProvider(Display display) {
        return new ColorProvider(display, 14);
    }

    private CheckboxTreeViewer createViewer(Composite parent, ColorProvider colorProvider) {
        CheckboxTreeViewer viewer = new CheckboxTreeViewer(parent);
        viewer.getTree().setLinesVisible(true);
        TypeLabelProvider tl = new TypeLabelProvider(colorProvider, this.m_matchFilter);
        viewer.setLabelProvider((IBaseLabelProvider)tl);
        viewer.setComparator((ViewerComparator)new TypeViewerComparator());
        viewer.setContentProvider((IContentProvider)new TypeContentProvider());
        viewer.addTreeListener((ITreeViewerListener)new TypeTreeVieweListener());
        viewer.getTree().addMouseTrackListener((MouseTrackListener)new ToolTipMouseTrackAdapter((Composite)viewer.getTree(), (IToolTipTextProvider)tl));
        this.hookCheckStateListener(viewer);
        return viewer;
    }

    private void hookCheckStateListener(CheckboxTreeViewer viewer) {
        viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getElement() instanceof IVisitable) {
                    TypeComponent.this.setVisitableChecked(event.getElement(), event.getChecked());
                }
            }
        });
    }

    protected void hookDoubleClickListener(CheckboxTreeViewer viewer) {
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (TypeComponent.this.getSelected() != null) {
                    TypeComponent.this.createPropertiesAction(TypeComponent.this.getSelected()).run();
                }
            }
        });
    }

    private void fillWithAllTreeItems(Collection<TreeItem> collectionToFill, Object treeStuff) {
        if (treeStuff instanceof TreeItem[]) {
            TreeItem[] items;
            TreeItem[] treeItemArray = items = (TreeItem[])treeStuff;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                this.fillWithAllTreeItems(collectionToFill, item);
                ++n2;
            }
        }
        if (treeStuff instanceof TreeItem) {
            TreeItem aTreeItem = (TreeItem)treeStuff;
            Object element = aTreeItem.getData();
            if (element != null) {
                collectionToFill.add(aTreeItem);
            }
            this.fillWithAllTreeItems(collectionToFill, aTreeItem.getItems());
        }
    }

    private boolean setChildEventState(List<? extends IVisitable> children, boolean checked) {
        boolean retValue = false;
        Iterator<? extends IVisitable> it = children.iterator();
        while (it.hasNext()) {
            if (!this.setEventState(it.next(), checked)) continue;
            retValue = true;
        }
        return retValue;
    }

    private boolean setEventState(Object element, boolean checked) {
        if (element instanceof TypeFolder) {
            return this.setChildEventState(((TypeFolder)element).getChildren(), checked);
        }
        if (element instanceof TypeDescriptor) {
            boolean retValue = false;
            TypeDescriptor typeDescriptor = (TypeDescriptor)element;
            if (typeDescriptor.isChecked() != checked) {
                typeDescriptor.setChecked(checked);
                retValue = true;
            }
            return retValue;
        }
        return false;
    }

    private void refreshExpansionState() {
        ArrayList<Object> expandedElements = new ArrayList<Object>(this.m_treeItems.size());
        for (TreeItem t : this.m_treeItems) {
            Object element;
            if (t.isDisposed() || !this.getExpansionState(element = t.getData())) continue;
            expandedElements.add(t.getData());
        }
        this.m_viewer.collapseAll();
        this.getViewer().setExpandedElements(expandedElements.toArray());
    }

    private TreeState getChildState(List<? extends IVisitable> collection) {
        int visibleCount = 0;
        for (IVisitable iVisitable : collection) {
            TreeState childState = this.getCheckState(iVisitable);
            if (childState == TreeState.GREY) {
                return TreeState.GREY;
            }
            if (childState != TreeState.CHECKED) continue;
            ++visibleCount;
        }
        if (visibleCount == 0) {
            return TreeState.UNCHECKED;
        }
        if (visibleCount == collection.size()) {
            return TreeState.CHECKED;
        }
        return TreeState.GREY;
    }

    private TreeState getCheckState(Object element) {
        if (element instanceof TypeDescriptor) {
            return TreeState.valueof(((TypeDescriptor)element).isChecked());
        }
        if (element instanceof TypeFolder) {
            return this.getChildState(((TypeFolder)element).getChildren());
        }
        return TreeState.GREY;
    }

    private boolean getExpansionState(Object element) {
        if (element instanceof TypeFolder) {
            return ((TypeFolder)element).getExpanded();
        }
        return false;
    }

    private void setVisitableChecked(Object element, boolean checked) {
        IVisitable v = (IVisitable)element;
        CheckSetter cs = new CheckSetter(checked);
        v.accept(cs);
        TypeComponent.push(this.getServiceLocator().getParent(), cs.getChecked(), cs.getUnChecked());
        this.refreshCheckState(this.m_viewer.getTree().getItems());
    }

    private void hookMenuManagwer() {
        MenuManager manager = this.getMenuManager();
        manager.setRemoveAllWhenShown(true);
    }

    private PropertiesAction createPropertiesAction(Object object) {
        PropertiesAction propertiesAction = new PropertiesAction(this.m_viewer.getControl().getShell(), this.createWizardPage(object));
        propertiesAction.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                TypeComponent.this.updateAll();
            }
        });
        return propertiesAction;
    }

    protected IAction createImportAction() {
        ImportAction<TypeRespository> ia = new ImportAction<TypeRespository>(this.getViewer().getControl().getShell(), Messages.EVENT_TYPES_VIEW_IMPORT_TREE_TEXT, this.getTypeRespoitory()){

            protected void commitObject(TypeRespository typeRespository) {
                TypeComponent.this.updateAll();
            }
        };
        return ia;
    }

    protected IAction createExportAction() {
        return new ExportAction(this.getViewer().getControl().getShell(), Messages.EVENT_TYPES_VIEW_EXPORT_TREE_TEXT, DEFAULT_TYPE_TREE_FILENAME, (Object)this.getTypeRespoitory());
    }

    private IWizardPage createWizardPage(Object object) {
        if (object instanceof TypeFolder) {
            return new TypeFolderWizardPage((TypeFolder)object);
        }
        if (object instanceof TypeDescriptor) {
            return new TypeDescriptorWizardPage((TypeDescriptor)object);
        }
        throw new RuntimeException("Unknown Object");
    }

    private Object getSelected() {
        IStructuredSelection ss = (IStructuredSelection)this.m_viewer.getSelection();
        if (!ss.isEmpty()) {
            return ss.getFirstElement();
        }
        return null;
    }

    private CheckboxTreeViewer getViewer() {
        return this.m_viewer;
    }

    public static List<String> pathify(List<TypeDescriptor> list) {
        ArrayList<String> paths = new ArrayList<String>();
        for (TypeDescriptor td : list) {
            paths.add(td.getPath());
        }
        return paths;
    }

    public static void push(IServiceLocator s, List<TypeDescriptor> shown, List<TypeDescriptor> hidden) {
        UIScope c = (UIScope)s.getService(UIScope.class);
        if (c != null) {
            for (ITypeVisibilityChange tp : c.getAllComponents(ITypeVisibilityChange.class)) {
                tp.setTypeVisibilityChange(TypeComponent.pathify(shown), TypeComponent.pathify(hidden));
            }
        }
    }

    protected void setupContextMenu() {
        MenuManager menuManager = this.getMenuManager();
        if (menuManager != null) {
            Control control = this.getViewer().getControl();
            Menu menu = menuManager.createContextMenu(control);
            control.setMenu(menu);
            this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.getViewer());
        }
    }

    @Override
    public void onChange(long startTime, long endTime) {
    }

    public void initializeUI() {
        super.initializeUI();
        this.updateInput();
    }

    public void storeExpansionState(Object element, boolean expanded) {
        if (element instanceof TypeFolder) {
            ((TypeFolder)element).setExpanded(expanded);
        }
    }

    public void treeCollapsed(TreeExpansionEvent event) {
        this.storeExpansionState(event.getElement(), false);
    }

    public void treeExpanded(TreeExpansionEvent event) {
        this.m_viewer.getTree().setRedraw(false);
        this.refreshCheckState(this.m_viewer.getTree().getItems());
        this.storeExpansionState(event.getElement(), true);
        this.m_viewer.getTree().setRedraw(true);
    }

    private void refreshCheckState(TreeItem[] items) {
        if (items != null) {
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                TreeItem t = item;
                if (!t.isDisposed()) {
                    Object element = t.getData();
                    TreeState state = this.getCheckState(element);
                    t.setGrayed(state == TreeState.GREY);
                    t.setChecked(state == TreeState.GREY || state == TreeState.CHECKED);
                    this.refreshCheckState(t.getItems());
                }
                ++n2;
            }
        }
    }

    protected void updateInput() {
        if (this.hasValidViewer()) {
            this.m_viewer.getTree().setRedraw(false);
            this.m_viewer.setAutoExpandLevel(-1);
            TypeRespository tr = this.getTypeRespoitory();
            this.m_viewer.setInput((Object)tr);
            this.m_viewer.refresh(true);
            this.m_viewer.setAutoExpandLevel(0);
            this.m_treeItems = new ArrayList();
            this.m_treeItems.clear();
            this.fillWithAllTreeItems(this.m_treeItems, this.m_viewer.getTree().getItems());
            this.refreshCheckState(this.m_viewer.getTree().getItems());
            this.refreshExpansionState();
            this.m_viewer.getTree().setRedraw(true);
        }
    }

    public boolean dispose(IServiceLocator serviceLocator) {
        this.removeViewerListeners();
        return true;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.item != null && e.item.getData() != null && e.detail == 32) {
            Object element = e.item.getData();
            if (e.item instanceof TreeItem) {
                TreeItem treeItem = (TreeItem)e.item;
                boolean checked = treeItem.getChecked();
                this.setEventState(element, checked);
                this.m_viewer.getTree().setRedraw(false);
                this.refreshCheckState(this.m_viewer.getTree().getItems());
                this.m_viewer.getTree().setRedraw(true);
            }
        }
    }

    private void updateAll() {
        ISelection oldSelection = this.m_viewer.getSelection();
        this.m_colorProvider.clear();
        this.updateInput();
        this.m_viewer.setSelection(oldSelection);
        this.pushEventTypeChange();
    }

    static enum TreeState {
        CHECKED,
        UNCHECKED,
        GREY;


        public static TreeState valueof(boolean value) {
            return value ? CHECKED : UNCHECKED;
        }
    }
}

