/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.views.types;

import com.jrockit.mc.common.persistence.ISettingFetcher;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.common.persistence.Type;
import com.jrockit.mc.flightrecorder.EventAppearance;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeDescriptor;
import com.jrockit.mc.flightrecorder.ui.views.types.visitor.IVisitable;
import com.jrockit.mc.flightrecorder.ui.views.types.visitor.IVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class TypeFolder
implements IVisitable {
    public static final String EXPANDED = "expanded";
    private static final String FOLDERS = "folders";
    private static final String TYPE_DESCRIPTORS = "typeDescriptors";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private final Setting m_setting = new Setting("folder");

    static {
        PersistenceToolkit.registerFetcher(TypeFolder.class, (ISettingFetcher)new ISettingFetcher<TypeFolder>(){

            public Setting getSetting(TypeFolder typeFolder) {
                return typeFolder.m_setting;
            }
        });
    }

    public TypeFolder() {
        this(Messages.EVENT_TYPES_VIEW_DEFAULT_FOLDER_NAME_TEXT);
    }

    public TypeFolder(String name) {
        this.setName(name);
    }

    public List<TypeDescriptor> getTypeDescriptors() {
        return (List)this.m_setting.getChildObject(TYPE_DESCRIPTORS, new Type(List.class, new Type[]{new Type(TypeDescriptor.class)}));
    }

    public List<TypeFolder> getFolders() {
        return (List)this.m_setting.getChildObject(FOLDERS, new Type(List.class, new Type[]{new Type(TypeFolder.class)}));
    }

    public String getName() {
        return (String)this.m_setting.getChildObject(NAME, String.class);
    }

    public void setName(String name) {
        this.m_setting.setChildObject(NAME, (Object)name);
    }

    public String getDescription() {
        return (String)this.m_setting.getChildObject(DESCRIPTION, String.class);
    }

    public void setDescription(String description) {
        this.m_setting.setChildObject(DESCRIPTION, (Object)description);
    }

    public void setExpanded(boolean expanded) {
        this.m_setting.setChildObject(EXPANDED, (Object)expanded);
    }

    public boolean getExpanded() {
        return (Boolean)this.m_setting.getChildObject(EXPANDED, Boolean.class);
    }

    public TypeFolder getOrCreateFolderFromPath(String path) {
        TypeFolder folder2;
        String name = EventAppearance.getHumanSegmentName((String)path);
        for (TypeFolder folder2 : this.getFolders()) {
            if (!name.equals(folder2.getName())) continue;
            return folder2;
        }
        folder2 = new TypeFolder(name);
        if (Messages.TYPE_FOLDER_JAVA_APPLICATION.equals(name)) {
            folder2.setExpanded(true);
        }
        this.getFolders().add(folder2);
        return folder2;
    }

    public List<IVisitable> getChildren() {
        ArrayList<IVisitable> list = new ArrayList<IVisitable>();
        for (TypeFolder folder : this.getFolders()) {
            if (!folder.hasDiscoveredTypeDescriptor()) continue;
            list.add(folder);
        }
        for (TypeDescriptor desc : this.getTypeDescriptors()) {
            if (!desc.getDiscovered()) continue;
            list.add(desc);
        }
        return Collections.unmodifiableList(list);
    }

    private boolean hasDiscoveredTypeDescriptor() {
        for (TypeFolder folder : this.getFolders()) {
            if (!folder.hasDiscoveredTypeDescriptor()) continue;
            return true;
        }
        for (TypeDescriptor desc : this.getTypeDescriptors()) {
            if (!desc.getDiscovered()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void accept(IVisitor visistor) {
        visistor.visit(this);
    }
}

