/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.views.types;

import com.jrockit.mc.common.persistence.ISettingFetcher;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeDescriptor;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeFolder;
import com.jrockit.mc.flightrecorder.ui.views.types.visitor.IVisitable;
import com.jrockit.mc.flightrecorder.ui.views.types.visitor.IVisitor;
import java.util.List;

public final class TypeRespository
implements IVisitable {
    private static final String ROOT_FOLDER = "rootFolder";
    private static final String LINE_BREAK = "\n";
    private final Setting m_setting = new Setting("typeRepository");
    static boolean first;

    static {
        PersistenceToolkit.registerFetcher(TypeRespository.class, (ISettingFetcher)new ISettingFetcher<TypeRespository>(){

            public Setting getSetting(TypeRespository typeRespository) {
                return typeRespository.m_setting;
            }
        });
        first = true;
    }

    public TypeFolder getRootFolder() {
        return (TypeFolder)this.m_setting.getChildObject(ROOT_FOLDER, TypeFolder.class);
    }

    public void addTypeDescriptor(TypeDescriptor typeDescriptor) {
        String path = typeDescriptor.getPath();
        int separator = -1;
        TypeFolder folder = this.getRootFolder();
        while ((separator = path.indexOf(47, separator + 1)) >= 0) {
            folder = folder.getOrCreateFolderFromPath(path.substring(0, separator));
        }
        List<TypeDescriptor> descriptors = folder.getTypeDescriptors();
        for (TypeDescriptor td : descriptors) {
            if (!td.getPath().equals(path)) continue;
            td.setDiscovered(true);
            return;
        }
        descriptors.add(typeDescriptor);
        typeDescriptor.setDiscovered(true);
    }

    @Override
    public void accept(IVisitor visistor) {
        this.getRootFolder().accept(visistor);
    }

    public String toString() {
        return this.prettyPrint("", this.getRootFolder(), false);
    }

    private String prettyPrint(String indent, TypeFolder folder, boolean description) {
        indent = String.valueOf(indent) + "  ";
        StringBuilder builder = new StringBuilder();
        builder.append(String.valueOf(this.pad(String.valueOf(indent) + "[" + folder.getName() + "]")) + (description ? "|" : "") + LINE_BREAK);
        for (TypeDescriptor t : folder.getTypeDescriptors()) {
            builder.append(String.valueOf(this.pad(String.valueOf(indent) + "  " + t.getName())) + (description ? "|" + t.getDescription() : "") + LINE_BREAK);
        }
        for (TypeFolder f : folder.getFolders()) {
            builder.append(this.pad(this.prettyPrint(indent, f, description)));
        }
        return builder.toString();
    }

    private String pad(String string) {
        StringBuilder builder = new StringBuilder(string);
        while (builder.toString().length() < 60) {
            builder.append(' ');
        }
        return builder.toString();
    }
}

