/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.views.types.visitor;

import com.jrockit.mc.flightrecorder.ui.views.types.TypeDescriptor;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeFolder;
import com.jrockit.mc.flightrecorder.ui.views.types.visitor.CheckedVisitor;
import com.jrockit.mc.flightrecorder.ui.views.types.visitor.IVisitable;
import com.jrockit.mc.flightrecorder.ui.views.types.visitor.IVisitor;
import com.jrockit.mc.ui.fields.FilterMatcher;
import java.util.ArrayList;
import java.util.List;

public class MatchingVisitor
implements IVisitor {
    private final List<IVisitable> m_matching = new ArrayList<IVisitable>();
    private final FilterMatcher m_filterMatcher = FilterMatcher.getInstance();
    private String m_filterString = "";

    public MatchingVisitor(String filterString) {
    }

    public void setFilterText(String filterString) {
        this.m_matching.clear();
        this.m_filterString = "*" + filterString.toLowerCase() + "*";
    }

    @Override
    public void visit(TypeFolder folder) {
        this.folderMatch(folder);
    }

    private boolean folderMatch(TypeFolder folder) {
        boolean match = false;
        for (TypeDescriptor td : folder.getTypeDescriptors()) {
            if (!this.isDescriptorMatch(td)) continue;
            match = true;
            this.m_matching.add(td);
        }
        for (TypeFolder f : folder.getFolders()) {
            if (!this.folderMatch(f)) continue;
            match = true;
            this.m_matching.add(f);
        }
        if (this.isFolderMatch(folder)) {
            CheckedVisitor cv = new CheckedVisitor();
            folder.accept(cv);
            this.m_matching.addAll(cv.getAll());
            match = true;
        }
        if (match) {
            this.m_matching.add(folder);
        }
        return match;
    }

    public boolean isMatch(IVisitable visitable) {
        if (visitable instanceof TypeFolder) {
            return this.isFolderMatch((TypeFolder)visitable);
        }
        if (visitable instanceof TypeDescriptor) {
            return this.isDescriptorMatch((TypeDescriptor)visitable);
        }
        return false;
    }

    boolean isFolderMatch(TypeFolder folder) {
        return this.m_filterMatcher.matchCaseUnsensitive(folder.getName(), this.m_filterString);
    }

    boolean isDescriptorMatch(TypeDescriptor td) {
        return this.m_filterMatcher.matchCaseUnsensitive(td.getName(), this.m_filterString);
    }

    @Override
    public void visit(TypeDescriptor typeDescriptor) {
    }

    public List<IVisitable> getMatching() {
        return this.m_matching;
    }

    public boolean getMatchAll() {
        return this.m_filterString.length() == 2 && this.m_filterString.charAt(0) == '*';
    }
}

