/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rcp.start;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Properties;

public class MCMain {
    protected static final String ECLIPSE_LAUNCHER_PLUGIN_ID = "org.eclipse.equinox.launcher";
    protected static final String ECLIPSE_MAIN_CLASS = "org.eclipse.equinox.launcher.Main";
    protected static final String VERSION_FILE = "/version.properties";
    protected static final String FLAG_HELP = "-help";
    protected static final String FLAG_SHORT_HELP = "-?";
    protected static final String FLAG_VERSION = "-version";
    protected static final String FLAG_SHOWVERSION = "-showversion";
    protected static final String FLAG_DEBUG = "-debug";
    protected static final String FLAG_STARTUP = "-startup";
    protected static final String FLAG_SHOWSPLASH = "-showsplash";
    protected static final String FLAG_WS = "-ws";
    protected static final String FLAG_NAME = "-name";
    protected static final String FLAG_NOSPLASH = "-nosplash";
    protected static final String FLAG_HEADLESS = "-headless";
    protected static final File[] EMPTY_FILE_ARRAY = new File[0];
    protected LinkedList<String> orgArgs;
    protected List<String> newArgs;
    protected boolean showHelp;
    protected int splashTimeout = 600;
    protected URL startupJarURL;
    protected final boolean debug;

    public static void main(String[] args) {
        new MCMain(args).run();
    }

    protected MCMain(String[] args) {
        this.orgArgs = new LinkedList<String>(Arrays.asList(args));
        this.newArgs = new ArrayList<String>();
        this.debug = this.orgArgs.contains(FLAG_DEBUG);
        this.debugArgs(args, "Args recieved:");
    }

    public int run() {
        String[] processedArgs = this.process();
        if (this.debug) {
            System.out.println("System properties:");
            this.dumpProperties(System.getProperties());
            System.setProperty("com.jrockit.mc.debug", "true");
        }
        if (processedArgs == null) {
            return 1;
        }
        this.debugArgs(processedArgs, "Args to pass to Eclipse Main class:");
        Method mainMethod = this.getRealMainMethod();
        if (mainMethod != null) {
            try {
                mainMethod.invoke(null, new Object[]{processedArgs});
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            System.out.println("JMC has closed. You should shut down OSGi and the JVM manually.");
        } else {
            System.out.println("Could not find Eclipse main class.");
            if (this.debug) {
                if (this.startupJarURL != null) {
                    System.out.println("(Probably looked in " + this.startupJarURL + ".)");
                } else {
                    System.out.println("(Seems we used the existing class path only.)");
                }
            }
        }
        return 0;
    }

    protected String[] process() {
        boolean showSplash = true;
        boolean addName = true;
        String ws = null;
        ListIterator<String> args = this.orgArgs.listIterator();
        String arg = null;
        try {
            while (!this.showHelp && args.hasNext()) {
                arg = (String)args.next();
                if (FLAG_VERSION.equalsIgnoreCase(arg)) {
                    this.showVersion();
                    return null;
                }
                if (FLAG_SHOWVERSION.equalsIgnoreCase(arg)) {
                    this.showVersion();
                    args.remove();
                    continue;
                }
                if (FLAG_HELP.equalsIgnoreCase(arg) || FLAG_SHORT_HELP.equalsIgnoreCase(arg)) {
                    this.showHelp = true;
                    continue;
                }
                if (FLAG_DEBUG.equalsIgnoreCase(arg)) {
                    assert (this.debug);
                    continue;
                }
                if (FLAG_STARTUP.equalsIgnoreCase(arg)) {
                    this.startupJarURL = new File((String)args.next()).getCanonicalFile().toURI().toURL();
                    continue;
                }
                if (FLAG_WS.equalsIgnoreCase(arg)) {
                    ws = (String)args.next();
                    continue;
                }
                if (FLAG_SHOWSPLASH.equalsIgnoreCase(arg)) {
                    this.splashTimeout = Integer.parseInt(this.popOptValue(args));
                    continue;
                }
                if (FLAG_NOSPLASH.equalsIgnoreCase(arg)) {
                    showSplash = false;
                    args.remove();
                    continue;
                }
                if (FLAG_HEADLESS.equalsIgnoreCase(arg)) {
                    showSplash = false;
                    continue;
                }
                if (!FLAG_NAME.equalsIgnoreCase(arg)) continue;
                addName = false;
            }
        }
        catch (NoSuchElementException e) {
            System.out.println("ERROR: Value missing for option " + arg);
            this.showHelp = true;
        }
        catch (NumberFormatException e) {
            System.out.println("ERROR: Value for option " + arg + " must be an integer");
            this.showHelp = true;
        }
        catch (MalformedURLException e) {
            System.out.println("ERROR: Could not construct URL from value for option " + arg);
            this.showHelp = true;
        }
        catch (IOException e) {
            System.out.println("ERROR: I/O problem processing value for option " + arg);
            this.showHelp = true;
            this.handleException(e);
        }
        if (this.showHelp) {
            this.showHelp();
            return null;
        }
        if (showSplash) {
            this.addArgs(FLAG_SHOWSPLASH, Integer.toString(this.splashTimeout));
        }
        if (addName) {
            this.addArgs(FLAG_NAME, "Oracle Java Mission Control");
        }
        if (System.getProperty("osgi.ws", ws) == null) {
            boolean isWindows;
            String osName = System.getProperty("os.name");
            boolean bl = isWindows = osName.indexOf("Windows") != -1;
            if (!isWindows) {
                this.addArgs(FLAG_WS, "gtk");
            }
        }
        this.newArgs.addAll(this.orgArgs);
        return this.newArgs.toArray(new String[this.newArgs.size()]);
    }

    protected String popOptValue(ListIterator<String> argIter) {
        argIter.remove();
        String value = argIter.next();
        argIter.remove();
        return value;
    }

    protected void addArgs(String option, String value) {
        this.newArgs.add(option);
        this.newArgs.add(value);
    }

    protected void showHelp() {
        PrintStream out = System.out;
        out.println("Usage: jmc [options]");
        out.println();
        out.println("\t\twhere options include:");
        out.println("\t\t\t\t-? -help\t\t\t print this help message");
        out.println("\t\t\t\t-version\t\t\t print product version and exit");
        out.println("\t\t\t\t-showversion\t\t print product version and continue");
        out.println("\t\t\t\t-debug\t\t\t   enable startup debug messages");
        out.println("\t\t\t\t-J<VM option>\t\tsets the corresponding VM option");
    }

    protected void showVersion() {
        PrintStream out = System.out;
        Properties props = this.getVersionProperties();
        out.println("========================================");
        out.println("Oracle(R) Java Mission Control " + props.getProperty("jmc.version", ""));
        out.println("  java.vm.version = " + System.getProperty("java.vm.version"));
        if (props.size() == 0) {
            out.println("Detailed version information could not be found.");
        } else {
            this.dumpProperties(props);
        }
        out.println("========================================");
    }

    protected Properties getVersionProperties() {
        Properties props = new Properties();
        try {
            URL url = MCMain.class.getResource(VERSION_FILE);
            if (url != null) {
                props.load(url.openStream());
            }
        }
        catch (IOException ioe) {
            this.handleException(ioe);
        }
        return props;
    }

    protected void dumpProperties(Properties props) {
        for (Object key : props.keySet()) {
            System.out.println("  " + key + " = " + props.getProperty(key.toString()));
        }
    }

    protected void debugArgs(String[] args, String title) {
        if (this.debug) {
            System.out.println(title);
            for (String arg : args) {
                System.out.println("  " + arg);
            }
        }
    }

    protected void handleException(Exception e) {
        if (this.debug) {
            e.printStackTrace(System.out);
        }
    }

    protected File[] getInstalledSites() {
        try {
            return new File[]{this.getMcDir()};
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            return EMPTY_FILE_ARRAY;
        }
    }

    private File getMcDir() throws IOException {
        File mcDir = this.getCodeDir();
        if (mcDir.isDirectory()) {
            return mcDir;
        }
        throw new FileNotFoundException("Could not find missioncontrol directory " + mcDir);
    }

    protected File getCodeDir() throws IOException {
        try {
            CodeSource source = MCMain.class.getProtectionDomain().getCodeSource();
            URL url = source.getLocation();
            File file = new File(new URI(url.toExternalForm())).getCanonicalFile();
            if (file.isFile()) {
                file = file.getParentFile();
            }
            if (file.isDirectory()) {
                return file;
            }
            throw new FileNotFoundException("Jar directory " + file + " does not exist!");
        }
        catch (Exception e) {
            FileNotFoundException ioe = new FileNotFoundException("Could not find jar directory");
            ioe.initCause(e);
            throw ioe;
        }
    }

    protected File getLatest(File[] searchDirs, String subdir, String id) {
        String prefix = id + '_';
        String latest = "";
        File latestDir = null;
        for (int i = 0; i < searchDirs.length; ++i) {
            File searchDir = new File(searchDirs[i], subdir);
            String[] names = searchDir.list();
            if (names == null) continue;
            for (int j = 0; j < names.length; ++j) {
                String name = names[j];
                if (!name.startsWith(prefix) || name.compareTo(latest) <= 0) continue;
                latest = name;
                latestDir = searchDir;
            }
        }
        return latestDir != null ? new File(latestDir, latest) : null;
    }

    protected File getSimplePlugin(String pluginID) {
        return this.getLatest(this.getInstalledSites(), "plugins", pluginID);
    }

    protected URL getStartupJar() {
        if (this.startupJarURL == null) {
            File startupJar = this.getSimplePlugin(ECLIPSE_LAUNCHER_PLUGIN_ID);
            if (startupJar == null) {
                System.out.println("Could not find org.eclipse.equinox.launcher plugin. Trying with startup.jar.");
                File[] sites = this.getInstalledSites();
                for (int i = 0; i < sites.length; ++i) {
                    File candidate = new File(sites[i], "startup.jar");
                    if (!candidate.exists()) continue;
                    startupJar = candidate;
                    break;
                }
            }
            if (startupJar != null) {
                try {
                    this.startupJarURL = startupJar.getCanonicalFile().toURI().toURL();
                }
                catch (IOException ioe) {
                    this.handleException(ioe);
                }
            }
        }
        return this.startupJarURL;
    }

    protected Method getRealMainMethod() {
        ClassLoader loader = MCMain.class.getClassLoader();
        URL startupJarURL = this.getStartupJar();
        if (startupJarURL != null) {
            loader = this.extendLoaderWithURL(loader, startupJarURL);
        } else {
            System.out.println("Could not find startup.jar.");
        }
        return this.getRealMainMethod(loader);
    }

    protected final Method getRealMainMethod(ClassLoader loader) {
        try {
            Class<?> mainClass = Class.forName(ECLIPSE_MAIN_CLASS, true, loader);
            return mainClass.getMethod("main", String[].class);
        }
        catch (SecurityException e) {
            this.handleException(e);
        }
        catch (IllegalArgumentException e) {
            this.handleException(e);
        }
        catch (ClassNotFoundException e) {
            this.handleException(e);
        }
        catch (NoSuchMethodException e) {
            this.handleException(e);
        }
        return null;
    }

    protected final ClassLoader extendLoaderWithURL(ClassLoader loader, URL url) {
        if (loader instanceof URLClassLoader) {
            try {
                Method addURL = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                addURL.setAccessible(true);
                addURL.invoke((Object)loader, url);
                return loader;
            }
            catch (SecurityException e) {
                this.handleException(e);
            }
            catch (NoSuchMethodException e) {
                this.handleException(e);
            }
            catch (IllegalAccessException e) {
                this.handleException(e);
            }
            catch (InvocationTargetException e) {
                this.handleException(e);
            }
        }
        return new URLClassLoader(new URL[]{url}, loader);
    }
}

