/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.CLIHandler;
import org.netbeans.TopSecurityManager;
import org.netbeans.core.ExitDialog;
import org.netbeans.core.NbLoaderPool;
import org.netbeans.core.WindowSystem;
import org.netbeans.core.startup.CLIOptions;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.ModuleLifecycleManager;
import org.netbeans.core.startup.layers.SessionManager;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.SaveCookie;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;

public final class NbLifecycleManager
extends LifecycleManager {
    private static boolean doingExit = false;
    private static final Runnable DO_EXIT = new ExitActions(0);

    public void saveAll() {
        ArrayList<DataObject> arrayList = new ArrayList<DataObject>();
        NotifyDescriptor.Message message = DataObject.getRegistry().getModified();
        if (((DataObject[])message).length == 0) {
            return;
        }
        for (DataObject dataObject : message) {
            try {
                SaveCookie saveCookie = (SaveCookie)dataObject.getLookup().lookup(SaveCookie.class);
                if (saveCookie == null) continue;
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(NbLifecycleManager.class, (String)"CTL_FMT_SavingMessage", (Object)dataObject.getName()));
                saveCookie.save();
            }
            catch (IOException iOException) {
                Logger.getLogger(NbLifecycleManager.class.getName()).log(Level.WARNING, null, iOException);
                arrayList.add(dataObject);
            }
        }
        for (DataObject dataObject : arrayList) {
            NotifyDescriptor.Message message2 = new NotifyDescriptor.Message((Object)NbBundle.getMessage(NbLifecycleManager.class, (String)"CTL_Cannot_save", (Object)dataObject.getPrimaryFile().getName()));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message2);
        }
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(NbLifecycleManager.class, (String)"MSG_AllSaved"));
    }

    public void exit() {
        Mutex.EVENT.readAccess(DO_EXIT);
    }

    public void exit(int n) {
        ExitActions exitActions = new ExitActions(0, n);
        Mutex.EVENT.readAccess((Runnable)exitActions);
    }

    public static boolean isExiting() {
        return doingExit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doExit(int n) {
        block9: {
            if (doingExit) {
                return;
            }
            doingExit = true;
            try {
                if (System.getProperty("netbeans.close") == null && !ExitDialog.showDialog() || !Main.getModuleSystem().shutDown((Runnable)new ExitActions(1, n))) break block9;
                try {
                    try {
                        NbLoaderPool.store();
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(NbLifecycleManager.class.getName()).log(Level.WARNING, null, iOException);
                    }
                    SessionManager.getDefault().close();
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    Exceptions.printStackTrace((Throwable)throwable);
                }
                Task task = new Task((Runnable)new ExitActions(2, n));
                RequestProcessor.getDefault().post((Runnable)task);
                task.waitFinished();
            }
            finally {
                doingExit = false;
            }
        }
    }

    public void markForRestart() throws UnsupportedOperationException {
        new ModuleLifecycleManager().markForRestart();
    }

    private static class ExitActions
    implements Runnable {
        private final int type;
        private final int status;

        ExitActions(int n) {
            this.type = n;
            this.status = 0;
        }

        ExitActions(int n, int n2) {
            this.type = n;
            this.status = n2;
        }

        @Override
        public void run() {
            switch (this.type) {
                case 0: {
                    NbLifecycleManager.doExit(this.status);
                    break;
                }
                case 1: {
                    CLIHandler.stopServer();
                    WindowSystem windowSystem = (WindowSystem)Lookup.getDefault().lookup(WindowSystem.class);
                    boolean bl = CLIOptions.isGui();
                    if (windowSystem != null && bl) {
                        windowSystem.hide();
                        windowSystem.save();
                    }
                    if (!Boolean.getBoolean("netbeans.close.when.invisible")) break;
                    TopSecurityManager.exit((int)this.status);
                    break;
                }
                case 2: {
                    if (Boolean.getBoolean("netbeans.close.no.exit")) break;
                    TopSecurityManager.exit((int)this.status);
                    break;
                }
                default: {
                    throw new IllegalStateException("Type: " + this.type);
                }
            }
        }
    }
}

