/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.netbeans.modules.sampler.Sampler;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

final class TimableEventQueue
extends EventQueue
implements Runnable {
    private static final Logger LOG = Logger.getLogger(TimableEventQueue.class.getName());
    static final RequestProcessor RP = new RequestProcessor("Timeable Event Queue Watch Dog", 1, false);
    private static final int QUANTUM;
    private static final int REPORT;
    private static final int WAIT_CURSOR_LIMIT;
    private static final int PAUSE;
    private final RequestProcessor.Task TIMEOUT;
    private final RequestProcessor.Task WAIT_CURSOR_CHECKER;
    private volatile long ignoreTill;
    private volatile long start;
    private volatile Sampler stoppable;
    private volatile boolean isWaitCursor;
    static volatile Thread eq;
    private final Frame mainWindow;

    private TimableEventQueue(Frame frame) {
        this.mainWindow = frame;
        this.TIMEOUT = RP.create((Runnable)this);
        this.TIMEOUT.setPriority(1);
        this.WAIT_CURSOR_CHECKER = RP.create(new Runnable(){

            @Override
            public void run() {
                TimableEventQueue.this.isWaitCursor = (byte)(TimableEventQueue.this.isWaitCursor | (TimableEventQueue.isWaitCursor() ? 1 : 0));
            }
        }, true);
        this.WAIT_CURSOR_CHECKER.setPriority(1);
    }

    static void initialize() {
        TimableEventQueue.initialize(null, true);
    }

    static void initialize(final Frame frame, final boolean bl) {
        boolean bl2 = Boolean.valueOf(NbBundle.getMessage(TimableEventQueue.class, (String)"TimableEventQueue.install"));
        if (!bl2) {
            return;
        }
        try {
            Mutex.EVENT.writeAccess((Mutex.Action)new Mutex.Action<Void>(){

                public Void run() {
                    ClassLoader classLoader;
                    Frame frame2 = frame;
                    if (bl && frame2 == null) {
                        frame2 = WindowManager.getDefault().getMainWindow();
                    }
                    if ((classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class)) != null) {
                        Thread.currentThread().setContextClassLoader(classLoader);
                    }
                    Toolkit.getDefaultToolkit().getSystemEventQueue().push(new TimableEventQueue(frame2));
                    LOG.fine("Initialization done");
                    return null;
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dispatchEvent(AWTEvent aWTEvent) {
        eq = Thread.currentThread();
        boolean bl = false;
        try {
            bl = this.tick("dispatchEvent");
            super.dispatchEvent(aWTEvent);
        }
        finally {
            if (bl) {
                this.done();
            }
        }
    }

    private void done() {
        Sampler sampler;
        long l;
        this.TIMEOUT.cancel();
        this.TIMEOUT.waitFinished();
        if (!this.WAIT_CURSOR_CHECKER.cancel()) {
            this.WAIT_CURSOR_CHECKER.waitFinished();
        }
        LOG.log(Level.FINE, "isWait cursor {0}", this.isWaitCursor);
        if (this.isWaitCursor) {
            l = REPORT * 10;
            if (l > (long)WAIT_CURSOR_LIMIT) {
                l = WAIT_CURSOR_LIMIT > REPORT ? (long)WAIT_CURSOR_LIMIT : (long)REPORT;
            }
        } else {
            l = REPORT;
        }
        this.isWaitCursor = false;
        long l2 = System.currentTimeMillis() - this.start;
        if (l2 > (long)QUANTUM) {
            LOG.log(Level.FINE, "done, timer stopped, took {0}", l2);
            if (l2 > l) {
                LOG.log(Level.WARNING, "too much time in AWT thread {0}", this.stoppable);
                this.ignoreTill = System.currentTimeMillis() + (long)PAUSE;
                TimableEventQueue.report(this.stoppable, l2);
                this.stoppable = null;
            }
        } else {
            LOG.log(Level.FINEST, "done, timer stopped, took {0}", l2);
        }
        if ((sampler = this.stoppable) != null) {
            sampler.cancel();
            this.stoppable = null;
        }
    }

    private boolean isShowing() {
        return this.mainWindow == null || this.mainWindow.isShowing();
    }

    private boolean tick(String string) {
        this.start = System.currentTimeMillis();
        if (this.start >= this.ignoreTill && this.isShowing()) {
            LOG.log(Level.FINEST, "tick, schedule a timer for {0}", string);
            this.TIMEOUT.schedule(QUANTUM);
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        if (this.stoppable != null) {
            LOG.log(Level.WARNING, "Still previous controller {0}", this.stoppable);
            return;
        }
        Sampler sampler = TimableEventQueue.createSelfSampler();
        if (sampler != null) {
            sampler.start();
            this.stoppable = sampler;
        }
        this.isWaitCursor |= TimableEventQueue.isWaitCursor();
        if (!this.isWaitCursor) {
            this.WAIT_CURSOR_CHECKER.schedule(Math.max(REPORT - QUANTUM, 0));
        }
    }

    private static void report(final Sampler sampler, final long l) {
        if (sampler == null) {
            return;
        }
        class R
        implements Runnable {
            R() {
            }

            @Override
            public void run() {
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                    sampler.stopAndWriteTo(dataOutputStream);
                    dataOutputStream.close();
                    if (dataOutputStream.size() > 0) {
                        Object[] objectArray = new Object[]{byteArrayOutputStream.toByteArray(), l};
                        Logger.getLogger("org.netbeans.ui.performance").log(Level.CONFIG, "Slowness detected", objectArray);
                    } else {
                        LOG.log(Level.WARNING, "no snapshot taken");
                    }
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
            }
        }
        RP.post((Runnable)new R());
    }

    private static Sampler createSelfSampler() {
        return Sampler.createSampler((String)"awt");
    }

    private static boolean isWaitCursor() {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component != null) {
            if (component.getCursor().getType() == 3) {
                LOG.finer("wait cursor on focus owner");
                return true;
            }
            Window object = SwingUtilities.windowForComponent(component);
            if (object != null && TimableEventQueue.isWaitCursorOnWindow(object)) {
                LOG.finer("wait cursor on window");
                return true;
            }
        }
        for (Frame frame : Frame.getFrames()) {
            if (!TimableEventQueue.isWaitCursorOnWindow(frame)) continue;
            LOG.finer("wait cursor on frame");
            return true;
        }
        LOG.finest("no wait cursor");
        return false;
    }

    private static boolean isWaitCursorOnWindow(Window window) {
        Component component;
        JRootPane jRootPane;
        if (window.getCursor().getType() == 3) {
            return true;
        }
        return window instanceof JFrame && null != (jRootPane = ((JFrame)window).getRootPane()) && null != (component = jRootPane.getGlassPane()) && component.getCursor().getType() == 3;
    }

    static {
        int n = 10000;
        int n2 = 20000;
        if (!$assertionsDisabled) {
            n = 100;
            if (100 <= 0) {
                throw new AssertionError();
            }
        }
        if (!$assertionsDisabled) {
            n2 = 3000;
            if (3000 <= 0) {
                throw new AssertionError();
            }
        }
        QUANTUM = Integer.getInteger("org.netbeans.core.TimeableEventQueue.quantum", n);
        REPORT = Integer.getInteger("org.netbeans.core.TimeableEventQueue.report", n2);
        WAIT_CURSOR_LIMIT = Integer.getInteger("org.netbeans.core.TimeableEventQueue.waitcursor", 15000);
        PAUSE = Integer.getInteger("org.netbeans.core.TimeableEventQueue.pause", 15000);
    }
}

