/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.CharConversionException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.openide.loaders.DataObjectAccessor;
import org.netbeans.modules.openide.loaders.SimpleES;
import org.netbeans.modules.openide.loaders.UIException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.OpenSupport;
import org.openide.loaders.SaveAsCapable;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeOp;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.Line;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.UserQuestionException;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.CloneableOpenSupport;
import org.openide.xml.XMLUtil;

public class DataEditorSupport
extends CloneableEditorSupport {
    static final Logger ERR = Logger.getLogger("org.openide.text.DataEditorSupport");
    private final DataObject obj;
    private NodeListener nodeL;
    static boolean TABNAMES_HTML = Boolean.parseBoolean(System.getProperty("nb.tabnames.html", "true"));
    private static Set<FileObject> warnedEncodingFiles = new WeakSet();
    private static Map<DataObject, Charset> charsets = Collections.synchronizedMap(new HashMap());
    private static final Map<DataObject, Integer> cacheCounter = Collections.synchronizedMap(new HashMap());

    public DataEditorSupport(DataObject dataObject, CloneableEditorSupport.Env env) {
        this(dataObject, (Lookup)new DOEnvLookup(dataObject), env);
    }

    public DataEditorSupport(DataObject dataObject, @NullAllowed Lookup lookup, CloneableEditorSupport.Env env) {
        super(env, lookup == null ? dataObject.getLookup() : lookup);
        this.obj = dataObject;
    }

    final CloneableEditorSupport.Env desEnv() {
        return (CloneableEditorSupport.Env)this.env;
    }

    public static CloneableEditorSupport create(DataObject dataObject, MultiDataObject.Entry entry, CookieSet cookieSet) {
        return new SimpleES(dataObject, entry, cookieSet);
    }

    public static CloneableEditorSupport create(DataObject dataObject, MultiDataObject.Entry entry, CookieSet cookieSet, @NullAllowed Callable<CloneableEditorSupport.Pane> callable) {
        return new SimpleES(dataObject, entry, cookieSet, callable);
    }

    public final DataObject getDataObject() {
        return this.obj;
    }

    protected String messageOpening() {
        return NbBundle.getMessage(DataObject.class, (String)"CTL_ObjectOpen", (Object)this.obj.getPrimaryFile().getNameExt(), (Object)FileUtil.getFileDisplayName((FileObject)this.obj.getPrimaryFile()));
    }

    protected String messageOpened() {
        return null;
    }

    protected String messageSave() {
        return NbBundle.getMessage(DataObject.class, (String)"MSG_SaveFile", (Object)this.obj.getPrimaryFile().getNameExt());
    }

    public static String annotateName(String string, boolean bl, boolean bl2, boolean bl3) {
        Parameters.notNull((CharSequence)"original", (Object)string);
        if (bl && TABNAMES_HTML) {
            if (string.startsWith("<html>")) {
                string = string.substring(6);
            }
            if (bl2) {
                string = "<b>" + string + "</b>";
            }
            if (bl3) {
                string = "<i>" + string + "</i>";
            }
            return "<html>" + string;
        }
        if (bl && !string.startsWith("<html>")) {
            string = "<html>" + string;
        }
        int n = bl2 ? (bl3 ? 2 : 1) : (bl3 ? 0 : 3);
        try {
            return NbBundle.getMessage(DataObject.class, (String)"LAB_EditorName", (Object)n, (Object)string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string2 = NbBundle.getMessage(DataObject.class, (String)"LAB_EditorName");
            ERR.log(Level.WARNING, "#166035: formatting failed. pattern=" + string2 + ", version=" + n + ", name=" + string, illegalArgumentException);
            return string;
        }
    }

    protected String messageName() {
        if (!this.obj.isValid()) {
            return "";
        }
        return DataEditorSupport.annotateName(this.obj.getNodeDelegate().getDisplayName(), false, this.isModified(), !this.obj.getPrimaryFile().canWrite());
    }

    protected String messageHtmlName() {
        if (!this.obj.isValid()) {
            return null;
        }
        String string = this.obj.getNodeDelegate().getHtmlDisplayName();
        if (string == null) {
            try {
                string = XMLUtil.toElementContent((String)this.obj.getNodeDelegate().getDisplayName());
            }
            catch (CharConversionException charConversionException) {
                return null;
            }
        }
        return DataEditorSupport.annotateName(string, true, this.isModified(), !this.obj.getPrimaryFile().canWrite());
    }

    protected String documentID() {
        if (!this.obj.isValid()) {
            return "";
        }
        return this.obj.getPrimaryFile().getNameExt();
    }

    public static String toolTip(FileObject fileObject, boolean bl, boolean bl2) {
        String string = FileUtil.getFileDisplayName((FileObject)fileObject);
        if (TABNAMES_HTML) {
            if (bl) {
                string = string + NbBundle.getMessage(DataObject.class, (String)"TIP_editor_modified");
            }
            if (bl2) {
                string = string + NbBundle.getMessage(DataObject.class, (String)"TIP_editor_ro");
            }
        }
        return string;
    }

    protected String messageToolTip() {
        return DataEditorSupport.toolTip(this.obj.getPrimaryFile(), this.isModified(), !this.obj.getPrimaryFile().canWrite());
    }

    protected String messageLine(Line line) {
        return NbBundle.getMessage(DataObject.class, (String)"FMT_LineDisplayName2", (Object)this.obj.getPrimaryFile().getNameExt(), (Object)FileUtil.getFileDisplayName((FileObject)this.obj.getPrimaryFile()), (Object)new Integer(line.getLineNumber() + 1));
    }

    protected void initializeCloneableEditor(CloneableEditor cloneableEditor) {
        if (this.obj.isValid()) {
            Node node = this.obj.getNodeDelegate();
            cloneableEditor.setActivatedNodes(new Node[]{node});
            cloneableEditor.setIcon(node.getIcon(1));
            DataNodeListener dataNodeListener = new DataNodeListener(cloneableEditor);
            node.addNodeListener(NodeOp.weakNodeListener((NodeListener)dataNodeListener, (Object)node));
            this.nodeL = dataNodeListener;
        }
    }

    protected void notifyClosed() {
        this.nodeL = null;
        super.notifyClosed();
    }

    protected StyledDocument createStyledDocument(EditorKit editorKit) {
        StyledDocument styledDocument = super.createStyledDocument(editorKit);
        styledDocument.putProperty("title", FileUtil.getFileDisplayName((FileObject)this.obj.getPrimaryFile()));
        styledDocument.putProperty("stream", this.obj);
        Logger.getLogger("TIMER").log(Level.FINE, "Document", new Object[]{this.obj.getPrimaryFile(), styledDocument});
        return styledDocument;
    }

    protected boolean canClose() {
        if (this.desEnv().isModified() && this.isEnvReadOnly()) {
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(DataObject.class, (String)"MSG_FileReadOnlyClosing", (Object[])new Object[]{((Env)this.env).getFileImpl().getNameExt()}), 2, 2));
            return object == NotifyDescriptor.OK_OPTION;
        }
        return super.canClose();
    }

    protected void loadFromStreamToKit(StyledDocument styledDocument, InputStream inputStream, EditorKit editorKit) throws IOException, BadLocationException {
        InputStreamReader inputStreamReader;
        Charset charset = charsets.get(this.getDataObject());
        if (charset == null) {
            charset = FileEncodingQuery.getEncoding((FileObject)this.getDataObject().getPrimaryFile());
        }
        FileObject fileObject = this.getDataObject().getPrimaryFile();
        styledDocument.putProperty("default-line-separator", fileObject.getAttribute("default-line-separator"));
        if (warnedEncodingFiles.contains(fileObject)) {
            inputStreamReader = new InputStreamReader(inputStream, charset);
        } else {
            CharsetDecoder charsetDecoder = charset.newDecoder();
            charsetDecoder.reset();
            inputStreamReader = new InputStreamReader(inputStream, charsetDecoder);
        }
        try {
            editorKit.read(inputStreamReader, (Document)styledDocument, 0);
        }
        catch (CharacterCodingException characterCodingException) {
            ERR.log(Level.FINE, "Encoding problem using " + charset, characterCodingException);
            styledDocument.remove(0, styledDocument.getLength());
            DataEditorSupport.createAndThrowIncorrectCharsetUQE(fileObject, charset);
        }
        catch (IllegalStateException illegalStateException) {
            ERR.log(Level.FINE, "Encoding problem using " + charset, illegalStateException);
            styledDocument.remove(0, styledDocument.getLength());
            DataEditorSupport.createAndThrowIncorrectCharsetUQE(fileObject, charset);
        }
    }

    private static boolean createAndThrowIncorrectCharsetUQE(final FileObject fileObject, Charset charset) throws UserQuestionException {
        ERR.log(Level.INFO, "Encoding problem using {0} for {1}", new Object[]{charset, fileObject});
        throw new UserQuestionException(NbBundle.getMessage(DataObject.class, (String)"MSG_EncodingProblem", (Object)charset, (Object)fileObject.getPath())){

            public void confirmed() throws IOException {
                warnedEncodingFiles.add(fileObject);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int incrementCacheCounter(DataObject dataObject) {
        Map<DataObject, Integer> map = cacheCounter;
        synchronized (map) {
            Integer n = cacheCounter.get(dataObject);
            if (n == null) {
                n = 0;
            }
            Integer n2 = n;
            Integer n3 = n = Integer.valueOf(n + 1);
            cacheCounter.put(dataObject, n);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized int decrementCacheCounter(DataObject dataObject) {
        Map<DataObject, Integer> map = cacheCounter;
        synchronized (map) {
            Integer n = cacheCounter.get(dataObject);
            assert (n != null);
            Integer n2 = n;
            Integer n3 = n = Integer.valueOf(n - 1);
            if (n == 0) {
                cacheCounter.remove(dataObject);
            } else {
                cacheCounter.put(dataObject, n);
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveFromKitToStream(StyledDocument styledDocument, EditorKit editorKit, OutputStream outputStream) throws IOException, BadLocationException {
        if (styledDocument == null) {
            throw new NullPointerException("Document is null");
        }
        if (editorKit == null) {
            throw new NullPointerException("Kit is null");
        }
        Charset charset = charsets.get(this.getDataObject());
        if (charset == null) {
            charset = FileEncodingQuery.getEncoding((FileObject)this.getDataObject().getPrimaryFile());
        }
        FilterOutputStream filterOutputStream = new FilterOutputStream(outputStream){

            @Override
            public void close() throws IOException {
                this.flush();
            }
        };
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)filterOutputStream, charset);
        try {
            editorKit.write(outputStreamWriter, (Document)styledDocument, 0, styledDocument.getLength());
        }
        finally {
            ((Writer)outputStreamWriter).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyledDocument openDocument() throws IOException {
        DataObject dataObject = this.getDataObject();
        Charset charset = charsets.get(dataObject);
        if (charset == null) {
            charset = FileEncodingQuery.getEncoding((FileObject)dataObject.getPrimaryFile());
        }
        try {
            charsets.put(dataObject, charset);
            DataEditorSupport.incrementCacheCounter(dataObject);
            StyledDocument styledDocument = super.openDocument();
            return styledDocument;
        }
        finally {
            if (DataEditorSupport.decrementCacheCounter(dataObject) == 0) {
                charsets.remove(dataObject);
            }
            ERR.finest("openDocument - charset removed");
        }
    }

    public void saveDocument() throws IOException {
        SaveImpl saveImpl = new SaveImpl(this);
        FileUtil.runAtomicAction((FileSystem.AtomicAction)saveImpl);
    }

    final void superSaveDoc() throws IOException {
        super.saveDocument();
    }

    private boolean isEnvReadOnly() {
        CloneableEditorSupport.Env env = this.desEnv();
        return env instanceof Env && !((Env)env).getFileImpl().canWrite();
    }

    final DataObject getDataObjectHack2() {
        return this.obj;
    }

    final void callUpdateTitles() {
        this.updateTitles();
    }

    public static DataObject findDataObject(Line line) {
        if (line == null) {
            throw new NullPointerException();
        }
        return (DataObject)line.getLookup().lookup(DataObject.class);
    }

    public void saveAs(FileObject fileObject, String string) throws IOException {
        if (this.env instanceof Env) {
            DataFolder dataFolder;
            String string2 = FileUtil.getExtension((String)string);
            DataObject dataObject = null;
            DataObject dataObject2 = this.getDataObject();
            if (!dataObject2.isModified() || null == this.getDocument()) {
                dataFolder = DataFolder.findFolder(fileObject);
                FileObject fileObject2 = fileObject.getFileObject(string);
                if (null != fileObject2) {
                    fileObject2.delete();
                }
                dataObject = DataObjectAccessor.DEFAULT.copyRename(dataObject2, dataFolder, this.getFileNameNoExtension(string), string2);
            } else {
                dataFolder = FileUtil.createData((FileObject)fileObject, (String)string);
                this.saveDocumentAs(dataFolder.getOutputStream());
                dataObject2.setModified(false);
                dataObject = DataObject.find((FileObject)dataFolder);
            }
            if (null != dataObject && null != (dataFolder = dataObject.getCookie(OpenCookie.class))) {
                this.close(false);
                dataFolder.open();
            }
        }
    }

    private String getFileNameNoExtension(String string) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    private void saveDocumentAs(final OutputStream outputStream) throws IOException {
        final StyledDocument styledDocument = this.getDocument();
        class SaveAsWriter
        implements Runnable {
            private IOException ex;

            SaveAsWriter() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    BufferedOutputStream bufferedOutputStream = null;
                    try {
                        bufferedOutputStream = new BufferedOutputStream(outputStream);
                        DataEditorSupport.this.saveFromKitToStream(styledDocument, bufferedOutputStream);
                        ((OutputStream)bufferedOutputStream).close();
                        bufferedOutputStream = null;
                    }
                    catch (BadLocationException badLocationException) {
                        ERR.log(Level.INFO, null, badLocationException);
                    }
                    finally {
                        if (bufferedOutputStream != null) {
                            ((OutputStream)bufferedOutputStream).close();
                        }
                    }
                }
                catch (IOException iOException) {
                    this.ex = iOException;
                }
            }

            public void after() throws IOException {
                if (this.ex != null) {
                    throw this.ex;
                }
            }
        }
        SaveAsWriter saveAsWriter = new SaveAsWriter();
        styledDocument.render(saveAsWriter);
        saveAsWriter.after();
    }

    private void saveFromKitToStream(StyledDocument styledDocument, OutputStream outputStream) throws IOException, BadLocationException {
        EditorKit editorKit = this.createEditorKit();
        this.saveFromKitToStream(styledDocument, editorKit, outputStream);
    }

    private static class SaveImpl
    implements FileSystem.AtomicAction {
        private static final SaveImpl DEFAULT = new SaveImpl(null);
        private final DataEditorSupport des;

        public SaveImpl(DataEditorSupport dataEditorSupport) {
            this.des = dataEditorSupport;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws IOException {
            if (this.des.desEnv().isModified() && this.des.isEnvReadOnly()) {
                IOException iOException = new IOException("File is read-only: " + ((Env)this.des.env).getFileImpl());
                UIException.annotateUser(iOException, null, NbBundle.getMessage(DataObject.class, (String)"MSG_FileReadOnlySaving", (Object[])new Object[]{((Env)this.des.env).getFileImpl().getNameExt()}), null, null);
                throw iOException;
            }
            DataObject dataObject = this.des.getDataObject();
            Charset charset = (Charset)charsets.get(dataObject);
            if (charset == null) {
                charset = FileEncodingQuery.getEncoding((FileObject)dataObject.getPrimaryFile());
            }
            try {
                charsets.put(dataObject, charset);
                DataEditorSupport.incrementCacheCounter(dataObject);
                ERR.finest("SaveImpl - charset put");
                this.des.superSaveDoc();
            }
            finally {
                if (DataEditorSupport.decrementCacheCounter(dataObject) == 0) {
                    charsets.remove(dataObject);
                }
            }
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        public boolean equals(Object object) {
            return object != null && this.getClass() == object.getClass();
        }
    }

    private static class DOEnvLookup
    extends AbstractLookup
    implements PropertyChangeListener {
        static final long serialVersionUID = 333L;
        private DataObject dobj;
        private InstanceContent ic;

        public DOEnvLookup(DataObject dataObject) {
            this(dataObject, new InstanceContent());
        }

        private DOEnvLookup(DataObject dataObject, InstanceContent instanceContent) {
            super((AbstractLookup.Content)instanceContent);
            this.ic = instanceContent;
            this.dobj = dataObject;
            dataObject.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)dataObject));
            this.updateLookup();
        }

        private void updateLookup() {
            this.ic.set(Arrays.asList(this.dobj, this.dobj.getPrimaryFile()), null);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == null || string.equals("primaryFile")) {
                this.updateLookup();
            }
        }
    }

    private final class DataNodeListener
    extends NodeAdapter {
        CloneableEditor editor;

        DataNodeListener(CloneableEditor cloneableEditor) {
            this.editor = cloneableEditor;
        }

        public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
            Mutex.EVENT.writeAccess(new Runnable(){

                @Override
                public void run() {
                    if ("displayName".equals(propertyChangeEvent.getPropertyName())) {
                        DataEditorSupport.this.callUpdateTitles();
                    }
                    if ("icon".equals(propertyChangeEvent.getPropertyName()) && DataEditorSupport.this.obj.isValid()) {
                        DataNodeListener.this.editor.setIcon(DataEditorSupport.this.obj.getNodeDelegate().getIcon(1));
                    }
                }
            });
        }
    }

    private static final class EnvListener
    extends FileChangeAdapter {
        private Reference<Env> env;

        public EnvListener(FileObject fileObject, Env env) {
            this.env = new WeakReference<Env>(env);
            this.addFileChangeListener(fileObject);
        }

        private void addFileChangeListener(FileObject fileObject) {
            try {
                fileObject.getFileSystem().addFileChangeListener((FileChangeListener)this);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ERR.log(Level.INFO, "cannot add listener to " + fileObject, fileStateInvalidException);
            }
        }

        private void removeFileChangeListener(FileObject fileObject) {
            try {
                fileObject.getFileSystem().removeFileChangeListener((FileChangeListener)this);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ERR.log(Level.INFO, "cannot remove listener from " + fileObject, fileStateInvalidException);
            }
        }

        public void fileDeleted(FileEvent fileEvent) {
            Env env = this.env.get();
            FileObject fileObject = fileEvent.getFile();
            if (env != null) {
                env.updateDocumentProperty();
            }
            if (env == null || env.getFileImpl() == null) {
                this.removeFileChangeListener(fileObject);
                return;
            }
            if (env.getFileImpl() == fileObject) {
                this.removeFileChangeListener(fileObject);
                env.fileRemoved(true);
                this.addFileChangeListener(fileObject);
            }
        }

        public void fileChanged(FileEvent fileEvent) {
            if (fileEvent.firedFrom((FileSystem.AtomicAction)SaveImpl.DEFAULT)) {
                return;
            }
            Env env = this.env.get();
            if (env == null || env.getFileImpl() == null) {
                this.removeFileChangeListener(fileEvent.getFile());
                return;
            }
            if (env.getFileImpl() != fileEvent.getFile()) {
                return;
            }
            if (fileEvent.getFile().isVirtual()) {
                fileEvent.getFile().removeFileChangeListener((FileChangeListener)this);
                env.fileRemoved(true);
                fileEvent.getFile().addFileChangeListener((FileChangeListener)this);
            } else {
                env.fileChanged(fileEvent);
            }
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            Env env = this.env.get();
            if (env != null) {
                env.updateDocumentProperty();
                env.fileRenamed();
            }
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
            Env env = this.env.get();
            if (env == null || env.getFileImpl() != fileAttributeEvent.getFile()) {
                return;
            }
            if ("DataEditorSupport.read-only.refresh".equals(fileAttributeEvent.getName())) {
                env.readOnlyRefresh();
            }
        }
    }

    public static abstract class Env
    extends OpenSupport.Env
    implements CloneableEditorSupport.Env {
        private static final long serialVersionUID = -2945098431098324441L;
        private transient FileObject fileObject;
        transient FileLock fileLock;
        private static transient Set<FileObject> warnedFiles = new HashSet<FileObject>();
        private transient FileSystem.AtomicAction action = null;
        private transient boolean canWrite;

        public Env(DataObject dataObject) {
            super(dataObject);
            this.canWrite = dataObject.getPrimaryFile().canWrite();
        }

        private FileObject getFileImpl() {
            this.changeFile();
            return this.fileObject;
        }

        protected abstract FileObject getFile();

        protected abstract FileLock takeLock() throws IOException;

        protected final void changeFile() {
            boolean bl;
            FileObject fileObject = this.getFile();
            if (fileObject.equals(this.fileObject)) {
                return;
            }
            if (this.fileLock != null) {
                if (this.fileLock.isValid()) {
                    ERR.fine("changeFile releaseLock: " + this.fileLock + " for " + this.fileObject);
                    this.fileLock.releaseLock();
                    bl = true;
                } else {
                    this.fileLock = null;
                    bl = false;
                }
            } else {
                bl = false;
            }
            boolean bl2 = this.fileObject == null;
            this.fileObject = fileObject;
            ERR.fine("changeFile: " + fileObject + " for " + this.fileObject);
            new EnvListener(this.fileObject, this);
            if (bl) {
                try {
                    this.fileLock = this.takeLock();
                    ERR.fine("changeFile takeLock: " + this.fileLock + " for " + this.fileObject);
                }
                catch (IOException iOException) {
                    Logger.getLogger(DataEditorSupport.class.getName()).log(Level.WARNING, null, iOException);
                }
            }
            if (!bl2) {
                this.firePropertyChange("expectedTime", null, this.getTime());
            }
        }

        public InputStream inputStream() throws IOException {
            FileObject fileObject = this.getFileImpl();
            if (!warnedFiles.contains(fileObject) && fileObject.getSize() > 0x100000L) {
                throw new ME(fileObject.getSize());
            }
            InputStream inputStream = this.getFileImpl().getInputStream();
            return inputStream;
        }

        public OutputStream outputStream() throws IOException {
            ERR.fine("outputStream: " + this.fileLock + " for " + this.fileObject);
            if (this.fileLock == null || !this.fileLock.isValid()) {
                this.fileLock = this.takeLock();
            }
            ERR.fine("outputStream after takeLock: " + this.fileLock + " for " + this.fileObject);
            try {
                return this.getFileImpl().getOutputStream(this.fileLock);
            }
            catch (IOException iOException) {
                if (this.fileLock == null || !this.fileLock.isValid()) {
                    this.fileLock = this.takeLock();
                }
                ERR.fine("ugly workaround for #40552: " + this.fileLock + " for " + this.fileObject);
                return this.getFileImpl().getOutputStream(this.fileLock);
            }
        }

        public Date getTime() {
            this.action = new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    Env.this.getFileImpl().refresh(false);
                }
            };
            try {
                this.getFileImpl().getFileSystem().runAtomicAction(this.action);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.getFileImpl().lastModified();
        }

        public String getMimeType() {
            return this.getFileImpl().getMIMEType();
        }

        @Override
        public void markModified() throws IOException {
            if (this.fileLock == null || !this.fileLock.isValid()) {
                this.fileLock = this.takeLock();
            }
            ERR.fine("markModified: " + this.fileLock + " for " + this.fileObject);
            if (!this.getFileImpl().canWrite()) {
                if (this.fileLock != null && this.fileLock.isValid()) {
                    this.fileLock.releaseLock();
                }
                throw new IOException("File " + this.getFileImpl().getNameExt() + " is read-only!");
            }
            this.getDataObject().setModified(true);
        }

        @Override
        public void unmarkModified() {
            ERR.fine("unmarkModified: " + this.fileLock + " for " + this.fileObject);
            if (this.fileLock != null && this.fileLock.isValid()) {
                this.fileLock.releaseLock();
                ERR.fine("releaseLock: " + this.fileLock + " for " + this.fileObject);
            }
            this.getDataObject().setModified(false);
        }

        final void fileChanged(FileEvent fileEvent) {
            ERR.fine("fileChanged: " + fileEvent.isExpected() + " for " + this.fileObject);
            if (this.action != null && fileEvent.firedFrom(this.action)) {
                return;
            }
            if (fileEvent.isExpected()) {
                this.firePropertyChange("time", null, null);
            } else {
                this.firePropertyChange("time", null, new Date(fileEvent.getTime()));
            }
        }

        private void readOnlyRefresh() {
            boolean bl = this.canWrite;
            this.canWrite = this.getFileImpl().canWrite();
            if (bl != this.canWrite) {
                if (!this.canWrite && this.isModified()) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(DataObject.class, (String)"MSG_FileReadOnlyChanging", (Object[])new Object[]{this.getFileImpl().getNameExt()}), 2));
                }
                this.firePropertyChange("DataEditorSupport.read-only.changing", null, null);
            }
        }

        final void fileRemoved(boolean bl) {
        }

        final void updateDocumentProperty() {
            StyledDocument styledDocument;
            EditorCookie editorCookie = this.getDataObject().getCookie(EditorCookie.class);
            if (editorCookie != null && (styledDocument = editorCookie.getDocument()) != null) {
                styledDocument.putProperty("title", FileUtil.getFileDisplayName((FileObject)this.getDataObject().getPrimaryFile()));
            }
        }

        final void fileRenamed() {
            this.firePropertyChange("expectedTime", null, this.getTime());
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            objectInputStream.defaultReadObject();
            objectInputStream.registerValidation(new ObjectInputValidation(){

                @Override
                public void validateObject() throws InvalidObjectException {
                    warnedFiles.add(Env.this.getFileImpl());
                }
            }, 0);
        }

        class ME
        extends UserQuestionException {
            static final long serialVersionUID = 1L;
            private long size;

            public ME(long l) {
                super("The file is too big. " + l + " bytes.");
                this.size = l;
            }

            public String getLocalizedMessage() {
                Object[] objectArray = new Object[]{Env.this.getFileImpl().getPath(), Env.this.getFileImpl().getNameExt(), new Long(this.size), new Long(this.size / 1024L + 1L), new Long(this.size / 0x100000L), new Long(this.size / 0x40000000L)};
                return NbBundle.getMessage(DataObject.class, (String)"MSG_ObjectIsTooBig", (Object[])objectArray);
            }

            public void confirmed() {
                warnedFiles.add(Env.this.getFileImpl());
            }
        }

        private class SaveAsCapableImpl
        implements SaveAsCapable {
            private SaveAsCapableImpl() {
            }

            @Override
            public void saveAs(FileObject fileObject, String string) throws IOException {
                CloneableOpenSupport cloneableOpenSupport = Env.super.findCloneableOpenSupport();
                if (cloneableOpenSupport instanceof DataEditorSupport) {
                    ((DataEditorSupport)cloneableOpenSupport).saveAs(fileObject, string);
                }
            }
        }
    }
}

