/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.system;

import com.jrockit.mc.console.ui.system.MemoryPoolInformation;
import com.jrockit.mc.console.ui.system.MemoryPoolModel;
import com.jrockit.mc.ui.fields.AbstractFieldTableContentProvider;
import com.jrockit.mc.ui.fields.FieldToolkit;
import com.jrockit.mc.ui.model.fields.ByteField;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.model.fields.PercentageField;
import com.jrockit.mc.ui.model.fields.StringField;

public class AllPoolsContentProvider
extends AbstractFieldTableContentProvider {
    private static int FIELDCOUNT = 0;
    public static final Field FIELD_POOL_NAME = new StringField(FIELDCOUNT++);
    public static final Field FIELD_POOL_TYPE = new StringField(FIELDCOUNT++);
    public static final Field FIELD_POOL_CUR_USED = new ByteField(FIELDCOUNT++);
    public static final Field FIELD_POOL_CUR_MAX = new ByteField(FIELDCOUNT++);
    public static final Field FIELD_POOL_CUR_USAGE = new PercentageField(FIELDCOUNT++);
    public static final Field FIELD_POOL_PEAK_USED = new ByteField(FIELDCOUNT++);
    public static final Field FIELD_POOL_PEAK_MAX = new ByteField(FIELDCOUNT++);

    static {
        FieldToolkit.initializeFields((String)"com.jrockit.mc.console.ui.system.fields", AllPoolsContentProvider.class);
    }

    public Object[] getRowElements(Object inputElement) {
        Object[] pools = ((MemoryPoolModel)inputElement).getAllPools();
        if (pools != null) {
            return pools;
        }
        return new Object[0];
    }

    public Object[] getColumnObject(Object inputRowElement) {
        if (inputRowElement instanceof MemoryPoolInformation) {
            MemoryPoolInformation poolInfo = (MemoryPoolInformation)inputRowElement;
            Object[] result = new Object[FIELDCOUNT];
            result[AllPoolsContentProvider.FIELD_POOL_NAME.INDEX] = poolInfo.getPoolName();
            result[AllPoolsContentProvider.FIELD_POOL_TYPE.INDEX] = poolInfo.getPoolType();
            result[AllPoolsContentProvider.FIELD_POOL_CUR_USED.INDEX] = poolInfo.getCurUsed();
            result[AllPoolsContentProvider.FIELD_POOL_CUR_MAX.INDEX] = this.getValueOrNull(poolInfo.getCurMax());
            result[AllPoolsContentProvider.FIELD_POOL_CUR_USAGE.INDEX] = this.getValueOrNull(poolInfo.getCurUsage());
            result[AllPoolsContentProvider.FIELD_POOL_PEAK_USED.INDEX] = poolInfo.getPeakUsed();
            result[AllPoolsContentProvider.FIELD_POOL_PEAK_MAX.INDEX] = this.getValueOrNull(poolInfo.getPeakMax());
            return result;
        }
        return new Object[0];
    }

    private Object getValueOrNull(double curUsage) {
        return curUsage == -1.0 ? null : Double.valueOf(curUsage);
    }

    private Object getValueOrNull(long curMax) {
        return curMax == -1L ? null : Long.valueOf(curMax);
    }
}

