/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.system;

import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.console.ui.actions.ResetToDefaultsAction;
import com.jrockit.mc.console.ui.editor.ConsoleTab;
import com.jrockit.mc.console.ui.system.Messages;
import com.jrockit.mc.console.ui.system.SystemPlugin;
import com.jrockit.mc.rjmx.services.IVirtualMachineService;
import com.jrockit.mc.rjmx.subscription.IMBeanHelperService;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.ui.AttributeVisualizerBuilder;
import com.jrockit.mc.rjmx.ui.internal.AttributeFieldTableSectionPart;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.misc.DialogToolkit;
import com.jrockit.mc.ui.misc.VerticalSectionLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import javax.management.ObjectName;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.w3c.dom.Element;

public class GcTab
extends ConsoleTab
implements XmlEnabled {
    public static final String PREFERENCE_KEY_GC_DATA = "gcData";
    private ArrayList<ObjectName> gcNames;
    private ArrayList<AttributeFieldTableSectionPart> gcTables;

    private void findGcNames() {
        IMBeanHelperService h = (IMBeanHelperService)this.getConnectionHandle().getServiceOrDummy(IMBeanHelperService.class);
        try {
            for (Map.Entry entry : h.getMBeanInfos().entrySet()) {
                ObjectName o = (ObjectName)entry.getKey();
                if (!o.getDomain().equals("java.lang") || !"GarbageCollector".equals(o.getKeyProperty("type"))) continue;
                this.gcNames.add(o);
            }
        }
        catch (IOException e1) {
            this.gcNames.clear();
        }
    }

    private void addGcAction(ContributionManager manager) {
        ActionContributionItem gcItem = new ActionContributionItem((IAction)new GCAction());
        gcItem.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        manager.insert(0, (IContributionItem)gcItem);
        manager.update(true);
        gcItem.getWidget().setData("name", (Object)gcItem.getAction().getId());
    }

    private void addResetAction(ContributionManager manager) {
        ActionContributionItem aci = new ActionContributionItem((IAction)new ResetToDefaultsAction(){

            protected void reset() {
                GcTab.this.initializeGcTables();
            }
        });
        aci.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        manager.insert(0, (IContributionItem)aci);
        manager.update(true);
    }

    private void addActions(ContributionManager manager) {
        this.addGcAction(manager);
        this.addResetAction(manager);
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.gcNames = new ArrayList();
        this.gcTables = new ArrayList();
        this.findGcNames();
        ScrolledForm form = managedForm.getForm();
        form.getBody().setLayout((Layout)new VerticalSectionLayout());
        IToolBarManager toolbarManager = form.getToolBarManager();
        if (toolbarManager instanceof ContributionManager) {
            this.addActions((ContributionManager)toolbarManager);
        } else {
            SystemPlugin.getDefault().getLogger().severe("Eclipse implementation changed! Could not create toolbar!");
        }
        AttributeVisualizerBuilder guiBuilder = new AttributeVisualizerBuilder(managedForm, this.getConnectionHandle());
        for (ObjectName o : this.gcNames) {
            guiBuilder.clearProperties();
            guiBuilder.setProperty("title", (Object)o.getKeyProperty("name"));
            guiBuilder.setProperty("sectionIdentifier", (Object)"com.jrockit.mc.console.ui.system.help_GarbageCollector");
            this.gcTables.add(guiBuilder.createTable());
        }
        if (!this.initTabFromStore(SystemPlugin.getDefault().getPreferenceStore(), PREFERENCE_KEY_GC_DATA, this)) {
            this.initializeGcTables();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        this.exportTabToStore(SystemPlugin.getDefault().getPreferenceStore(), PREFERENCE_KEY_GC_DATA, this);
    }

    private MRI buildGcTimeMRI(IMRIMetaDataService h, ObjectName gcName) {
        MRI mri = new MRI(MRI.Type.ATTRIBUTE, gcName, "CollectionTime");
        h.setMetaData(mri, "DisplayName", (Object)Messages.GcTab_COLLECTION_TIME_TEXT);
        h.setMetaData(mri, "UnitString", (Object)"ms");
        h.setMetaData(mri, "color", (Object)"#800000");
        return mri;
    }

    private MRI buildGcCountMRI(IMRIMetaDataService h, ObjectName gcName) {
        MRI mri = new MRI(MRI.Type.ATTRIBUTE, gcName, "CollectionCount");
        h.setMetaData(mri, "DisplayName", (Object)Messages.GcTab_COLLECTION_COUNT_TEXT);
        h.setMetaData(mri, "color", (Object)"#f00000");
        return mri;
    }

    private MRI buildLastStartTimeMRI(IMRIMetaDataService h, ObjectName gcName) {
        MRI mri = new MRI(MRI.Type.ATTRIBUTE, gcName, "LastGcInfo/startTime");
        h.setMetaData(mri, "DisplayName", (Object)Messages.GcTab_LAST_STARTED_TEXT);
        h.setMetaData(mri, "UnitString", (Object)"ms");
        h.setMetaData(mri, "color", (Object)"#008000");
        return mri;
    }

    private MRI buildLastEndedTimeMRI(IMRIMetaDataService h, ObjectName gcName) {
        MRI mri = new MRI(MRI.Type.ATTRIBUTE, gcName, "LastGcInfo/endTime");
        h.setMetaData(mri, "DisplayName", (Object)Messages.GcTab_LAST_ENDED_TEXT);
        h.setMetaData(mri, "UnitString", (Object)"ms");
        h.setMetaData(mri, "color", (Object)"#00f000");
        return mri;
    }

    private MRI buildLastDurationMRI(IMRIMetaDataService h, ObjectName gcName) {
        MRI mri = new MRI(MRI.Type.ATTRIBUTE, gcName, "LastGcInfo/duration");
        h.setMetaData(mri, "DisplayName", (Object)Messages.GcTab_LAST_DURATION_TEXT);
        h.setMetaData(mri, "UnitString", (Object)"ms");
        h.setMetaData(mri, "color", (Object)"#000080");
        return mri;
    }

    private MRI buildLastIdMRI(IMRIMetaDataService h, ObjectName gcName) {
        MRI mri = new MRI(MRI.Type.ATTRIBUTE, gcName, "LastGcInfo/id");
        h.setMetaData(mri, "DisplayName", (Object)Messages.GcTab_LAST_ID_TEXT);
        h.setMetaData(mri, "color", (Object)"#0000f0");
        return mri;
    }

    private MRI buildLastThreadCountMRI(IMRIMetaDataService h, ObjectName gcName) {
        MRI mri = new MRI(MRI.Type.ATTRIBUTE, gcName, "LastGcInfo/GcThreadCount");
        h.setMetaData(mri, "DisplayName", (Object)Messages.GcTab_LAST_THREADCOUNT_TEXT);
        h.setMetaData(mri, "color", (Object)"#123456");
        return mri;
    }

    private void initializeGcTables() {
        IMRIMetaDataService h = (IMRIMetaDataService)this.getConnectionHandle().getServiceOrDummy(IMRIMetaDataService.class);
        int i = 0;
        while (i < this.gcNames.size()) {
            AttributeFieldTableSectionPart gcTable = this.gcTables.get(i);
            ObjectName gcName = this.gcNames.get(i);
            gcTable.clear();
            gcTable.add(this.buildGcTimeMRI(h, gcName));
            gcTable.add(this.buildGcCountMRI(h, gcName));
            gcTable.add(this.buildLastStartTimeMRI(h, gcName));
            gcTable.add(this.buildLastEndedTimeMRI(h, gcName));
            gcTable.add(this.buildLastDurationMRI(h, gcName));
            gcTable.add(this.buildLastIdMRI(h, gcName));
            gcTable.add(this.buildLastThreadCountMRI(h, gcName));
            gcTable.markStale();
            gcTable.refreshPart();
            ++i;
        }
    }

    public String getComponentTag() {
        return "GcTab";
    }

    public void exportToXml(Element parentNode) {
        Element e = XmlToolkit.createElement((Element)parentNode, (String)this.getComponentTag());
        e.setAttribute("uid", this.getConnectionHandle().getServerDescriptor().getGUID());
        for (AttributeFieldTableSectionPart gcTable : this.gcTables) {
            gcTable.exportToXml(e);
        }
    }

    public void initializeFromXml(Element node) throws Exception {
        this.initializeGcTables();
    }

    class GCAction
    extends Action {
        public GCAction() {
            super(null, 1);
            if (UIPlugin.getDefault().getPreferenceStore().getBoolean("accessibility.buttonsAsText")) {
                this.setText(Messages.MemoryTab_RUN_GC_ACTION_DESCRIPTION_TEXT);
            }
            this.setToolTipText(Messages.MemoryTab_RUN_GC_ACTION_DESCRIPTION_TEXT);
            this.setImageDescriptor(UIPlugin.getDefault().getMCImageDescriptor("trash.png"));
            this.setId("gc");
        }

        public void run() {
            try {
                ((IVirtualMachineService)GcTab.this.getConnectionHandle().getServiceOrDummy(IVirtualMachineService.class)).gc();
            }
            catch (UnsupportedOperationException o) {
                SystemPlugin.getDefault().getLogger().log(Level.SEVERE, Messages.MemoryTab_TITLE_COULD_NOT_RUN_GC, o);
                DialogToolkit.showException((Shell)GcTab.this.getEditorSite().getShell(), (String)Messages.MemoryTab_TITLE_COULD_NOT_RUN_GC, (String)Messages.MemoryTab_MESSAGE_COULD_NOT_RUN_GC, (Throwable)o);
            }
            catch (IOException o) {
                SystemPlugin.getDefault().getLogger().log(Level.SEVERE, Messages.MemoryTab_TITLE_COULD_NOT_RUN_GC, o);
                DialogToolkit.showException((Shell)GcTab.this.getEditorSite().getShell(), (String)Messages.MemoryTab_TITLE_COULD_NOT_RUN_GC, (Throwable)o);
            }
        }
    }
}

