/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.system;

import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.console.ui.editor.ConsoleTab;
import com.jrockit.mc.console.ui.system.MemoryPoolModel;
import com.jrockit.mc.console.ui.system.MemoryPoolTableSectionPart;
import com.jrockit.mc.console.ui.system.SystemPlugin;
import com.jrockit.mc.ui.misc.VerticalSectionLayout;
import com.jrockit.mc.ui.polling.PollManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.w3c.dom.Element;

public class MemoryPoolsTab
extends ConsoleTab
implements XmlEnabled {
    public static final String PREFERENCE_KEY_MEMORYPOOLS_DATA = "memoryPoolsData";
    private MemoryPoolModel m_model;

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.m_model = new MemoryPoolModel(this.getConnectionHandle());
        if (!this.initTabFromStore(SystemPlugin.getDefault().getPreferenceStore(), PREFERENCE_KEY_MEMORYPOOLS_DATA, this)) {
            this.createDefaults(managedForm);
        }
    }

    private void createDefaults(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        form.getBody().setLayout((Layout)new VerticalSectionLayout());
        MemoryPoolTableSectionPart poolTable = new MemoryPoolTableSectionPart(form.getBody(), managedForm.getToolkit(), this.m_model, "console.memorypools");
        managedForm.addPart((IFormPart)poolTable);
        this.m_model.getPollManager().addPollee((PollManager.Pollable)poolTable);
    }

    public void doSave(IProgressMonitor monitor) {
        this.exportTabToStore(SystemPlugin.getDefault().getPreferenceStore(), PREFERENCE_KEY_MEMORYPOOLS_DATA, this);
    }

    public String getComponentTag() {
        return "MemoryPoolsTab";
    }

    public void exportToXml(Element parentNode) {
    }

    public void initializeFromXml(Element node) throws Exception {
        this.createDefaults(this.getManagedForm());
    }
}

