/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.system;

import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.console.ui.actions.ResetToDefaultsAction;
import com.jrockit.mc.console.ui.editor.ConsoleTab;
import com.jrockit.mc.console.ui.system.Messages;
import com.jrockit.mc.console.ui.system.SystemPlugin;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.ui.AttributeVisualizerBuilder;
import com.jrockit.mc.rjmx.ui.internal.AttributeFieldTableSectionPart;
import com.jrockit.mc.rjmx.ui.internal.ChartModel;
import com.jrockit.mc.rjmx.ui.internal.CombinedChartSectionPart;
import com.jrockit.mc.ui.misc.VerticalSectionLayout;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MemoryTab
extends ConsoleTab
implements XmlEnabled {
    public static final String PREFERENCE_KEY_MEMORY_DATA = "memoryData";
    private CombinedChartSectionPart memoryChartPart;
    private AttributeFieldTableSectionPart jvmMemoryPart;
    private AttributeFieldTableSectionPart systemMemoryPart;

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        VerticalSectionLayout layout = new VerticalSectionLayout();
        form.getBody().setLayout((Layout)layout);
        ActionContributionItem aci = new ActionContributionItem((IAction)new ResetToDefaultsAction(){

            protected void reset() {
                MemoryTab.this.initializeDefaultAttributes();
            }
        });
        aci.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        IToolBarManager toolbarManager = form.getToolBarManager();
        if (toolbarManager instanceof ContributionManager) {
            ((ContributionManager)toolbarManager).insert(0, (IContributionItem)aci);
            toolbarManager.update(true);
        } else {
            SystemPlugin.getDefault().getLogger().severe("Eclipse implementation changed! Could not add action contribution item!");
        }
        AttributeVisualizerBuilder guiBuilder = new AttributeVisualizerBuilder(managedForm, this.getConnectionHandle());
        guiBuilder.setProperty("title", (Object)Messages.MemoryTab_SECTION_HEAP_TEXT);
        guiBuilder.setProperty("sectionIdentifier", (Object)"com.jrockit.mc.console.ui.system.help_Heap");
        guiBuilder.setProperty("dataType", (Object)ChartModel.DataType.PERCENT);
        this.memoryChartPart = guiBuilder.createChart();
        guiBuilder.clearProperties();
        guiBuilder.setProperty("title", (Object)Messages.MemoryTab_SECTION_JVM_MEMORY_STATISTICS_TEXT);
        guiBuilder.setProperty("sectionIdentifier", (Object)"com.jrockit.mc.console.ui.system.help_JvmMemoryStatistics");
        this.jvmMemoryPart = guiBuilder.createTable();
        guiBuilder.clearProperties();
        guiBuilder.setProperty("title", (Object)Messages.MemoryTab_SECTION_SYSTEM_MEMORY_STATISTICS_TEXT);
        guiBuilder.setProperty("sectionIdentifier", (Object)"com.jrockit.mc.console.ui.system.help_SystemMemoryStatistics");
        this.systemMemoryPart = guiBuilder.createTable();
        boolean initialized = this.initTabFromStore(SystemPlugin.getDefault().getPreferenceStore(), PREFERENCE_KEY_MEMORY_DATA, this);
        if (!initialized) {
            this.initializeDefaultAttributes();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        this.exportTabToStore(SystemPlugin.getDefault().getPreferenceStore(), PREFERENCE_KEY_MEMORY_DATA, this);
    }

    private void initializeDefaultAttributes() {
        this.initializeMemoryChart();
        this.initializeJvmMemoryTable();
        this.initializeSystemMemoryTable();
    }

    private void initializeJvmMemoryTable() {
        this.jvmMemoryPart.clear();
        this.jvmMemoryPart.add(new MRI(MRI.Type.ATTRIBUTE, "java.lang:type=Memory", "FreeHeapMemory"));
        this.jvmMemoryPart.add(new MRI(MRI.Type.ATTRIBUTE, "java.lang:type=Memory", "HeapMemoryUsage/used"));
        this.jvmMemoryPart.add(new MRI(MRI.Type.ATTRIBUTE, "java.lang:type=Memory", "FreeNonHeapMemory"));
        this.jvmMemoryPart.add(new MRI(MRI.Type.ATTRIBUTE, "java.lang:type=Memory", "NonHeapMemoryUsage/used"));
        this.jvmMemoryPart.markStale();
        this.jvmMemoryPart.refreshPart();
    }

    private void initializeSystemMemoryTable() {
        this.systemMemoryPart.clear();
        this.systemMemoryPart.add(new MRI(MRI.Type.ATTRIBUTE, "java.lang:type=OperatingSystem", "FreePhysicalMemorySize"));
        this.systemMemoryPart.add(new MRI(MRI.Type.ATTRIBUTE, "java.lang:type=OperatingSystem", "UsedPhysicalMemorySize"));
        this.systemMemoryPart.add(new MRI(MRI.Type.ATTRIBUTE, "java.lang:type=OperatingSystem", "FreeSwapSpaceSize"));
        this.systemMemoryPart.add(new MRI(MRI.Type.ATTRIBUTE, "java.lang:type=OperatingSystem", "UsedSwapSpaceSize"));
        this.systemMemoryPart.add(new MRI(MRI.Type.ATTRIBUTE, "java.lang:type=OperatingSystem", "CommittedVirtualMemorySize"));
        this.systemMemoryPart.markStale();
        this.systemMemoryPart.refreshPart();
    }

    private void initializeMemoryChart() {
        this.memoryChartPart.clear();
        this.memoryChartPart.add(new MRI(MRI.Type.ATTRIBUTE, "java.lang:type=Memory", "HeapMemoryUsagePercent"));
    }

    public void exportToXml(Element parentNode) {
        Element e = XmlToolkit.createElement((Element)parentNode, (String)this.getComponentTag());
        e.setAttribute("uid", this.getConnectionHandle().getServerDescriptor().getGUID());
        this.memoryChartPart.exportToXml(e);
        this.jvmMemoryPart.exportToXml(e);
        this.systemMemoryPart.exportToXml(e);
    }

    public String getComponentTag() {
        return "MemoryTab";
    }

    public void initializeFromXml(Element node) throws Exception {
        this.initializeMemoryChartFromXml(node);
        this.initializeTablesFromXml(node);
    }

    private void initializeTablesFromXml(Element node) {
        List l = XmlToolkit.getChildElementsByTag((Node)node, (String)"AttribubteTableSectionPart");
        if (l != null && l.size() == 2) {
            this.safeInitialize((XmlEnabled)this.jvmMemoryPart, (Element)l.get(0));
            this.safeInitialize((XmlEnabled)this.systemMemoryPart, (Element)l.get(1));
        } else {
            this.initializeJvmMemoryTable();
            this.initializeSystemMemoryTable();
        }
    }

    private void initializeMemoryChartFromXml(Element node) throws Exception {
        List l = XmlToolkit.getChildElementsByTag((Node)node, (String)"CombinedChartSectionPart");
        if (l != null && l.size() == 1) {
            this.safeInitialize((XmlEnabled)this.memoryChartPart, (Element)l.get(0));
        } else {
            this.initializeMemoryChart();
        }
    }
}

