/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.system;

import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.console.ui.actions.ResetToDefaultsAction;
import com.jrockit.mc.console.ui.editor.ConsoleTab;
import com.jrockit.mc.console.ui.system.Messages;
import com.jrockit.mc.console.ui.system.SystemPlugin;
import com.jrockit.mc.console.ui.system.SystemPropertiesSectionPart;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.ui.AttributeVisualizerBuilder;
import com.jrockit.mc.rjmx.ui.internal.AttributeFieldTableSectionPart;
import com.jrockit.mc.rjmx.ui.internal.ChartModel;
import com.jrockit.mc.rjmx.ui.internal.CombinedChartSectionPart;
import com.jrockit.mc.ui.misc.VerticalSectionLayout;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RuntimeTab
extends ConsoleTab
implements XmlEnabled {
    public static final String PREFERENCE_KEY_RUNTIME_DATA = "runtimeData";
    private CombinedChartSectionPart processorChartPart;
    private AttributeFieldTableSectionPart systemPart;

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        form.getBody().setLayout((Layout)new VerticalSectionLayout());
        IToolBarManager toolbarManager = form.getToolBarManager();
        if (toolbarManager instanceof ContributionManager) {
            this.addResetAction((ContributionManager)toolbarManager);
        } else {
            SystemPlugin.getDefault().getLogger().severe("Eclipse implementation changed! Could not create toolbar!");
        }
        AttributeVisualizerBuilder guiBuilder = new AttributeVisualizerBuilder(managedForm, this.getConnectionHandle());
        guiBuilder.setProperty("title", (Object)Messages.RuntimeTab_SECTION_PROCESSOR_USAGE_TEXT);
        guiBuilder.setProperty("sectionIdentifier", (Object)"com.jrockit.mc.console.ui.system.help_ProcessorUsage");
        guiBuilder.setProperty("dataType", (Object)ChartModel.DataType.PERCENT);
        this.processorChartPart = guiBuilder.createChart();
        guiBuilder.clearProperties();
        guiBuilder.setProperty("title", (Object)Messages.RuntimeTab_SECTION_SYSTEM_STATISTICS_TEXT);
        guiBuilder.setProperty("sectionIdentifier", (Object)"com.jrockit.mc.console.ui.system.help_Statistics");
        this.systemPart = guiBuilder.createTable();
        SystemPropertiesSectionPart sysProp = new SystemPropertiesSectionPart(form.getBody(), managedForm.getToolkit());
        sysProp.getSection().setText(Messages.RuntimeTab_SECTION_SYSTEM_PROPERTIES_TEXT);
        managedForm.addPart((IFormPart)sysProp);
        if (!this.initTabFromStore(SystemPlugin.getDefault().getPreferenceStore(), PREFERENCE_KEY_RUNTIME_DATA, this)) {
            this.initializeDefaultAttributes();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        this.exportTabToStore(SystemPlugin.getDefault().getPreferenceStore(), PREFERENCE_KEY_RUNTIME_DATA, this);
    }

    private void addResetAction(ContributionManager manager) {
        ActionContributionItem aci = new ActionContributionItem((IAction)new ResetToDefaultsAction(){

            protected void reset() {
                RuntimeTab.this.initializeDefaultAttributes();
            }
        });
        aci.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        manager.insert(0, (IContributionItem)aci);
        manager.update(true);
    }

    private void initializeDefaultAttributes() {
        this.initializeProcessorChartPart();
        this.initializeSystemPart();
    }

    private void initializeProcessorChartPart() {
        this.processorChartPart.clear();
        this.processorChartPart.add(new MRI(MRI.Type.ATTRIBUTE, "java.lang:type=OperatingSystem", "SystemCpuLoad"));
        this.processorChartPart.add(new MRI(MRI.Type.ATTRIBUTE, "java.lang:type=OperatingSystem", "ProcessCpuLoad"));
    }

    private void initializeSystemPart() {
        this.systemPart.clear();
        this.systemPart.add(new MRI(MRI.Type.ATTRIBUTE, "java.lang:type=Threading", "ThreadCount"));
        this.systemPart.add(new MRI(MRI.Type.ATTRIBUTE, "java.lang:type=ClassLoading", "LoadedClassCount"));
        this.systemPart.add(new MRI(MRI.Type.ATTRIBUTE, "java.lang:type=Runtime", "StartTime"));
        this.systemPart.add(new MRI(MRI.Type.ATTRIBUTE, "java.lang:type=Runtime", "Uptime"));
        this.systemPart.markStale();
        this.systemPart.refreshPart();
    }

    public String getComponentTag() {
        return "SystemTab";
    }

    public void exportToXml(Element parentNode) {
        Element e = XmlToolkit.createElement((Element)parentNode, (String)this.getComponentTag());
        e.setAttribute("uid", this.getConnectionHandle().getServerDescriptor().getGUID());
        this.processorChartPart.exportToXml(e);
        this.systemPart.exportToXml(e);
    }

    public void initializeFromXml(Element node) throws Exception {
        this.initializeProcessChartFromXml(node);
        this.initializeSystemPartFromXml(node);
    }

    private void initializeSystemPartFromXml(Element node) {
        List list = XmlToolkit.getChildElementsByTag((Node)node, (String)"AttribubteTableSectionPart");
        if (RuntimeTab.hasOneElement(list)) {
            this.safeInitialize((XmlEnabled)this.systemPart, (Element)list.get(0));
        } else {
            this.initializeSystemPart();
        }
    }

    private void initializeProcessChartFromXml(Element node) {
        List list = XmlToolkit.getChildElementsByTag((Node)node, (String)"CombinedChartSectionPart");
        if (RuntimeTab.hasOneElement(list)) {
            this.safeInitialize((XmlEnabled)this.processorChartPart, (Element)list.get(0));
        } else {
            this.initializeProcessorChartPart();
        }
    }

    private static boolean hasOneElement(List<?> list) {
        return list != null && list.size() == 1;
    }
}

