/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.alert;

import com.jrockit.mc.alert.AlertAction;
import com.jrockit.mc.alert.AlertDialog;
import com.jrockit.mc.alert.AlertObject;
import com.jrockit.mc.alert.Messages;
import com.jrockit.mc.console.ui.notification.NotificationPlugin;
import com.jrockit.mc.console.ui.notification.tab.NotificationUIToolkit;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.services.ITimingService;
import com.jrockit.mc.rjmx.triggers.TriggerEvent;
import com.jrockit.mc.rjmx.triggers.TriggerRule;
import com.jrockit.mc.ui.MCAbstractUIPlugin;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.osgi.framework.BundleContext;

public class AlertPlugin
extends MCAbstractUIPlugin {
    public static final String PLUGIN_ID = "com.jrockit.mc.alert";
    public static final String IMAGE_ALERT_BANNER = "AlertBanner";
    public static final String PREF_KEY_POPUP = "POPUP";
    private static final int MAX_ALERT_SIZE = 1000;
    private static AlertPlugin plugin;
    private AlertDialog dialog;
    private final ArrayList<AlertObject> alerts = new ArrayList();

    public AlertPlugin() {
        super(PLUGIN_ID);
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.getPreferenceStore().setDefault(PREF_KEY_POPUP, true);
        NotificationPlugin.getDefault().registerShowAlertsAction((IActionDelegate)new AlertAction());
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static AlertPlugin getDefault() {
        return plugin;
    }

    public synchronized void addNotificationEvent(TriggerEvent e) {
        this.addAlertObject(new AlertObject(e.getCreationTime(), e.getSource(), e.getRule(), NotificationUIToolkit.prettyPrint((TriggerEvent)e), null));
    }

    public synchronized void addAlertObject(AlertObject ao) {
        if (this.alerts.size() >= 1000) {
            this.alerts.remove(0);
        }
        this.alerts.add(ao);
        this.showDialog(ao.getException() != null);
        this.showTrayPopup(ao);
    }

    private void showTrayPopup(AlertObject ao) {
        if (UIPlugin.getDefault().getTrayManager() != null) {
            final String message = this.createTrayMessage(ao);
            final String title = Messages.AlertPlugin_TRIGGER_ALERT_TEXT;
            int style = 4104;
            DisplayToolkit.safeAsyncExec((Display)AlertPlugin.getDefault().getWorkbench().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    UIPlugin.getDefault().getTrayManager().showTooltip(title, message, 4104);
                }
            });
        }
    }

    public String createTrayMessage(AlertObject ae) {
        if (ae.getException() == null) {
            return this.createRuleMessage(ae);
        }
        return ae.getMessage();
    }

    private String createExceptionMessage(Date d, Throwable exception, TriggerRule rule) {
        StringBuilder builder = new StringBuilder();
        if (d != null) {
            DateFormat df1 = DateFormat.getDateInstance(3);
            DateFormat df2 = DateFormat.getTimeInstance(2);
            builder.append(MessageFormat.format(Messages.AlertPlugin_TIME_X_Y_TEXT, df1.format(d), df2.format(d)));
        }
        builder.append(String.format(Messages.AlertPlugin_MESSAGE_EXCEPTION_INVOKING_ACTION, rule.getName()));
        builder.append(String.format(Messages.AlertPlugin_MESSAGE_EXCEPTION_INVOKING_ACTION_MESSAGE_CAPTION, exception.getLocalizedMessage()));
        builder.append(Messages.AlertPlugin_MESSAGE_EXCEPTION_INVOKING_ACTION_MESSAGE_MORE_INFORMATION);
        return builder.toString();
    }

    private String createRuleMessage(AlertObject ae) {
        Date d = ae.getCreationTime();
        String message = MessageFormat.format(Messages.AlertPlugin_RULE_X_Y_TEXT, ae.getRule().getRulePath(), ae.getRule().getName());
        if (d != null) {
            DateFormat df1 = DateFormat.getDateInstance(3);
            DateFormat df2 = DateFormat.getTimeInstance(2);
            message = String.valueOf(message) + MessageFormat.format(Messages.AlertPlugin_TIME_X_Y_TEXT, df1.format(d), df2.format(d));
        }
        message = String.valueOf(message) + MessageFormat.format(Messages.AlertPlugin_SOURCE_X_TEXT, ae.getConnectionHandle().getServerDescriptor().getDisplayName());
        return message;
    }

    public void setPopup(boolean popup) {
        this.getPreferenceStore().setValue(PREF_KEY_POPUP, popup);
    }

    public boolean getPopup() {
        return this.getPreferenceStore().getBoolean(PREF_KEY_POPUP);
    }

    public void showDialog(boolean alwaysShow) {
        if (this.getPopup() || alwaysShow || this.hasDialog()) {
            DisplayToolkit.safeAsyncExec((Display)AlertPlugin.getDefault().getWorkbench().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    Display display = AlertPlugin.getDefault().getWorkbench().getDisplay();
                    Shell shell = display.getActiveShell();
                    if (shell != null && !shell.isDisposed()) {
                        if (!AlertPlugin.this.hasDialog()) {
                            AlertPlugin.this.dialog = AlertPlugin.createDialog(shell);
                        }
                        if (AlertPlugin.this.dialog != null) {
                            AlertPlugin.this.dialog.open();
                            AlertPlugin.this.dialog.refreshAlertDialog();
                        }
                    }
                }
            });
        }
    }

    public boolean hasDialog() {
        if (this.dialog == null) {
            return false;
        }
        if (this.dialog.getShell() == null) {
            return false;
        }
        return !this.dialog.getShell().isDisposed();
    }

    public static AlertDialog createDialog(Shell shell) {
        Display display = AlertPlugin.getDefault().getWorkbench().getDisplay();
        if (display != null && !display.isDisposed() && display.getActiveShell() != null && !display.getActiveShell().isDisposed()) {
            return new AlertDialog(display.getActiveShell());
        }
        return null;
    }

    public synchronized void clearNotificationEventLog() {
        this.alerts.clear();
    }

    public synchronized Object[] getAlerts() {
        return this.alerts.toArray();
    }

    public Image getImage(String image) {
        return this.getImageRegistry().get(image);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        reg.put(IMAGE_ALERT_BANNER, this.getImageDescriptor("icons/trigger-alerts-wiz.gif").createImage());
    }

    public synchronized void addException(IConnectionHandle connectionHandle, TriggerRule rule, Throwable throwable) {
        ITimingService timing = (ITimingService)connectionHandle.getServiceOrNull(ITimingService.class);
        long timestamp = 0L;
        timestamp = timing != null ? timing.getApproximateServerTime() : System.currentTimeMillis();
        Date creationDate = new Date(timestamp);
        this.addAlertObject(new AlertObject(creationDate, connectionHandle, rule, this.createExceptionMessage(creationDate, throwable, rule), throwable));
    }
}

