/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.modules.options.keymap.ActionHolder;
import org.netbeans.modules.options.keymap.KeymapViewModel;
import org.netbeans.modules.options.keymap.TableSorter;
import org.openide.util.NbBundle;

public class ShortcutPopupPanel
extends JPanel {
    private static final AbstractListModel modelWithAddAlternative = new Model(true);
    private static final AbstractListModel modelWithoutAddAltenrnative = new Model(false);
    private static AbstractListModel model = new DefaultListModel();
    private int row;
    private JTable table;
    private JPopupMenu pm;
    private boolean displayAlternative;
    private JScrollPane jScrollPane1;
    private JList list;

    ShortcutPopupPanel(JTable jTable, JPopupMenu jPopupMenu) {
        this.initComponents();
        this.table = jTable;
        this.pm = jPopupMenu;
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                ShortcutPopupPanel.this.list.requestFocus();
                ShortcutPopupPanel.this.list.setSelectedIndex(0);
            }
        });
        this.list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\u001b') {
                    ShortcutPopupPanel.this.pm.setVisible(false);
                }
            }
        });
    }

    public void setRow(int n) {
        this.row = n;
    }

    void setDisplayAddAlternative(boolean bl) {
        model = bl ? modelWithAddAlternative : modelWithoutAddAltenrnative;
        this.list.setModel(model);
        this.displayAlternative = bl;
        this.setPreferredSize(this.list.getPreferredSize());
    }

    private void addAlternative() {
        String string = (String)this.table.getValueAt(this.row, 2);
        ShortcutAction shortcutAction = ((ActionHolder)this.table.getValueAt(this.row, 0)).getAction();
        Object[] objectArray = new Object[]{new ActionHolder(shortcutAction, true), "", string, ""};
        ((DefaultTableModel)((TableSorter)this.table.getModel()).getTableModel()).insertRow(this.row + 1, objectArray);
        this.pm.setVisible(false);
        this.table.editCellAt(this.row + 1, 1);
    }

    private void clear() {
        this.pm.setVisible(false);
        String string = (String)this.table.getValueAt(this.row, 1);
        ShortcutAction shortcutAction = ((ActionHolder)this.table.getValueAt(this.row, 0)).getAction();
        KeymapViewModel keymapViewModel = (KeymapViewModel)((TableSorter)this.table.getModel()).getTableModel();
        if (string.length() != 0) {
            keymapViewModel.removeShortcut(shortcutAction, string);
        }
        if (((ActionHolder)this.table.getValueAt(this.row, 0)).isAlternative()) {
            keymapViewModel.removeRow(this.row);
        } else {
            this.table.setValueAt("", this.row, 1);
            keymapViewModel.update();
        }
    }

    private void resetToDefault() {
        this.pm.setVisible(false);
        ShortcutAction shortcutAction = ((ActionHolder)this.table.getValueAt(this.row, 0)).getAction();
        KeymapViewModel keymapViewModel = (KeymapViewModel)((TableSorter)this.table.getModel()).getTableModel();
        keymapViewModel.revertShortcutsToDefault(shortcutAction);
        keymapViewModel.fireTableDataChanged();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.list = new JList();
        this.jScrollPane1.setBorder(null);
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setVerticalScrollBarPolicy(21);
        this.list.setModel(model);
        this.list.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                ShortcutPopupPanel.this.listMouseMoved(mouseEvent);
            }
        });
        this.list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                ShortcutPopupPanel.this.listKeyPressed(keyEvent);
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ShortcutPopupPanel.this.listMouseClicked(mouseEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.list);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 112, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 70, Short.MAX_VALUE));
    }

    private void listMouseMoved(MouseEvent mouseEvent) {
        this.list.setSelectedIndex(this.list.locationToIndex(new Point(mouseEvent.getX(), mouseEvent.getY())));
    }

    private void listMouseClicked(MouseEvent mouseEvent) {
        int n = this.list.locationToIndex(new Point(mouseEvent.getX(), mouseEvent.getY()));
        this.itemSelected(n);
    }

    private void itemSelected(int n) {
        block12: {
            block11: {
                if (!this.displayAlternative) break block11;
                switch (n) {
                    case 0: {
                        this.pm.setVisible(false);
                        this.table.editCellAt(this.row, 1);
                        break block12;
                    }
                    case 1: {
                        this.addAlternative();
                        break block12;
                    }
                    case 2: {
                        this.resetToDefault();
                        break block12;
                    }
                    case 3: {
                        this.clear();
                        break block12;
                    }
                    default: {
                        throw new UnsupportedOperationException("Invalid popup selection item");
                    }
                }
            }
            switch (n) {
                case 0: {
                    this.pm.setVisible(false);
                    this.table.editCellAt(this.row, 1);
                    break;
                }
                case 1: {
                    this.resetToDefault();
                    break;
                }
                case 2: {
                    this.clear();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Invalid popup selection item");
                }
            }
        }
    }

    private void listKeyPressed(KeyEvent keyEvent) {
        int n = this.list.getSelectedIndex();
        if (keyEvent.getKeyCode() == 38) {
            this.list.setSelectedIndex(n == 0 ? model.getSize() - 1 : n - 1);
        }
        if (keyEvent.getKeyCode() == 40) {
            this.list.setSelectedIndex(n == model.getSize() - 1 ? 0 : n + 1);
        }
        if (keyEvent.getKeyCode() == 10 && !this.list.isSelectionEmpty()) {
            this.itemSelected(this.list.getSelectedIndex());
        }
        keyEvent.consume();
    }

    private static class Model
    extends AbstractListModel {
        private boolean displayAlternative;
        String[] elms = new String[]{NbBundle.getMessage(ShortcutPopupPanel.class, (String)"Edit"), NbBundle.getMessage(ShortcutPopupPanel.class, (String)"Add_Alternative"), NbBundle.getMessage(ShortcutPopupPanel.class, (String)"Reset_to_Default"), NbBundle.getMessage(ShortcutPopupPanel.class, (String)"Clear")};
        String[] elms0 = new String[]{this.elms[0], this.elms[2], this.elms[3]};

        public Model(boolean bl) {
            this.displayAlternative = bl;
        }

        @Override
        public int getSize() {
            return this.displayAlternative ? this.elms.length : this.elms0.length;
        }

        @Override
        public Object getElementAt(int n) {
            return this.displayAlternative ? this.elms[n] : this.elms0[n];
        }
    }
}

