/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import org.netbeans.modules.options.keymap.KeymapPanel;
import org.netbeans.modules.options.keymap.KeymapViewModel;
import org.netbeans.modules.options.keymap.ShortcutListener;
import org.netbeans.modules.options.keymap.ShortcutProvider;
import org.openide.util.NbBundle;

public class ShortcutTextField
extends JTextField {
    private Popup popup;
    JList list = new JList();
    JScrollPane pane = new JScrollPane();

    public ShortcutTextField(String string) {
        super(string);
        this.pane.setViewportView(this.list);
        this.pane.setMaximumSize(new Dimension(350, 350));
        this.pane.setHorizontalScrollBarPolicy(31);
        this.addKeyListener(new ShortcutListener(true));
        this.addKeyListener(new ShortcutCompletionListener());
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ShortcutTextField.this.popup != null) {
                    ShortcutTextField.this.popup.hide();
                    ShortcutTextField.this.popup = null;
                }
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                JTextField jTextField = (JTextField)focusEvent.getComponent();
                ((ShortcutListener)jTextField.getKeyListeners()[0]).clear();
                jTextField.selectAll();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (ShortcutTextField.this.popup != null) {
                    ShortcutTextField.this.popup.hide();
                    ShortcutTextField.this.popup = null;
                }
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = ((JList)mouseEvent.getSource()).getSelectedIndex();
                ShortcutTextField.this.confirm(n);
            }
        });
    }

    public ShortcutTextField() {
        this("");
    }

    private void confirm(int n) {
        if (n != -1) {
            Object e = this.list.getModel().getElementAt(n);
            this.setText(e.toString());
        }
        this.popup.hide();
        this.popup = null;
    }

    private void ensureSelectionVisible(int n) {
        Rectangle rectangle = this.list.getCellBounds(n, n);
        if (rectangle != null) {
            this.list.scrollRectToVisible(rectangle);
        }
    }

    private Vector<String> getFreeShortcuts(String string) {
        Vector<String> vector = new Vector<String>();
        for (String string2 : this.getAllFreeShortcuts()) {
            if (!string2.startsWith(string)) continue;
            vector.add(string2);
        }
        if (vector.size() == 0) {
            vector.add(NbBundle.getMessage(ShortcutTextField.class, (String)"No_Free_Shortcut", (Object)string));
        }
        return vector;
    }

    private Set<String> getAllFreeShortcuts() {
        KeymapViewModel keymapViewModel = ((KeymapPanel)this.getParent().getParent().getParent().getParent().getParent()).getModel();
        Set<String> set = keymapViewModel.getAllCurrentlyUsedShortcuts();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.addAll(ShortcutProvider.getSet());
        linkedHashSet.removeAll(set);
        return linkedHashSet;
    }

    private class ShortcutCompletionListener
    extends KeyAdapter {
        private ShortcutCompletionListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            JTextField jTextField = (JTextField)keyEvent.getSource();
            int n = ShortcutTextField.this.list.getSelectedIndex();
            ShortcutTextField.this.list.setListData(ShortcutTextField.this.getFreeShortcuts(jTextField.getText()));
            int n2 = keyEvent.getKeyCode();
            if (ShortcutTextField.this.popup == null) {
                if (n2 == 10 || n2 == 27) {
                    return;
                }
                Point point = new Point(jTextField.getX(), jTextField.getY());
                SwingUtilities.convertPointToScreen(point, jTextField.getParent());
                ShortcutTextField.this.popup = PopupFactory.getSharedInstance().getPopup(jTextField, ShortcutTextField.this.pane, point.x, point.y + jTextField.getHeight() + 1);
            }
            ShortcutTextField.this.pane.setPreferredSize(new Dimension(ShortcutTextField.this.list.getPreferredSize().width + ShortcutTextField.this.pane.getVerticalScrollBar().getPreferredSize().width + 2, Math.min(350, ShortcutTextField.this.list.getPreferredSize().height) + 5));
            ShortcutTextField.this.popup.show();
            switch (n2) {
                case 40: {
                    int n3 = n == -1 || n == ShortcutTextField.this.list.getModel().getSize() - 1 ? 0 : n + 1;
                    ShortcutTextField.this.list.setSelectedIndex(n3);
                    ShortcutTextField.this.ensureSelectionVisible(n3);
                    keyEvent.consume();
                    break;
                }
                case 38: {
                    int n4;
                    int n5 = n4 = n == -1 ? 0 : n - 1;
                    if (n == 0) {
                        n4 = ShortcutTextField.this.list.getModel().getSize() - 1;
                    }
                    ShortcutTextField.this.list.setSelectedIndex(n4);
                    ShortcutTextField.this.ensureSelectionVisible(n4);
                    keyEvent.consume();
                    break;
                }
                case 27: {
                    ShortcutTextField.this.popup.hide();
                    ShortcutTextField.this.popup = null;
                    keyEvent.consume();
                    break;
                }
                case 10: {
                    ShortcutTextField.this.confirm(n);
                }
            }
        }
    }
}

