/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;
import org.openide.util.Utilities;

class Utils {
    private static final String EMACS_CTRL = "Ctrl+";
    private static final String EMACS_ALT = "Alt+";
    private static final String EMACS_SHIFT = "Shift+";
    private static final String EMACS_META = "Meta+";
    private static final String STRING_META;
    private static final String STRING_ALT;

    Utils() {
    }

    static String getKeyStrokesAsText(KeyStroke[] keyStrokeArray, String string) {
        if (keyStrokeArray == null) {
            return "";
        }
        if (keyStrokeArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(Utils.getKeyStrokeAsText(keyStrokeArray[0]));
        int n = keyStrokeArray.length;
        for (int i = 1; i < n; ++i) {
            stringBuffer.append(string).append(Utils.getKeyStrokeAsText(keyStrokeArray[i]));
        }
        return new String(stringBuffer);
    }

    static KeyStroke getKeyStroke(String string) {
        int n = 0;
        while (true) {
            if (string.startsWith(EMACS_CTRL)) {
                n |= 0x80;
                string = string.substring(EMACS_CTRL.length());
                continue;
            }
            if (string.startsWith(EMACS_ALT)) {
                n |= 0x200;
                string = string.substring(EMACS_ALT.length());
                continue;
            }
            if (string.startsWith(EMACS_SHIFT)) {
                n |= 0x40;
                string = string.substring(EMACS_SHIFT.length());
                continue;
            }
            if (string.startsWith(EMACS_META)) {
                n |= 0x100;
                string = string.substring(EMACS_META.length());
                continue;
            }
            if (string.startsWith(STRING_ALT)) {
                n |= 0x200;
                string = string.substring(STRING_ALT.length());
                continue;
            }
            if (!string.startsWith(STRING_META)) break;
            n |= 0x100;
            string = string.substring(STRING_META.length());
        }
        KeyStroke keyStroke = Utilities.stringToKey((String)string);
        if (keyStroke == null) {
            return null;
        }
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(keyStroke.getKeyCode(), n);
        return keyStroke2;
    }

    static String getKeyStrokeAsText(KeyStroke keyStroke) {
        int n = keyStroke.getModifiers();
        StringBuilder stringBuilder = new StringBuilder();
        if ((n & 0x80) > 0) {
            stringBuilder.append(EMACS_CTRL);
        }
        if ((n & 0x200) > 0) {
            stringBuilder.append(STRING_ALT);
        }
        if ((n & 0x40) > 0) {
            stringBuilder.append(EMACS_SHIFT);
        }
        if ((n & 0x100) > 0) {
            stringBuilder.append(STRING_META);
        }
        if (keyStroke.getKeyCode() != 16 && keyStroke.getKeyCode() != 17 && keyStroke.getKeyCode() != 157 && keyStroke.getKeyCode() != 18 && keyStroke.getKeyCode() != 65406) {
            stringBuilder.append(Utilities.keyToString((KeyStroke)KeyStroke.getKeyStroke(keyStroke.getKeyCode(), 0)));
        }
        return stringBuilder.toString();
    }

    static {
        if (Utilities.isMac()) {
            STRING_META = KeyEvent.getKeyText(157).concat("+");
            STRING_ALT = KeyEvent.getKeyText(18).concat("+");
        } else {
            STRING_META = EMACS_META;
            STRING_ALT = EMACS_ALT;
        }
    }
}

