/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.browser.attach;

import com.jrockit.mc.browser.attach.AttachPlugin;
import com.jrockit.mc.browser.attach.LocalConnectionDescriptor;
import com.jrockit.mc.browser.attach.internal.ExecuteTunnler;
import com.jrockit.mc.common.jvm.Attachable;
import com.jrockit.mc.common.jvm.JVMDescriptor;
import com.jrockit.mc.common.jvm.JVMType;
import com.jrockit.mc.rjmx.ConnectionToolkit;
import com.jrockit.mc.rjmx.IConnectionDescriptor;
import com.jrockit.mc.rjmx.IServerDescriptor;
import com.jrockit.mc.rjmx.ServerDescriptor;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import javax.management.remote.JMXServiceURL;
import sun.jvmstat.monitor.HostIdentifier;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.MonitoredVmUtil;
import sun.jvmstat.monitor.StringMonitor;
import sun.jvmstat.monitor.VmIdentifier;
import sun.management.ConnectorAddressLink;
import sun.management.counter.perf.InstrumentationException;
import sun.tools.attach.HotSpotVirtualMachine;

public class LocalJVMToolkit {
    private static long SEQ_NUMBER = 0L;
    private static boolean isErrorMessageSent = false;
    private static Map<Object, DiscoveryEntry> last = new WeakHashMap<Object, DiscoveryEntry>();
    static final String LOCAL_CONNECTOR_ADDRESS_PROP = "com.sun.management.jmxremote.localConnectorAddress";

    private LocalJVMToolkit() {
    }

    public static DiscoveryEntry[] getLocalConnections() {
        HashMap<Object, DiscoveryEntry> map = new HashMap<Object, DiscoveryEntry>();
        LocalJVMToolkit.populateAttachableVMs(map);
        LocalJVMToolkit.populateMonitoredVMs(map);
        last = map;
        ArrayList<DiscoveryEntry> list = new ArrayList<DiscoveryEntry>(map.values());
        return list.toArray(new DiscoveryEntry[list.size()]);
    }

    private static void populateMonitoredVMs(HashMap<Object, DiscoveryEntry> map) {
        Set<Integer> vms;
        MonitoredHost host;
        try {
            host = MonitoredHost.getMonitoredHost(new HostIdentifier(null));
            vms = host.activeVms();
        }
        catch (URISyntaxException sx) {
            throw new InternalError(sx.getMessage());
        }
        catch (MonitorException mx) {
            throw new InternalError(mx.getMessage());
        }
        for (Integer vmid : vms) {
            if (!(vmid instanceof Integer) || map.containsKey(vmid)) continue;
            DiscoveryEntry connDesc = last.get(vmid);
            if (connDesc == null) {
                int pid = vmid;
                String name = ((Object)vmid).toString();
                boolean attachable = false;
                JVMType type = JVMType.JROCKIT;
                boolean isDebug = false;
                String address = null;
                String version = null;
                String vmVersion = null;
                try {
                    MonitoredVm mvm = host.getMonitoredVm(new VmIdentifier(name));
                    try {
                        name = MonitoredVmUtil.commandLine(mvm);
                        StringMonitor sm = (StringMonitor)mvm.findByName("java.property.java.vm.name");
                        if (sm != null) {
                            type = LocalJVMToolkit.getJVMType(sm.stringValue());
                        }
                        if ((sm = (StringMonitor)mvm.findByName("java.property.java.version")) != null) {
                            version = sm.stringValue();
                        }
                        if ((sm = (StringMonitor)mvm.findByName("java.property.java.vm.version")) != null) {
                            vmVersion = sm.stringValue();
                            if (version == null) {
                                version = type == JVMType.JROCKIT ? LocalJVMToolkit.decodeJavaVersion(vmVersion) : LocalJVMToolkit.parseJavaVersion(vmVersion);
                            }
                        }
                        if (version == null) {
                            version = "0";
                        }
                        if (sm != null && type == JVMType.JROCKIT) {
                            isDebug = LocalJVMToolkit.isDebug(sm.stringValue());
                        }
                        attachable = MonitoredVmUtil.isAttachable(mvm);
                        address = ConnectorAddressLink.importFrom((int)pid);
                    }
                    finally {
                        mvm.detach();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                connDesc = LocalJVMToolkit.createDescriptor(name, vmid, attachable, type, address, version, isDebug, vmVersion);
            }
            map.put(vmid, connDesc);
        }
    }

    private static JVMType getJVMType(String jvmName) {
        if (ConnectionToolkit.isJRockitJVMName((String)jvmName)) {
            return JVMType.JROCKIT;
        }
        if (ConnectionToolkit.isHotspotJVMName((String)jvmName)) {
            return JVMType.HOTSPOT;
        }
        return JVMType.UNKNOWN;
    }

    private static boolean isDebug(String stringValue) {
        return stringValue.startsWith("DEBUG");
    }

    private static void populateAttachableVMs(Map<Object, DiscoveryEntry> map) {
        List<VirtualMachineDescriptor> vms = VirtualMachine.list();
        if (vms == null) {
            return;
        }
        for (VirtualMachineDescriptor vmd : vms) {
            try {
                Integer vmid = Integer.valueOf(vmd.id());
                if (map.containsKey(vmid)) continue;
                AttachPlugin.getPluginLogger().finest("Local attach resolving PID " + vmid);
                DiscoveryEntry connDesc = last.get(vmid);
                boolean attachable = false;
                if (connDesc == null) {
                    boolean isDebug = false;
                    JVMType jvmType = JVMType.JROCKIT;
                    String address = null;
                    String version = null;
                    String commandLine = null;
                    String jvmVersion = null;
                    try {
                        VirtualMachine vm = VirtualMachine.attach(vmd);
                        try {
                            attachable = true;
                            Properties props = vm.getSystemProperties();
                            if (props != null) {
                                String vmName = props.getProperty("java.vm.name");
                                jvmType = LocalJVMToolkit.getJVMType(vmName);
                                isDebug = LocalJVMToolkit.isDebug(vmName);
                                version = props.getProperty("java.version");
                                jvmVersion = props.getProperty("java.vm.version");
                            }
                            Properties agentProps = vm.getAgentProperties();
                            address = (String)agentProps.get(LOCAL_CONNECTOR_ADDRESS_PROP);
                            commandLine = LocalJVMToolkit.resolveCommandLine(vm, vmd.displayName());
                        }
                        finally {
                            vm.detach();
                        }
                    }
                    catch (AttachNotSupportedException x) {
                        attachable = false;
                    }
                    catch (Throwable t) {
                        if (isErrorMessageSent) continue;
                        AttachPlugin.getPluginLogger().log(Level.FINER, "Scanning using attach/getAgentProperties failed on " + vmid + ". Not implemented in JRockit R27.1 so not that strange. This message will only be printed once, so errors for subsequent PIDs will not be logged...", t);
                        isErrorMessageSent = true;
                        continue;
                    }
                    connDesc = LocalJVMToolkit.createDescriptor(commandLine, vmid, attachable, jvmType, address, version, isDebug, jvmVersion);
                    AttachPlugin.getPluginLogger().info("Done resolving PID " + vmid);
                }
                if (!attachable) continue;
                map.put(vmid, connDesc);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private static String resolveCommandLine(VirtualMachine vm, String displayName) {
        Properties props;
        if (LocalJVMToolkit.isValidDisplayName(displayName)) {
            return displayName;
        }
        try {
            props = vm.getSystemProperties();
        }
        catch (IOException e) {
            return displayName;
        }
        if (!props.containsKey("eclipse.vmargs")) {
            return displayName;
        }
        return LocalJVMToolkit.getJar(props.getProperty("eclipse.vmargs"));
    }

    private static String getJar(String property) {
        return property.substring(property.indexOf("org.eclipse"));
    }

    private static boolean isValidDisplayName(String displayName) {
        return displayName != null && !displayName.equals("") && !displayName.equals("Unknown");
    }

    private static DiscoveryEntry createDescriptor(String commandLine, int pid, boolean attachable, JVMType type, String address, String version, boolean isDebug, String vmVersion) {
        JVMDescriptor jvmInfo = new JVMDescriptor(version, type, commandLine, Integer.valueOf(pid), isDebug, Attachable.valueOf((boolean)attachable));
        LocalConnectionDescriptor lcd = new LocalConnectionDescriptor(pid, address, attachable);
        String guid = "Local-[PID:" + pid + ", seq:" + SEQ_NUMBER++ + "]";
        ServerDescriptor sd = new ServerDescriptor(guid, null, jvmInfo);
        return new DiscoveryEntry((IServerDescriptor)sd, lcd);
    }

    static String decodeJavaVersion(String version) {
        String specVersion = version;
        if (version.startsWith("R") || version.startsWith("P") || version.startsWith("DEBUG-")) {
            specVersion = version.startsWith("DEBUG-") ? version.split("-")[4] : version.split("-")[3];
        }
        return LocalJVMToolkit.parseJavaVersion(specVersion);
    }

    static String parseJavaVersion(String version) {
        int onePointIndex = version.indexOf("1.");
        if (onePointIndex >= 0) {
            int nextPointIndex = version.indexOf(46, onePointIndex + 2);
            if (nextPointIndex >= 0 && LocalJVMToolkit.isNumber(version.substring(onePointIndex + 2, nextPointIndex))) {
                return version.substring(onePointIndex, nextPointIndex);
            }
            return version.substring(onePointIndex);
        }
        return null;
    }

    private static boolean isNumber(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static synchronized DiscoveryEntry[] getAttachableJVMs() {
        return LocalJVMToolkit.getLocalConnections();
    }

    public static String executeCommandForPid(String pid, String command) throws AttachNotSupportedException, IOException, AgentLoadException {
        VirtualMachine vm = VirtualMachine.attach(pid);
        String result = LocalJVMToolkit.executeCommandForPid(vm, pid, command);
        vm.detach();
        return result;
    }

    public static String executeCommandForPid(VirtualMachine vm, String pid, String command) throws AttachNotSupportedException, IOException, AgentLoadException {
        int n;
        HotSpotVirtualMachine hvm = (HotSpotVirtualMachine)vm;
        InputStream in = ExecuteTunnler.execute(hvm, "jcmd", new Object[]{command});
        byte[] b = new byte[256];
        StringBuffer buf = new StringBuffer();
        do {
            if ((n = in.read(b)) <= 0) continue;
            String s = new String(b, 0, n, "UTF-8");
            buf.append(s);
        } while (n > 0);
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buf.toString();
    }

    public static JMXServiceURL getInMemoryURLFromPID(int pid) throws IOException {
        JMXServiceURL inMemURL = null;
        String address = null;
        try {
            address = ConnectorAddressLink.importFrom((int)pid);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (InstrumentationException instrumentationException) {
            // empty catch block
        }
        if (address != null) {
            inMemURL = new JMXServiceURL(address);
        }
        return inMemURL;
    }

    public static class DiscoveryEntry {
        IServerDescriptor serverDescriptor;
        IConnectionDescriptor connectionDescriptor;

        public DiscoveryEntry(IServerDescriptor serverDescriptor, IConnectionDescriptor descriptor) {
            this.serverDescriptor = serverDescriptor;
            this.connectionDescriptor = descriptor;
        }
    }
}

