/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.browser.attach;

import com.jrockit.mc.browser.attach.Messages;
import com.jrockit.mc.common.persistence.ISettingFetcher;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.common.unit.ContentType;
import com.jrockit.mc.common.unit.UnitDescriptor;
import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.components.ui.behaviors.IStatusListener;
import com.jrockit.mc.components.ui.behaviors.IStatusProvider;
import com.jrockit.mc.components.ui.settings.BooleanInput;
import com.jrockit.mc.components.ui.settings.FieldInput;
import com.jrockit.mc.components.ui.settings.IInput;
import com.jrockit.mc.components.ui.settings.InputPanel;
import com.jrockit.mc.components.ui.settings.StatusWizardPage;
import com.jrockit.mc.rjmx.IServerHandle;
import com.jrockit.mc.ui.misc.HelpSupport;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.model.fields.FieldFactory;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;

public class RemoteJMXAgentWizardPage
extends StatusWizardPage {
    private static final String MANAGEMENT_AGENT_START = "ManagementAgent.start";
    private static final String MANAGEMENT_AGENT_STOP = "ManagementAgent.stop";
    private static final String JDP_PAUSE = "jdp.pause";
    private static final String JDP_TTL = "jdp.ttl";
    private static final String JDP_PORT = "jdp.port";
    private static final String JDP_ADDRESS = "jdp.address";
    private static final String JMXREMOTE_AUTODISCOVERY = "jmxremote.autodiscovery";
    private static final String JMXREMOTE_REGISTRY_SSL = "jmxremote.registry.ssl";
    private static final String JMXREMOTE_RMI_PORT = "jmxremote.rmi.port";
    private static final String JMXREMOTE_AUTHENTICATE = "jmxremote.authenticate";
    private static final String JMXREMOTE_SSL = "jmxremote.ssl";
    private static final String JMXREMOTE_PORT = "jmxremote.port";
    static final String PAGE_NAME = "browser.attach.management.agent.settings.wizard.page";
    private static final int DEFAULT_PORT = 7091;
    private static final int MIN_PORT = 0;
    private static final int MAX_PORT = 65535;
    private static final int DEFAULT_JDP_TTL = 1;
    private static final int DEFAULT_JDP_INTERVAL = 5000;
    private static final Boolean DEFAULT_SSL = Boolean.TRUE;
    private static final Boolean DEFAULT_AUTHENTICATE = Boolean.TRUE;
    private static final Boolean DEFAULT_REGISTRY_SSL = Boolean.FALSE;
    private static final Boolean DEFAULT_AUTODISCOVERY = Boolean.FALSE;
    private InputPanel inputPanel;
    private ArrayList<SettingControl> settingsControls;
    private Text commandText;
    private IServerHandle serverHandle;
    private Button stopAgentButton;
    private Button startAgentButton;

    static {
        PersistenceToolkit.registerFetcher(Setting.class, (ISettingFetcher)new ISettingFetcher<Setting>(){

            public Setting getSetting(Setting sl) {
                return sl;
            }
        });
    }

    protected RemoteJMXAgentWizardPage(IServerHandle serverHandle) {
        super(PAGE_NAME, (Object)new Setting("remotejmxagent.settings"));
        this.serverHandle = serverHandle;
        this.initSettings();
        this.setDefaultMessage();
    }

    protected String createTitle() {
        return NLS.bind((String)Messages.RemoteJMXStarterAction_START_REMOTE_JMX_AGENT_TITLE, (Object)this.serverHandle.getServerDescriptor().getDisplayName());
    }

    protected void setDefaultMessage() {
        super.setDefaultMessage();
        this.setMessage(Messages.RemoteJMXStarterAction_START_REMOTE_JMX_AGENT_LONG_MESSAGE);
    }

    private void initSettings() {
        this.settingsControls = new ArrayList();
        this.settingsControls.add(new SettingControl(JMXREMOTE_PORT, Messages.RemoteJMXStarterWizardPage_PORT_LABEL, Messages.RemoteJMXStarterWizardPage_PORT_DESCRIPTION, UnitLookup.PORT, 7091, 0, 65535));
        this.settingsControls.add(new SettingControl(JMXREMOTE_SSL, Messages.RemoteJMXStarterWizardPage_SSL_LABEL, Messages.RemoteJMXStarterWizardPage_SSL_DESCRIPTION, UnitLookup.FLAG, DEFAULT_SSL));
        this.settingsControls.add(new SettingControl(JMXREMOTE_AUTHENTICATE, Messages.RemoteJMXStarterWizardPage_AUTHENTICATE_LABEL, Messages.RemoteJMXStarterWizardPage_AUTHENTICATE_DESCRIPTION, UnitLookup.FLAG, DEFAULT_AUTHENTICATE));
        this.settingsControls.add(new SettingControl(JMXREMOTE_RMI_PORT, Messages.RemoteJMXStarterWizardPage_RMI_PORT_LABEL, Messages.RemoteJMXStarterWizardPage_RMI_PORT_DESCRIPTION, UnitLookup.PORT, 7091, 0, 65535));
        this.settingsControls.add(new SettingControl(JMXREMOTE_REGISTRY_SSL, Messages.RemoteJMXStarterWizardPage_REGISTRY_SSL_LABEL, Messages.RemoteJMXStarterWizardPage_REGISTRY_SSL_DESCRIPTION, UnitLookup.FLAG, DEFAULT_REGISTRY_SSL));
        this.settingsControls.add(new SettingControl(JMXREMOTE_AUTODISCOVERY, Messages.RemoteJMXStarterWizardPage_AUTODISCOVERY_LABEL, Messages.RemoteJMXStarterWizardPage_AUTODISCOVERY_DESCRIPTION, UnitLookup.FLAG, DEFAULT_AUTODISCOVERY));
        this.settingsControls.add(new SettingControl(JDP_TTL, Messages.RemoteJMXStarterWizardPage_JDP_TTL_LABEL, Messages.RemoteJMXStarterWizardPage_JDP_TTL_DESCRIPTION, UnitLookup.COUNT, 1));
        this.settingsControls.add(new SettingControl(JDP_PAUSE, Messages.RemoteJMXStarterWizardPage_JDP_PAUSE_LABEL, Messages.RemoteJMXStarterWizardPage_JDP_PAUSE_DESCRIPTION, UnitLookup.COUNT, 5000));
    }

    public Composite createControlArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.createStopAgentButton(composite);
        this.createStartAgentButton(composite);
        this.createInputPanel(composite);
        this.createCommandText(composite);
        RemoteJMXAgentWizardPage.addHelpButton(composite);
        this.setStartAgentControlsEnabled(true);
        return composite;
    }

    private void createStopAgentButton(Composite parent) {
        this.stopAgentButton = new Button(parent, 16);
        this.stopAgentButton.setText(Messages.STOP_REMOTE_JMX_AGENT);
        this.stopAgentButton.setToolTipText(Messages.STOP_REMOTE_JMX_AGENT_DESCRIPTION);
        this.stopAgentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteJMXAgentWizardPage.this.setStartAgentControlsEnabled(false);
                RemoteJMXAgentWizardPage.this.refreshCommand();
            }
        });
        GridData gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalSpan = 1;
        this.stopAgentButton.setLayoutData((Object)gridData);
        this.stopAgentButton.setSelection(false);
    }

    private void createStartAgentButton(Composite parent) {
        this.startAgentButton = new Button(parent, 16);
        this.startAgentButton.setText(Messages.START_REMOTE_JMX_AGENT);
        this.startAgentButton.setToolTipText(Messages.START_REMOTE_JMX_AGENT_DESCRIPTION);
        this.startAgentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteJMXAgentWizardPage.this.setStartAgentControlsEnabled(true);
                RemoteJMXAgentWizardPage.this.refreshCommand();
            }
        });
        GridData gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalSpan = 1;
        this.startAgentButton.setLayoutData((Object)gridData);
        this.startAgentButton.setSelection(true);
    }

    protected void setStartAgentControlsEnabled(boolean enabled) {
        this.inputPanel.setEnabled(enabled);
    }

    private void createInputPanel(Composite composite) {
        ArrayList<IInput> inputs = new ArrayList<IInput>();
        for (SettingControl settingControl : this.settingsControls) {
            IInput input = settingControl.createInput(this.getSetting());
            inputs.add(input);
        }
        this.inputPanel = new InputPanel(composite, (Object)this.getSetting(), inputs);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        this.inputPanel.getControl().setLayoutData((Object)gd);
        this.getStatusProvider().addStatusProvider((IStatusProvider)this.inputPanel);
        this.inputPanel.addStatusListener(new IStatusListener(){

            public void onChange(IStatus status) {
                RemoteJMXAgentWizardPage.this.refreshCommand();
            }
        });
    }

    protected void refreshCommand() {
        this.setCommand("Command: " + this.getCommand());
    }

    private Setting getSetting() {
        return (Setting)this.getConfigurationObject();
    }

    public static void addHelpButton(Composite parent) {
        Action helpAction = HelpSupport.getHelpAction((String)"com.jrockit.mc.docs.Communication");
        if (helpAction != null) {
            FormText fText = new FormText(parent, 0);
            fText.setText(Messages.RemoteJMXStarterWizardPage_HELP_TIP_TEXT, true, true);
            GridData gridDataFAQ = new GridData(768);
            gridDataFAQ.horizontalSpan = 2;
            fText.setLayoutData((Object)gridDataFAQ);
            fText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter((IAction)helpAction){
                private final /* synthetic */ IAction val$helpAction;
                {
                    this.val$helpAction = iAction;
                }

                public void linkActivated(HyperlinkEvent e) {
                    this.val$helpAction.run();
                }
            });
        }
    }

    private void createCommandText(Composite composite) {
        if (this.isDebug()) {
            this.commandText = new Text(composite, 2634);
            this.commandText.setEditable(false);
            GridData gd = new GridData(16384, 4, false, true);
            gd.widthHint = 400;
            this.commandText.setLayoutData((Object)gd);
            this.commandText.setText(this.getCommand());
        }
    }

    private void setCommand(String command) {
        if (this.isDebug()) {
            this.commandText.setText(command);
        }
    }

    private boolean isDebug() {
        return Boolean.getBoolean("com.jrockit.mc.debug");
    }

    String getCommand() {
        return this.stopAgentButton.getSelection() ? this.getStopCommand() : this.getStartCommand();
    }

    private String getStartCommand() {
        StringBuilder commandBuilder = new StringBuilder(MANAGEMENT_AGENT_START).append(" ");
        for (SettingControl settingControl : this.settingsControls) {
            String id = settingControl.id;
            if (this.isJdpSetting(id) && !this.jdpEnabled()) continue;
            commandBuilder.append(id).append("=").append((String)this.getSetting().getChildObject(id, String.class)).append(" ");
        }
        return commandBuilder.toString();
    }

    private String getStopCommand() {
        return MANAGEMENT_AGENT_STOP;
    }

    private boolean isJdpSetting(String id) {
        return JDP_PAUSE.equals(id) || JDP_TTL.equals(id) || JDP_PORT.equals(id) || JDP_ADDRESS.equals(id);
    }

    private boolean jdpEnabled() {
        return (Boolean)this.getSetting().getChildObject(JMXREMOTE_AUTODISCOVERY, Boolean.class);
    }

    private static class SettingControl {
        private String id;
        String name;
        String tooltip;
        ContentType contentType;
        Object defaultValue;
        Object minValue;
        Object maxValue;

        public SettingControl(String id, String label, String tooltip, ContentType contentType, Object defaultValue, Object minValue, Object maxValue) {
            this.id = id;
            this.name = label;
            this.tooltip = tooltip;
            this.contentType = contentType;
            this.defaultValue = defaultValue;
            this.minValue = minValue;
            this.maxValue = maxValue;
        }

        public SettingControl(String id, String label, String tooltip, ContentType contentType, Object defaultValue) {
            this(id, label, tooltip, contentType, defaultValue, null, null);
        }

        public IInput createInput(Setting parentSetting) {
            BooleanInput input;
            parentSetting.setChildObject(this.id, this.defaultValue);
            if (this.contentType == UnitLookup.FLAG) {
                input = new BooleanInput(this.id, this.name, this.tooltip);
            } else {
                Field newField = FieldFactory.createFromDisplayUnit((UnitDescriptor)UnitLookup.getUnitDescriptor((String)this.contentType.getIdentifier()), (String)this.name, (int)0);
                input = new FieldInput(this.id, this.name, this.tooltip, newField, this.defaultValue, this.minValue, this.maxValue);
            }
            return input;
        }
    }
}

