/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.attach.panels;

import javax.swing.JPanel;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.modules.profiler.attach.panels.AttachWizardPanel;
import org.netbeans.modules.profiler.attach.panels.Bundle;
import org.netbeans.modules.profiler.attach.panels.ReviewSettingsPanelUI;
import org.netbeans.modules.profiler.attach.wizard.AttachWizardContext;
import org.openide.util.HelpCtx;

public class ReviewSettingsPanel
extends AttachWizardPanel {
    private static final String HELP_CTX_KEY = "ReviewSettingsPanel.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("ReviewSettingsPanel.HelpCtx");
    private Model model = new Model();
    private ReviewSettingsPanelUI panel;

    public HelpCtx getHelp() {
        return HELP_CTX;
    }

    public boolean isValid() {
        return true;
    }

    @Override
    public boolean canBack(AttachWizardContext attachWizardContext) {
        return true;
    }

    @Override
    public boolean canFinish(AttachWizardContext attachWizardContext) {
        return true;
    }

    @Override
    public boolean canNext(AttachWizardContext attachWizardContext) {
        return true;
    }

    @Override
    public boolean onCancel(AttachWizardContext attachWizardContext) {
        return true;
    }

    @Override
    public void onEnter(AttachWizardContext attachWizardContext) {
        if (this.getContext().getAttachSettings().isRemote()) {
            this.getContext().setManual(true);
            this.getContext().setAutomatic(false);
        } else {
            if (this.getContext().getIntegrationProvider() != null && this.getContext().getIntegrationProvider().supportsManual()) {
                this.getContext().setAutomatic(false);
            }
            if (this.getContext().getIntegrationProvider() != null && this.getContext().getIntegrationProvider().supportsAutomation()) {
                this.getContext().setManual(false);
            }
        }
        this.getContext().setHideIntegration(true);
    }

    @Override
    public void onExit(AttachWizardContext attachWizardContext) {
        boolean bl = this.getContext().getAttachSettings().commit();
        if (bl) {
            this.getContext().setConfigChanged();
        }
        this.getContext().setHideIntegration(false);
    }

    @Override
    public void onFinish(AttachWizardContext attachWizardContext) {
    }

    @Override
    public void onPanelShow() {
        this.model.setSummary(this.buildSummary(this.getContext().getAttachSettings()));
        this.panel.refresh();
    }

    @Override
    protected JPanel getRenderPanel() {
        if (this.panel == null) {
            this.panel = new ReviewSettingsPanelUI(this.model);
        }
        return this.panel;
    }

    private String buildSummary(AttachSettings attachSettings) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<b>");
        stringBuilder.append(Bundle.AttachWizard_TargetTypeString());
        stringBuilder.append("</b> ");
        stringBuilder.append(attachSettings.getTargetType());
        stringBuilder.append("<br>");
        if (!this.getContext().isProviderSingular()) {
            stringBuilder.append("<b>");
            stringBuilder.append(Bundle.AttachWizard_TargetNameTypeString());
            stringBuilder.append("</b> ");
            stringBuilder.append(attachSettings.getServerType());
            stringBuilder.append("<br>");
        }
        stringBuilder.append("<br>");
        stringBuilder.append("<b>");
        stringBuilder.append(Bundle.AttachWizard_TargetNameLocationString());
        stringBuilder.append("</b> ");
        if (attachSettings.isRemote()) {
            stringBuilder.append(Bundle.AttachWizard_RemoteSystemString());
            stringBuilder.append("<br>");
            stringBuilder.append("<b>");
            stringBuilder.append(Bundle.AttachWizard_RemoteSystemHostNameString());
            stringBuilder.append("</b> ");
            stringBuilder.append(attachSettings.getHost());
            stringBuilder.append("<br>");
            stringBuilder.append("<b>");
            stringBuilder.append(Bundle.AttachWizard_RemoteSystemOsString());
            stringBuilder.append("</b> ");
            stringBuilder.append(attachSettings.getHostOS());
            stringBuilder.append("<br>");
        } else {
            stringBuilder.append(Bundle.AttachWizard_LocalMachineString());
            stringBuilder.append("<br>");
            stringBuilder.append("<b>");
            stringBuilder.append(Bundle.AttachWizard_AttachMethodString());
            stringBuilder.append("</b> ");
            stringBuilder.append(attachSettings.isDirect() ? Bundle.AttachWizard_DirectAttachString() : Bundle.AttachWizard_DynamicAttachString());
            stringBuilder.append("<br>");
        }
        return stringBuilder.toString();
    }

    public class Model {
        private String summary;

        public String getProviderName() {
            return ReviewSettingsPanel.this.getContext().getIntegrationProvider().getTitle();
        }

        public void setSummary(String string) {
            this.summary = string;
        }

        public String getSummary() {
            if (this.summary == null) {
                return "";
            }
            return this.summary;
        }
    }
}

