/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.attach.providers;

import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.integration.IntegrationUtils;
import org.netbeans.modules.profiler.attach.providers.Bundle;
import org.netbeans.modules.profiler.attach.providers.SettingsPersistor;
import org.netbeans.modules.profiler.attach.providers.TargetPlatform;
import org.netbeans.modules.profiler.attach.providers.TargetPlatformEnum;
import org.netbeans.modules.profiler.attach.providers.WizardIntegrationProvider;
import org.netbeans.modules.profiler.attach.spi.IntegrationProvider;
import org.netbeans.modules.profiler.attach.wizard.steps.WizardStep;

public abstract class AbstractIntegrationProvider
implements WizardIntegrationProvider {
    protected final String EXPORT_SETENV_MSG = Bundle.ExportSetenvMessage();
    protected final String REDUCE_OVERHEAD_MSG = Bundle.ReduceOverheadMessage();
    protected final String REMOTE_ABSOLUTE_PATH_HINT = Bundle.RemoteAbsolutePathHint("&lt;" + Bundle.RemoteString() + "&gt;");
    protected final String SPACES_IN_PATH_WARNING_MSG = Bundle.SpacesInPathWarningMsg();
    protected WizardStep attachedWizard;
    private final String HTML_REMOTE_STRING = "&lt;" + Bundle.RemoteString() + "&gt;";
    private final String WORK_DIR_MESSAGE = Bundle.WorkDirMessage();
    private String targetJava = "";
    private String targetJavaHomePath = "";

    @Override
    public WizardStep getAttachedWizard() {
        return this.attachedWizard;
    }

    @Override
    public String getDynamicWorkingDirectoryHint(String string, AttachSettings attachSettings) {
        return this.WORK_DIR_MESSAGE;
    }

    @Override
    public final void setTargetJava(String string) {
        this.targetJava = string;
    }

    @Override
    public final String getTargetJava() {
        return this.targetJava;
    }

    @Override
    public final void setTargetJavaHome(String string) {
        this.targetJavaHomePath = string;
    }

    @Override
    public final String getTargetJavaHome() {
        return this.targetJavaHomePath;
    }

    public final void setTargetPlatform(TargetPlatform targetPlatform) {
        if (targetPlatform == null) {
            this.targetJava = "";
            this.targetJavaHomePath = "";
        } else {
            this.targetJava = targetPlatform.getName();
            this.targetJavaHomePath = targetPlatform.getHomePath();
        }
    }

    @Override
    public SettingsPersistor getSettingsPersistor() {
        return SettingsPersistor.NullSettingsPersistor.getInstance();
    }

    @Override
    public boolean supportsAutomation() {
        return true;
    }

    @Override
    public boolean supportsDirect() {
        return true;
    }

    @Override
    public boolean supportsDynamic() {
        return true;
    }

    @Override
    public boolean supportsDynamicPid() {
        return true;
    }

    @Override
    public boolean supportsJVM(TargetPlatformEnum targetPlatformEnum, AttachSettings attachSettings) {
        return !targetPlatformEnum.equals(TargetPlatformEnum.JDK_CVM);
    }

    @Override
    public boolean supportsLocal() {
        return true;
    }

    @Override
    public boolean supportsManual() {
        return true;
    }

    @Override
    public boolean supportsRemote() {
        return true;
    }

    @Override
    public final String getProfilerBinariesLink(AttachSettings attachSettings) {
        if (this.needsSIPWorkaround()) {
            String string = IntegrationUtils.getProfilerAgentCommandLineArgs((String)attachSettings.getHostOS(), (String)this.targetJava, (boolean)attachSettings.isRemote(), (int)attachSettings.getPort());
            return IntegrationUtils.getTemporaryBinariesLink((String)string);
        }
        return null;
    }

    protected abstract int getAttachWizardPriority();

    protected boolean needsSIPWorkaround() {
        return true;
    }

    protected final String getManualRemoteStep1(String string) {
        return Bundle.ManualRemoteStep1Message(this.HTML_REMOTE_STRING);
    }

    protected final String getManualRemoteStep2(String string) {
        return Bundle.ManualRemoteStep2Message(IntegrationUtils.getRemoteCalibrateCommandString((String)string, (String)this.getTargetJava()));
    }

    protected final void addLinkWarning(IntegrationProvider.IntegrationHints integrationHints, String string, AttachSettings attachSettings) {
        String string2 = this.getProfilerBinariesLink(attachSettings);
        if (string2 != null) {
            integrationHints.addWarning(Bundle.IntegrationProvider_TempLinkWarning(string2, string));
        }
    }
}

