/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.ui.components.HTMLLabel;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.heapwalk.Bundle;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;

public class ClassPresenterPanel
extends JPanel
implements HeapFragmentWalker.StateListener {
    private static Icon ICON_CLASS = Icons.getIcon((String)"LanguageIcons.Class");
    private HeaderRenderer headerRenderer;
    private JLabel detailsRenderer;
    private HTMLLabel actionsRenderer;
    private HeapFragmentWalker heapFragmentWalker;

    public ClassPresenterPanel() {
        this.initComponents();
    }

    public void setJavaClass(JavaClass javaClass) {
        if (javaClass != null) {
            String string = javaClass.getName();
            String string2 = Bundle.ClassPresenterPanel_InstancesCountString(javaClass.getInstancesCount());
            String string3 = javaClass.getInstanceSize() != -1 ? "  |  " + Bundle.ClassPresenterPanel_InstanceSizeString(javaClass.getInstanceSize()) : "";
            String string4 = javaClass.getAllInstancesSize() != -1L ? "  |  " + Bundle.ClassPresenterPanel_TotalSizeString(javaClass.getAllInstancesSize()) : "";
            String string5 = javaClass.isArray() ? string2 + string4 : string2 + string3 + string4;
            this.headerRenderer.setText(string);
            this.detailsRenderer.setText(string5);
            this.actionsRenderer.setPreferredSize(new Dimension(this.actionsRenderer.getPreferredSize().width, this.detailsRenderer.getPreferredSize().height));
        }
    }

    public void setHeapFragmentWalker(HeapFragmentWalker heapFragmentWalker) {
        if (this.heapFragmentWalker != null) {
            this.heapFragmentWalker.removeStateListener(this);
        }
        this.heapFragmentWalker = heapFragmentWalker;
        if (this.heapFragmentWalker != null) {
            this.heapFragmentWalker.addStateListener(this);
            this.updateActions(heapFragmentWalker.getRetainedSizesStatus());
        } else {
            this.updateActions(-1);
        }
    }

    @Override
    public void stateChanged(HeapFragmentWalker.StateEvent stateEvent) {
        this.updateActions(stateEvent.getRetainedSizesStatus());
    }

    public void updateActions(int n) {
        switch (n) {
            case -1: 
            case 3: {
                this.actionsRenderer.setVisible(false);
                break;
            }
            case 0: 
            case 1: {
                this.actionsRenderer.setVisible(true);
                this.actionsRenderer.setEnabled(true);
                break;
            }
            case 2: {
                this.actionsRenderer.setVisible(true);
                this.actionsRenderer.setEnabled(false);
            }
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        Color color = UIManager.getLookAndFeel().getID().equals("Metal") ? UIManager.getColor("Button.darkShadow") : UIManager.getColor("Button.shadow");
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(color), BorderFactory.createEmptyBorder(2, 5, 2, 5)));
        this.setOpaque(true);
        this.setBackground(new Color(245, 245, 245));
        this.headerRenderer = new HeaderRenderer();
        this.headerRenderer.setIcon(ICON_CLASS);
        this.headerRenderer.setForeground(UIManager.getColor("ToolTip.foreground"));
        this.headerRenderer.setFont(UIManager.getFont("ToolTip.font"));
        this.headerRenderer.setOpaque(false);
        this.detailsRenderer = new JLabel();
        this.detailsRenderer.setForeground(UIManager.getColor("ToolTip.foreground"));
        this.detailsRenderer.setFont(UIManager.getFont("ToolTip.font"));
        this.detailsRenderer.setOpaque(false);
        this.actionsRenderer = new HTMLLabel(){

            protected void showURL(URL uRL) {
                if (ClassPresenterPanel.this.heapFragmentWalker != null) {
                    BrowserUtils.performTask(new Runnable(){

                        @Override
                        public void run() {
                            ClassPresenterPanel.this.heapFragmentWalker.computeRetainedSizes(true);
                        }
                    });
                }
            }
        };
        this.actionsRenderer.setBorder(BorderFactory.createEmptyBorder());
        this.actionsRenderer.setForeground(UIManager.getColor("ToolTip.foreground"));
        this.actionsRenderer.setFont(UIManager.getFont("ToolTip.font"));
        this.actionsRenderer.setText("&nbsp;&nbsp;|&nbsp;&nbsp;<a href='#'>" + Bundle.ClassPresenterPanel_RetainedSizesString() + "</a>");
        this.actionsRenderer.setOpaque(false);
        this.actionsRenderer.setVisible(false);
        JPanel jPanel = new JPanel(new FlowLayout(3, 0, 0));
        jPanel.setOpaque(false);
        jPanel.add(this.detailsRenderer);
        jPanel.add((Component)this.actionsRenderer);
        this.add((Component)this.headerRenderer, "West");
        this.add((Component)jPanel, "East");
    }

    private static class HeaderRenderer
    extends JLabel {
        private HeaderRenderer() {
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(0, super.getMinimumSize().height);
        }

        @Override
        public void setText(String string) {
            int n = string.lastIndexOf(46);
            if (n == -1) {
                super.setText(string);
            } else {
                String string2 = "<html>" + string.substring(0, ++n) + "<b>" + string.substring(n) + "</b>" + "</html>";
                super.setText(string2);
            }
        }
    }
}

