/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.heapwalk.Bundle;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class CompareSnapshotsHelper {
    private static final Icon memoryIcon = Icons.getIcon((String)"ProfilerIcons.HeapDump");
    private static JFileChooser snapshotFileChooser;
    private static HelpCtx HELP_CTX;
    private HeapFragmentWalker heapWalker;
    private SelectSecondSnapshotPanel secondSnapshotSelector;

    private CompareSnapshotsHelper(HeapFragmentWalker heapFragmentWalker) {
        this.heapWalker = heapFragmentWalker;
    }

    public static File selectSnapshot(HeapFragmentWalker heapFragmentWalker) {
        CompareSnapshotsHelper compareSnapshotsHelper = new CompareSnapshotsHelper(heapFragmentWalker);
        SelectSecondSnapshotPanel selectSecondSnapshotPanel = compareSnapshotsHelper.getSecondSnapshotSelector();
        selectSecondSnapshotPanel.populateSnapshotsList();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)selectSecondSnapshotPanel, Bundle.CompareSnapshotsHelper_SelectDialogCaption(), true, new Object[]{selectSecondSnapshotPanel.getOKButton(), DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, HELP_CTX, null);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        File file = null;
        if (object.equals(selectSecondSnapshotPanel.getOKButton())) {
            file = selectSecondSnapshotPanel.getSnapshot();
        }
        return file;
    }

    private static JFileChooser getSnapshotFileChooser() {
        if (snapshotFileChooser == null) {
            snapshotFileChooser = new JFileChooser();
            snapshotFileChooser.setAcceptAllFileFilterUsed(false);
            snapshotFileChooser.setFileSelectionMode(0);
            snapshotFileChooser.setMultiSelectionEnabled(false);
            snapshotFileChooser.setDialogType(0);
            snapshotFileChooser.setDialogTitle(Bundle.CompareSnapshotsHelper_OpenChooserCaption());
            snapshotFileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || ResultsManager.checkHprofFile((File)file);
                }

                @Override
                public String getDescription() {
                    return Bundle.CompareSnapshotsHelper_OpenChooserFilter();
                }
            });
        }
        return snapshotFileChooser;
    }

    private SelectSecondSnapshotPanel getSecondSnapshotSelector() {
        if (this.secondSnapshotSelector == null) {
            this.secondSnapshotSelector = new SelectSecondSnapshotPanel();
        }
        return this.secondSnapshotSelector;
    }

    static {
        HELP_CTX = new HelpCtx("SelectSecondSnapshot.HelpCtx");
    }

    private class SelectSecondSnapshotPanel
    extends JPanel {
        private JButton externalFileButton;
        private JButton okButton;
        private JLabel externalFileHintLabel;
        private JLabel projectSnapshotsHintLabel;
        private JLabel selectSnapshotLabel;
        private JList projectSnapshotsList;
        private JRadioButton fromFileRadio;
        private JRadioButton fromProjectRadio;
        private JTextField externalFileField;

        public SelectSecondSnapshotPanel() {
            this.initComponents();
        }

        public JButton getOKButton() {
            return this.okButton;
        }

        public File getSnapshot() {
            if (this.fromProjectRadio.isSelected()) {
                Object e = this.projectSnapshotsList.getSelectedValue();
                if (e == null || !(e instanceof FileObject)) {
                    return null;
                }
                return FileUtil.toFile((FileObject)((FileObject)e));
            }
            if (this.fromFileRadio.isSelected()) {
                File file;
                String string = this.externalFileField.getText();
                if (string.length() > 0 && (file = new File(string)).exists() && file.isFile()) {
                    return file;
                }
                return null;
            }
            return null;
        }

        public void populateSnapshotsList() {
            DefaultListModel defaultListModel = (DefaultListModel)this.projectSnapshotsList.getModel();
            defaultListModel.removeAllElements();
            final Lookup.Provider provider = CompareSnapshotsHelper.this.heapWalker.getHeapDumpProject();
            File file = CompareSnapshotsHelper.this.heapWalker.getHeapDumpFile();
            final File file2 = file != null ? file.getParentFile() : null;
            FileObject[] fileObjectArray = ResultsManager.getDefault().listSavedHeapdumps(provider, file2);
            FileObject fileObject = file != null ? FileUtil.toFileObject((File)file) : null;
            for (int i = 0; i < fileObjectArray.length; ++i) {
                if (fileObject != null && fileObjectArray[i].equals(fileObject)) continue;
                defaultListModel.addElement(fileObjectArray[i]);
            }
            if (defaultListModel.getSize() == 0) {
                defaultListModel.addElement(Bundle.CompareSnapshotsHelper_NoComparableSnapshotsFoundMsg());
                this.fromFileRadio.setSelected(true);
                this.externalFileField.addHierarchyListener(new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                        if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && SelectSecondSnapshotPanel.this.externalFileField.isShowing()) {
                            SelectSecondSnapshotPanel.this.externalFileField.removeHierarchyListener(this);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    SelectSecondSnapshotPanel.this.externalFileField.requestFocusInWindow();
                                }
                            });
                        }
                    }
                });
            } else {
                this.projectSnapshotsList.setSelectedIndex(0);
                this.projectSnapshotsList.addHierarchyListener(new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                        if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && SelectSecondSnapshotPanel.this.externalFileField.isShowing()) {
                            SelectSecondSnapshotPanel.this.projectSnapshotsList.removeHierarchyListener(this);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    SelectSecondSnapshotPanel.this.projectSnapshotsList.requestFocusInWindow();
                                }
                            });
                        }
                    }
                });
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (provider != null) {
                        Mnemonics.setLocalizedText((AbstractButton)SelectSecondSnapshotPanel.this.fromProjectRadio, (String)Bundle.CompareSnapshotsHelper_FromProjectRadioText());
                        SelectSecondSnapshotPanel.this.fromProjectRadio.setToolTipText(null);
                    } else {
                        Mnemonics.setLocalizedText((AbstractButton)SelectSecondSnapshotPanel.this.fromProjectRadio, (String)Bundle.CompareSnapshotsHelper_FromCurrentLocationRadioText());
                        SelectSecondSnapshotPanel.this.fromProjectRadio.setToolTipText(file2 != null ? file2.getAbsolutePath() : null);
                    }
                }
            });
        }

        private void initComponents() {
            this.okButton = new JButton(Bundle.CompareSnapshotsHelper_OkButtonText());
            this.setLayout(new GridBagLayout());
            ButtonGroup buttonGroup = new ButtonGroup();
            this.selectSnapshotLabel = new JLabel(Bundle.CompareSnapshotsHelper_SelectSnapshotString());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(15, 10, 8, 10);
            this.add((Component)this.selectSnapshotLabel, gridBagConstraints);
            this.fromProjectRadio = new JRadioButton();
            Mnemonics.setLocalizedText((AbstractButton)this.fromProjectRadio, (String)Bundle.CompareSnapshotsHelper_FromProjectRadioText());
            buttonGroup.add(this.fromProjectRadio);
            this.fromProjectRadio.getAccessibleContext().setAccessibleDescription(Bundle.CompareSnapshotsHelper_SelectSnapshotString() + Bundle.CompareSnapshotsHelper_FromProjectRadioText());
            this.fromProjectRadio.setSelected(true);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 15, 0, 10);
            this.add((Component)this.fromProjectRadio, gridBagConstraints);
            this.projectSnapshotsList = new JList(new DefaultListModel());
            this.projectSnapshotsList.getAccessibleContext().setAccessibleName(Bundle.CompareSnapshotsHelper_SnapshotsListAccessDescr());
            this.projectSnapshotsList.setVisibleRowCount(5);
            this.projectSnapshotsList.setSelectionMode(0);
            JScrollPane jScrollPane = new JScrollPane(this.projectSnapshotsList, 20, 31);
            jScrollPane.setPreferredSize(new Dimension(1, jScrollPane.getPreferredSize().height));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(0, 15 + new JRadioButton((String)"").getPreferredSize().width, 5, 10);
            this.add((Component)jScrollPane, gridBagConstraints);
            this.projectSnapshotsHintLabel = new JLabel(" ");
            this.projectSnapshotsHintLabel.setForeground(Color.darkGray);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 15 + new JRadioButton((String)"").getPreferredSize().width, 5, 10);
            this.add((Component)this.projectSnapshotsHintLabel, gridBagConstraints);
            this.fromFileRadio = new JRadioButton(Bundle.CompareSnapshotsHelper_FromFileRadioText());
            Mnemonics.setLocalizedText((AbstractButton)this.fromFileRadio, (String)Bundle.CompareSnapshotsHelper_FromFileRadioText());
            buttonGroup.add(this.fromFileRadio);
            this.fromProjectRadio.getAccessibleContext().setAccessibleDescription(Bundle.CompareSnapshotsHelper_SelectSnapshotString() + Bundle.CompareSnapshotsHelper_FromFileRadioText());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(5, 15, 0, 10);
            this.add((Component)this.fromFileRadio, gridBagConstraints);
            this.externalFileField = new JTextField();
            this.externalFileField.setPreferredSize(new Dimension(250, this.externalFileField.getPreferredSize().height));
            this.externalFileField.setEnabled(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 15 + new JRadioButton((String)"").getPreferredSize().width, 5, 5);
            this.add((Component)this.externalFileField, gridBagConstraints);
            this.externalFileButton = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)this.externalFileButton, (String)Bundle.CompareSnapshotsHelper_BrowseButtonText());
            this.externalFileButton.getAccessibleContext().setAccessibleDescription(Bundle.CompareSnapshotsHelper_BrowseButtonAccessDescr());
            this.externalFileButton.setEnabled(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 5, 5, 10);
            this.add((Component)this.externalFileButton, gridBagConstraints);
            this.externalFileHintLabel = new JLabel(" ");
            this.externalFileHintLabel.setForeground(Color.darkGray);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 6;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 15 + new JRadioButton((String)"").getPreferredSize().width, 5, 10);
            this.add((Component)this.externalFileHintLabel, gridBagConstraints);
            this.projectSnapshotsList.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                    if (object instanceof FileObject) {
                        FileObject fileObject = (FileObject)object;
                        jLabel.setIcon(memoryIcon);
                        jLabel.setText(ResultsManager.getDefault().getHeapDumpDisplayName(fileObject.getName()));
                        Set set = WindowManager.getDefault().getRegistry().getOpened();
                        for (TopComponent topComponent : set) {
                            Object object2 = topComponent.getClientProperty((Object)"HeapDumpFileName");
                            if (object2 == null || !FileUtil.toFile((FileObject)fileObject).equals(new File(object2.toString()))) continue;
                            jLabel.setFont(jLabel.getFont().deriveFont(1));
                            break;
                        }
                    }
                    return jLabel;
                }
            });
            this.projectSnapshotsList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    SelectSecondSnapshotPanel.this.updateOKButton();
                }
            });
            this.projectSnapshotsList.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2 && SelectSecondSnapshotPanel.this.projectSnapshotsList.getSelectedValue() != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SelectSecondSnapshotPanel.this.okButton.doClick();
                            }
                        });
                    }
                }
            });
            this.fromProjectRadio.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    SelectSecondSnapshotPanel.this.projectSnapshotsList.setEnabled(SelectSecondSnapshotPanel.this.fromProjectRadio.isSelected());
                    SelectSecondSnapshotPanel.this.projectSnapshotsHintLabel.setText(" ");
                    SelectSecondSnapshotPanel.this.updateOKButton();
                }
            });
            this.fromFileRadio.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    SelectSecondSnapshotPanel.this.externalFileField.setEnabled(SelectSecondSnapshotPanel.this.fromFileRadio.isSelected());
                    SelectSecondSnapshotPanel.this.externalFileButton.setEnabled(SelectSecondSnapshotPanel.this.fromFileRadio.isSelected());
                    if (!SelectSecondSnapshotPanel.this.fromFileRadio.isSelected()) {
                        SelectSecondSnapshotPanel.this.externalFileHintLabel.setText(" ");
                    }
                    SelectSecondSnapshotPanel.this.updateOKButton();
                }
            });
            DocumentListener documentListener = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    SelectSecondSnapshotPanel.this.updateOKButton();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    SelectSecondSnapshotPanel.this.updateOKButton();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    SelectSecondSnapshotPanel.this.updateOKButton();
                }
            };
            this.externalFileField.getDocument().addDocumentListener(documentListener);
            this.externalFileButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    File file;
                    JFileChooser jFileChooser = CompareSnapshotsHelper.getSnapshotFileChooser();
                    jFileChooser.setCurrentDirectory(new File(SelectSecondSnapshotPanel.this.externalFileField.getText()));
                    if (jFileChooser.showOpenDialog(WindowManager.getDefault().getMainWindow()) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                        SelectSecondSnapshotPanel.this.externalFileField.setText(file.getAbsolutePath());
                    }
                }
            });
            this.updateOKButton();
        }

        private void updateOKButton() {
            if (this.fromProjectRadio.isSelected()) {
                Object e = this.projectSnapshotsList.getSelectedValue();
                this.okButton.setEnabled(e != null && !(e instanceof String));
            } else if (this.fromFileRadio.isSelected()) {
                String string = this.externalFileField.getText();
                if (string.length() > 0) {
                    File file = new File(string);
                    if (file.exists() && ResultsManager.checkHprofFile((File)file)) {
                        if (file.equals(CompareSnapshotsHelper.this.heapWalker.getHeapDumpFile())) {
                            this.externalFileHintLabel.setText(Bundle.CompareSnapshotsHelper_ComparingSameSnapshotsMsg());
                            this.okButton.setEnabled(false);
                        } else {
                            this.externalFileHintLabel.setText(" ");
                            this.okButton.setEnabled(true);
                        }
                    } else {
                        this.externalFileHintLabel.setText(Bundle.CompareSnapshotsHelper_InvalidFileMsg());
                        this.okButton.setEnabled(false);
                    }
                } else {
                    this.externalFileHintLabel.setText(Bundle.CompareSnapshotsHelper_EnterFileMsg());
                    this.okButton.setEnabled(false);
                }
            } else {
                this.okButton.setEnabled(false);
            }
        }
    }
}

