/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.heap.GCRoot;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.heapwalk.AbstractController;
import org.netbeans.modules.profiler.heapwalk.Bundle;
import org.netbeans.modules.profiler.heapwalk.InstancesController;
import org.netbeans.modules.profiler.heapwalk.model.AbstractHeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.model.ChildrenComputer;
import org.netbeans.modules.profiler.heapwalk.model.ClassNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNodeFactory;
import org.netbeans.modules.profiler.heapwalk.ui.InstancesListControllerUI;

public class InstancesListController
extends AbstractController {
    public static final AbstractHeapWalkerNode EMPTY_INSTANCE_NODE = new AbstractHeapWalkerNode(null){

        @Override
        protected String computeName() {
            return Bundle.InstancesListController_NoInstanceString();
        }

        @Override
        protected String computeType() {
            return "";
        }

        @Override
        protected String computeValue() {
            return "";
        }

        @Override
        protected String computeSize() {
            return "";
        }

        @Override
        protected String computeRetainedSize() {
            return "";
        }

        @Override
        protected Icon computeIcon() {
            return null;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }
    };
    public static final Instance INSTANCE_FIRST = new Instance(){

        public JavaClass getJavaClass() {
            return null;
        }

        public long getInstanceId() {
            return -1L;
        }

        public int getInstanceNumber() {
            return -1;
        }

        public int getSize() {
            return -1;
        }

        public int getRetainedSize() {
            return -1;
        }

        public int getReachableSize() {
            return -1;
        }

        public List getFieldValues() {
            return null;
        }

        public Object getValueOfField(String string) {
            return null;
        }

        public List getStaticFieldValues() {
            return null;
        }

        public List getReferences() {
            return null;
        }

        public boolean isGCRoot() {
            return false;
        }

        public Instance getNearestGCRootPointer() {
            return null;
        }
    };
    public Instance instanceToSelect;
    public int containerToSelectIndex;
    private Instance selectedInstance;
    private InstancesController instancesController;
    private JavaClass jClass;
    private TreePath pathToSelect;

    public InstancesListController(InstancesController instancesController) {
        this.instancesController = instancesController;
    }

    public void setClass(JavaClass javaClass) {
        this.jClass = javaClass;
        ((InstancesListControllerUI)((Object)this.getPanel())).initColumns();
        this.update();
    }

    public HeapWalkerNode getFilteredSortedInstances(String string, int n, boolean bl) {
        if (this.jClass == null) {
            return EMPTY_INSTANCE_NODE;
        }
        return this.getInstances(this.jClass, string, n, bl);
    }

    public HeapWalkerNode getInstanceContainer(Instance instance, InstancesListClassNode instancesListClassNode) {
        HeapWalkerNode heapWalkerNode = null;
        List list = this.jClass.getInstances();
        List list2 = this.getFilteredInstances(list, instancesListClassNode.filterValue);
        List list3 = this.getSortedInstances(list2, instancesListClassNode.sortingColumn, instancesListClassNode.sortingOrder);
        int n = list3.indexOf(instance);
        if (n != -1) {
            int n2 = list3.size();
            BrowserUtils.GroupingInfo groupingInfo = BrowserUtils.getGroupingInfo(n2);
            int n3 = groupingInfo.containersCount;
            int n4 = groupingInfo.collapseUnitSize;
            heapWalkerNode = instancesListClassNode.getChild(n / n4);
        }
        return heapWalkerNode;
    }

    public InstancesController getInstancesController() {
        return this.instancesController;
    }

    public Instance getSelectedInstance() {
        return this.selectedInstance;
    }

    public void instanceSelected(Instance instance) {
        if (this.selectedInstance == instance) {
            return;
        }
        this.selectedInstance = instance;
        this.instancesController.instanceSelected();
    }

    public void scheduleContainerSelection(int n) {
        this.containerToSelectIndex = n;
        this.instanceToSelect = null;
    }

    public void scheduleFirstInstanceSelection() {
        this.instanceToSelect = INSTANCE_FIRST;
        this.containerToSelectIndex = -1;
    }

    public void scheduleInstanceSelection(Instance instance) {
        this.instanceToSelect = instance;
        this.containerToSelectIndex = -1;
    }

    public void selectInstance(Instance instance) {
        ((InstancesListControllerUI)((Object)this.getPanel())).makeVisible();
        ((InstancesListControllerUI)((Object)this.getPanel())).selectInstance(instance);
    }

    public void showInstance(Instance instance) {
        if (this.jClass != instance.getJavaClass()) {
            this.scheduleInstanceSelection(instance);
            this.setClass(instance.getJavaClass());
        } else {
            this.selectInstance(instance);
        }
    }

    public void update() {
        ((InstancesListControllerUI)((Object)this.getPanel())).update();
    }

    @Override
    protected AbstractButton createControllerPresenter() {
        return ((InstancesListControllerUI)((Object)this.getPanel())).getPresenter();
    }

    @Override
    protected JPanel createControllerUI() {
        return new InstancesListControllerUI(this);
    }

    private List getFilteredInstances(List list, String string) {
        return list;
    }

    private HeapWalkerNode getInstances(JavaClass javaClass, String string, int n, boolean bl) {
        return new InstancesListClassNode(javaClass, string, n, bl);
    }

    private List getSortedInstances(List list, int n, boolean bl) {
        Collections.sort(list, new InstancesComparator(n, bl));
        return list;
    }

    private boolean matchesFilter(Instance instance, String string) {
        return true;
    }

    private static class InstancesComparator
    implements Comparator {
        private boolean sortingOrder;
        private int sortingColumn;

        public InstancesComparator(int n, boolean bl) {
            this.sortingColumn = n;
            this.sortingOrder = bl;
        }

        public int compare(Object object, Object object2) {
            Instance instance = this.sortingOrder ? (Instance)object : (Instance)object2;
            Instance instance2 = this.sortingOrder ? (Instance)object2 : (Instance)object;
            switch (this.sortingColumn) {
                case 0: {
                    return Integer.valueOf(instance.getInstanceNumber()).compareTo(instance2.getInstanceNumber());
                }
                case 1: {
                    return Long.valueOf(instance.getInstanceId()).compareTo(instance2.getInstanceId());
                }
                case 2: {
                    return Integer.valueOf(instance.getSize()).compareTo(instance2.getSize());
                }
                case 3: {
                    return Integer.valueOf(instance.getRetainedSize()).compareTo(instance2.getRetainedSize());
                }
                case 4: {
                    return Integer.valueOf(instance.getReachableSize()).compareTo(instance2.getReachableSize());
                }
            }
            throw new RuntimeException("Unsupported compare operation for " + object + ", " + object2);
        }
    }

    public static class InstancesListInstanceNode
    implements HeapWalkerNode,
    InstancesListNode {
        private static final NumberFormat numberFormat = NumberFormat.getInstance();
        private HeapWalkerNode parent;
        private ImageIcon icon;
        private Instance instance;
        private String name;
        private String reachableSize;
        private String retainedSize;
        private String size;

        public InstancesListInstanceNode(Instance instance, HeapWalkerNode heapWalkerNode) {
            this.parent = heapWalkerNode;
            this.instance = instance;
            this.name = "#" + instance.getInstanceNumber();
        }

        @Override
        public HeapWalkerNode getChild(int n) {
            return null;
        }

        @Override
        public HeapWalkerNode[] getChildren() {
            return new HeapWalkerNode[0];
        }

        @Override
        public Icon getIcon() {
            if (this.icon == null) {
                this.icon = this.computeIcon();
            }
            return this.icon;
        }

        @Override
        public int getIndexOfChild(Object object) {
            return -1;
        }

        public Instance getInstance() {
            return this.instance;
        }

        @Override
        public String getID() {
            return "0x" + Long.toHexString(this.getInstance().getInstanceId());
        }

        @Override
        public TreePath getInstancePath(Instance instance) {
            TreePath treePath = null;
            if (this.instance.equals(instance)) {
                ArrayList<InstancesListInstanceNode> arrayList = new ArrayList<InstancesListInstanceNode>();
                for (HeapWalkerNode heapWalkerNode = this; heapWalkerNode != null; heapWalkerNode = heapWalkerNode.getParent()) {
                    arrayList.add(0, (InstancesListInstanceNode)heapWalkerNode);
                }
                treePath = new TreePath(arrayList.toArray());
            }
            return treePath;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public int getMode() {
            return 0;
        }

        @Override
        public int getNChildren() {
            return 0;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public HeapWalkerNode getParent() {
            return this.parent;
        }

        @Override
        public String getReachableSize() {
            if (this.reachableSize == null) {
                this.reachableSize = "N/A";
            }
            return this.reachableSize;
        }

        @Override
        public String getRetainedSize() {
            if (this.retainedSize == null) {
                this.retainedSize = numberFormat.format(this.instance.getRetainedSize());
            }
            return this.retainedSize;
        }

        @Override
        public boolean isRoot() {
            return false;
        }

        @Override
        public String getSimpleType() {
            return this.parent.getSimpleType();
        }

        @Override
        public String getSize() {
            if (this.size == null) {
                this.size = numberFormat.format(this.instance.getSize());
            }
            return this.size;
        }

        @Override
        public String getType() {
            return this.parent.getType();
        }

        @Override
        public String getValue() {
            return this.parent.getValue();
        }

        @Override
        public boolean currentlyHasChildren() {
            return false;
        }

        public String toString() {
            return this.getName();
        }

        protected ImageIcon computeIcon() {
            return this.getInstance().getJavaClass().isArray() ? BrowserUtils.ICON_ARRAY : BrowserUtils.ICON_INSTANCE;
        }
    }

    public class InstancesListContainerNode
    extends AbstractHeapWalkerNode
    implements InstancesListNode {
        private String filterValue;
        private boolean sortingOrder;
        private int endIndex;
        private int sortingColumn;
        private int startIndex;

        public InstancesListContainerNode(ClassNode classNode, int n, int n2, String string, int n3, boolean bl) {
            super(classNode);
            this.startIndex = n;
            this.endIndex = n2;
            this.filterValue = string;
            this.sortingColumn = n3;
            this.sortingOrder = bl;
        }

        public InstancesListContainerNode(ClassNode classNode, int n, int n2, String string, int n3, boolean bl, List list, int n4) {
            this(classNode, n, n2, string, n3, bl);
            int n5 = n2 - n + 1;
            HeapWalkerNode[] heapWalkerNodeArray = new HeapWalkerNode[n5];
            for (int i = 0; i < n5; ++i) {
                heapWalkerNodeArray[i] = new InstancesListInstanceNode((Instance)list.get(n + i), this);
                if (n4 != n + i) continue;
                instancesListController.pathToSelect = new TreePath(new Object[]{classNode, this, heapWalkerNodeArray[i]});
            }
            instancesListController.instanceToSelect = null;
            instancesListController.containerToSelectIndex = -1;
            this.setChildren(heapWalkerNodeArray);
        }

        @Override
        public TreePath getInstancePath(Instance instance) {
            TreePath treePath = null;
            if (this.currentlyHasChildren()) {
                HeapWalkerNode[] heapWalkerNodeArray = this.getChildren();
                for (int i = 0; !(i >= heapWalkerNodeArray.length || heapWalkerNodeArray[i] instanceof InstancesListNode && (treePath = ((InstancesListNode)((Object)heapWalkerNodeArray[i])).getInstancePath(instance)) != null); ++i) {
                }
            }
            return treePath;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public String getID() {
            return "";
        }

        @Override
        public String getReachableSize() {
            return "";
        }

        protected ChildrenComputer getChildrenComputer() {
            return new ChildrenComputer(){

                @Override
                public HeapWalkerNode[] computeChildren() {
                    int n = InstancesListContainerNode.this.endIndex - InstancesListContainerNode.this.startIndex + 1;
                    HeapWalkerNode[] heapWalkerNodeArray = new HeapWalkerNode[n];
                    List list = ((ClassNode)InstancesListContainerNode.this.getParent()).getJavaClass().getInstances();
                    List list2 = InstancesListController.this.getFilteredInstances(list, InstancesListContainerNode.this.filterValue);
                    List list3 = InstancesListController.this.getSortedInstances(list2, InstancesListContainerNode.this.sortingColumn, InstancesListContainerNode.this.sortingOrder);
                    for (int i = 0; i < heapWalkerNodeArray.length; ++i) {
                        Instance instance = (Instance)list3.get(InstancesListContainerNode.this.startIndex + i);
                        heapWalkerNodeArray[i] = new InstancesListInstanceNode(instance, InstancesListContainerNode.this);
                        if (InstancesListController.this.instanceToSelect == null || (InstancesListContainerNode.this.startIndex + i != 0 || InstancesListController.this.instanceToSelect != INSTANCE_FIRST) && !instance.equals(InstancesListController.this.instanceToSelect)) continue;
                        InstancesListController.this.pathToSelect = new TreePath(new Object[]{heapWalkerNodeArray[i].getParent().getParent(), heapWalkerNodeArray[i].getParent(), heapWalkerNodeArray[i]});
                        InstancesListController.this.instanceToSelect = null;
                        InstancesListController.this.containerToSelectIndex = -1;
                    }
                    return heapWalkerNodeArray;
                }
            };
        }

        @Override
        protected HeapWalkerNode[] computeChildren() {
            return BrowserUtils.lazilyCreateChildren(this, this.getChildrenComputer());
        }

        @Override
        protected Icon computeIcon() {
            return null;
        }

        @Override
        protected String computeName() {
            return Bundle.InstancesListController_InstancesNumberString(this.endIndex - this.startIndex + 1);
        }

        @Override
        protected String computeType() {
            return this.getParent().getType();
        }

        @Override
        protected String computeValue() {
            return this.getParent().getValue();
        }

        @Override
        protected String computeSize() {
            return "";
        }

        @Override
        protected String computeRetainedSize() {
            return "";
        }
    }

    public class InstancesListClassNode
    extends ClassNode.RootNode
    implements InstancesListNode {
        String filterValue;
        boolean sortingOrder;
        int sortingColumn;
        private String size;

        public InstancesListClassNode(JavaClass javaClass, String string, int n, boolean bl) {
            super(javaClass, "class", null);
            this.size = String.valueOf(javaClass.getAllInstancesSize());
            this.filterValue = string;
            this.sortingColumn = n;
            this.sortingOrder = bl;
        }

        @Override
        public GCRoot getGCRoot(Instance instance) {
            return InstancesListController.this.instancesController.getHeapFragmentWalker().getHeapFragment().getGCRoot(instance);
        }

        @Override
        public TreePath getInstancePath(Instance instance) {
            TreePath treePath = null;
            if (this.currentlyHasChildren()) {
                HeapWalkerNode[] heapWalkerNodeArray = this.getChildren();
                for (int i = 0; !(i >= heapWalkerNodeArray.length || heapWalkerNodeArray[i] instanceof InstancesListNode && (treePath = ((InstancesListNode)((Object)heapWalkerNodeArray[i])).getInstancePath(instance)) != null); ++i) {
                }
            }
            return treePath;
        }

        @Override
        public String getID() {
            return "0x" + Long.toHexString(this.getJavaClass().getJavaClassId());
        }

        @Override
        public JavaClass getJavaClassByID(long l) {
            return InstancesListController.this.instancesController.getHeapFragmentWalker().getHeapFragment().getJavaClassByID(l);
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public String getReachableSize() {
            return "N/A";
        }

        @Override
        public String getRetainedSize() {
            return "N/A";
        }

        @Override
        public String getSize() {
            return this.size;
        }

        @Override
        public void refreshView() {
            ((InstancesListControllerUI)((Object)InstancesListController.this.getPanel())).refreshView();
            if (InstancesListController.this.pathToSelect != null) {
                ((InstancesListControllerUI)((Object)InstancesListController.this.getPanel())).selectPath(InstancesListController.this.pathToSelect);
                InstancesListController.this.pathToSelect = null;
            }
        }

        @Override
        protected HeapWalkerNode[] computeChildren() {
            return BrowserUtils.lazilyCreateChildren(this, new ChildrenComputer(){

                @Override
                public HeapWalkerNode[] computeChildren() {
                    HeapWalkerNode[] heapWalkerNodeArray = null;
                    List list = InstancesListClassNode.this.getJavaClass().getInstances();
                    List list2 = InstancesListController.this.getFilteredInstances(list, InstancesListClassNode.this.filterValue);
                    List list3 = null;
                    if (InstancesListController.this.instanceToSelect != null) {
                        list3 = InstancesListController.this.getSortedInstances(list2, InstancesListClassNode.this.sortingColumn, InstancesListClassNode.this.sortingOrder);
                    }
                    if (list2.size() == 0) {
                        heapWalkerNodeArray = new HeapWalkerNode[]{HeapWalkerNodeFactory.createNoItemsNode(InstancesListClassNode.this)};
                    } else if (list2.size() > 2000) {
                        int n = -1;
                        if (InstancesListController.this.instanceToSelect != null) {
                            n = InstancesListController.this.instanceToSelect == INSTANCE_FIRST ? 0 : list3.indexOf(InstancesListController.this.instanceToSelect);
                        }
                        int n2 = list2.size();
                        BrowserUtils.GroupingInfo groupingInfo = BrowserUtils.getGroupingInfo(n2);
                        int n3 = groupingInfo.containersCount;
                        int n4 = groupingInfo.collapseUnitSize;
                        heapWalkerNodeArray = new HeapWalkerNode[n3];
                        for (int i = 0; i < n3; ++i) {
                            int n5 = n4 * i;
                            int n6 = Math.min(n5 + n4, n2) - 1;
                            if (n != -1 && n >= n5 && n <= n6) {
                                heapWalkerNodeArray[i] = new InstancesListContainerNode(InstancesListClassNode.this, n5, n6, InstancesListClassNode.this.filterValue, InstancesListClassNode.this.sortingColumn, InstancesListClassNode.this.sortingOrder, list3, n);
                                n = -1;
                                continue;
                            }
                            heapWalkerNodeArray[i] = new InstancesListContainerNode(InstancesListClassNode.this, n5, n6, InstancesListClassNode.this.filterValue, InstancesListClassNode.this.sortingColumn, InstancesListClassNode.this.sortingOrder);
                            if (InstancesListController.this.containerToSelectIndex != i) continue;
                            InstancesListController.this.pathToSelect = new TreePath(new Object[]{InstancesListClassNode.this, heapWalkerNodeArray[i]});
                            InstancesListController.this.containerToSelectIndex = -1;
                            InstancesListController.this.instanceToSelect = null;
                        }
                        InstancesListController.this.containerToSelectIndex = -1;
                        InstancesListController.this.instanceToSelect = null;
                    } else {
                        if (list3 == null) {
                            list3 = InstancesListController.this.getSortedInstances(list2, InstancesListClassNode.this.sortingColumn, InstancesListClassNode.this.sortingOrder);
                        }
                        heapWalkerNodeArray = new HeapWalkerNode[list3.size()];
                        for (int i = 0; i < heapWalkerNodeArray.length; ++i) {
                            Instance instance = (Instance)list3.get(i);
                            heapWalkerNodeArray[i] = new InstancesListInstanceNode(instance, InstancesListClassNode.this);
                            if (InstancesListController.this.instanceToSelect == null || (i != 0 || InstancesListController.this.instanceToSelect != INSTANCE_FIRST) && !instance.equals(InstancesListController.this.instanceToSelect)) continue;
                            InstancesListController.this.pathToSelect = new TreePath(new Object[]{InstancesListClassNode.this, heapWalkerNodeArray[i]});
                            InstancesListController.this.instanceToSelect = null;
                            InstancesListController.this.containerToSelectIndex = -1;
                        }
                        InstancesListController.this.instanceToSelect = null;
                        InstancesListController.this.containerToSelectIndex = -1;
                    }
                    return heapWalkerNodeArray;
                }
            });
        }

        @Override
        protected ImageIcon computeIcon() {
            return this.getJavaClass().isArray() ? BrowserUtils.ICON_ARRAY : BrowserUtils.ICON_INSTANCE;
        }

        @Override
        protected String computeName() {
            return InstancesListController.this.jClass.getName();
        }
    }

    public static interface InstancesListNode {
        public TreePath getInstancePath(Instance var1);

        public String getName();

        public String getReachableSize();

        public String getRetainedSize();

        public String getSize();

        public String getID();
    }
}

