/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.core.output2.AbstractLines;
import org.netbeans.core.output2.BufferResource;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.OutWriter;
import org.netbeans.core.output2.Storage;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class FileMapStorage
implements Storage {
    private FileChannel fileChannel;
    private static final int BASE_BUFFER_SIZE = 8196;
    private static final long MAX_MAP_RANGE = 0x100000L;
    private static final RequestProcessor RP = new RequestProcessor("FileMapStorage");
    private static final Set<FileMapStorage> undisposed = new HashSet<FileMapStorage>();
    private ByteBuffer master;
    private MappedBufferResource contents;
    private long mappedRange;
    private long mappedStart;
    private ByteBuffer buffer = null;
    protected int bytesWritten = 0;
    private File outfile = null;
    private int outstandingBufferCount = 0;
    private boolean closed;

    FileMapStorage() {
        this.init();
    }

    private void init() {
        this.contents = null;
        this.mappedRange = -1L;
        this.mappedStart = 0L;
        this.master = ByteBuffer.allocateDirect(8196);
        this.fileChannel = null;
        this.buffer = null;
        this.bytesWritten = 0;
        this.closed = true;
        FileMapStorage.addUndisposed(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void ensureFileExists() throws IOException {
        File file;
        if (this.outfile != null) return;
        String string = System.getProperty("java.io.tmpdir");
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        if (!(file = new File(string)).exists()) {
            IllegalStateException illegalStateException = new IllegalStateException("Cannot find temp directory " + string);
            Exceptions.attachLocalizedMessage((Throwable)illegalStateException, (String)NbBundle.getMessage(OutWriter.class, (String)"FMT_CannotWrite", (Object)string));
            throw illegalStateException;
        }
        Class<FileMapStorage> clazz = FileMapStorage.class;
        synchronized (FileMapStorage.class) {
            StringBuilder stringBuilder = new StringBuilder(string).append("output").append(Long.toString(System.currentTimeMillis()));
            this.outfile = new File(stringBuilder.toString());
            while (this.outfile.exists()) {
                stringBuilder.append('x');
                this.outfile = new File(stringBuilder.toString());
            }
            this.outfile.createNewFile();
            if (!this.outfile.exists() || !this.outfile.canWrite()) {
                IllegalStateException illegalStateException = new IllegalStateException("Cannot write to " + stringBuilder);
                Exceptions.attachLocalizedMessage((Throwable)illegalStateException, (String)NbBundle.getMessage(OutWriter.class, (String)"FMT_CannotWrite", (Object)string));
                throw illegalStateException;
            }
            this.outfile.deleteOnExit();
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return;
        }
    }

    public String toString() {
        return this.outfile == null ? "[unused or disposed FileMapStorage]" : this.outfile.getPath();
    }

    private FileChannel writeChannel() throws IOException {
        FileChannel fileChannel = this.fileChannel();
        this.closed = !fileChannel.isOpen();
        return fileChannel;
    }

    private FileChannel fileChannel() throws IOException {
        if (this.fileChannel == null || !this.fileChannel.isOpen()) {
            this.ensureFileExists();
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.outfile, "rw");
            this.fileChannel = randomAccessFile.getChannel();
        }
        return this.fileChannel;
    }

    @Override
    public synchronized ByteBuffer getWriteBuffer(int n) {
        int n2;
        if (this.master.capacity() - this.master.position() < n) {
            n2 = Math.max(16392, n + 8196);
            this.master = ByteBuffer.allocateDirect(n2);
        }
        if (this.buffer == null) {
            this.buffer = this.master.slice();
        } else {
            n2 = AbstractLines.toCharIndex(this.buffer.capacity() - this.buffer.position());
            if (n2 < n) {
                this.buffer.flip();
                this.buffer = this.master.slice();
            }
        }
        ++this.outstandingBufferCount;
        return this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        FileMapStorage fileMapStorage = this;
        synchronized (fileMapStorage) {
            if (byteBuffer == this.buffer) {
                this.buffer = null;
            }
        }
        int n = this.size();
        int n2 = byteBuffer.position();
        byteBuffer.flip();
        FileChannel fileChannel = this.writeChannel();
        if (fileChannel.isOpen()) {
            Thread.interrupted();
            fileChannel.write(byteBuffer);
            FileMapStorage fileMapStorage2 = this;
            synchronized (fileMapStorage2) {
                this.bytesWritten += n2;
                --this.outstandingBufferCount;
            }
        }
        return n;
    }

    @Override
    public synchronized void dispose() {
        if (Controller.LOG) {
            Controller.log("Disposing file map storage");
            Controller.logStack();
        }
        final FileChannel fileChannel = this.fileChannel;
        final File file = this.outfile;
        final MappedBufferResource mappedBufferResource = this.contents;
        this.fileChannel = null;
        this.closed = true;
        this.outfile = null;
        this.buffer = null;
        this.contents = null;
        if (fileChannel != null || file != null) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (mappedBufferResource != null) {
                            mappedBufferResource.releaseBuffer();
                        }
                        if (fileChannel != null && fileChannel.isOpen()) {
                            fileChannel.close();
                        }
                        if (file != null && file.exists()) {
                            file.delete();
                        }
                    }
                    catch (Exception exception) {
                        Exceptions.printStackTrace((Throwable)exception);
                    }
                }
            });
        }
        FileMapStorage.removeUndisposed(this);
    }

    File getOutputFile() {
        return this.outfile;
    }

    private static void unmap(Object object) {
        try {
            Method method = object.getClass().getMethod("cleaner", new Class[0]);
            method.setAccessible(true);
            Object object2 = method.invoke(object, new Object[0]);
            if (object2 != null) {
                object2.getClass().getMethod("clean", new Class[0]).invoke(object2, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferResource<ByteBuffer> getReadBuffer(int n, int n2) throws IOException {
        ByteBuffer byteBuffer;
        FileMapStorage fileMapStorage = this;
        synchronized (fileMapStorage) {
            ByteBuffer byteBuffer2 = byteBuffer = this.contents == null ? null : this.contents.getBuffer();
            if (byteBuffer == null || (long)(n + n2) > this.mappedRange || (long)n < this.mappedStart) {
                FileChannel fileChannel = this.fileChannel();
                this.mappedStart = Math.max(0L, (long)n - 524288L);
                long l = this.mappedRange;
                long l2 = (long)n2 > 524288L ? (long)(n2 + n2 / 10) : 524288L;
                this.mappedRange = Math.min(fileChannel.size(), (long)n + l2);
                try {
                    try {
                        byteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, this.mappedStart, this.mappedRange - this.mappedStart);
                        this.updateContents(byteBuffer);
                    }
                    catch (IOException iOException) {
                        Logger.getAnonymousLogger().info("Failed to memory map output file for reading. Trying to read it normally.");
                        byteBuffer = ByteBuffer.allocate((int)(this.mappedRange - this.mappedStart));
                        fileChannel.read(byteBuffer, this.mappedStart);
                        this.updateContents(byteBuffer);
                    }
                }
                catch (IOException iOException) {
                    Logger.getAnonymousLogger().info("Failed to read output file. Start:" + n + " bytes reqd=" + n2 + " mapped range=" + this.mappedRange + " previous mapped range=" + l + " channel size: " + fileChannel.size());
                    throw iOException;
                }
            }
            if ((long)n - this.mappedStart > (long)(byteBuffer.limit() - n2)) {
                byteBuffer.position(Math.max(0, byteBuffer.limit() - n2));
            } else {
                byteBuffer.position((int)((long)n - this.mappedStart));
            }
        }
        int n3 = Math.min(byteBuffer.limit(), n2);
        try {
            return new ChildBufferResource((ByteBuffer)byteBuffer.slice().limit(n3), this.contents);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Error setting limit to " + n3 + " contents size = " + byteBuffer.limit() + " requested: read " + "buffer from " + n + " to be " + n2 + " bytes");
        }
    }

    private void updateContents(ByteBuffer byteBuffer) {
        if (this.contents != null) {
            this.contents.decRefs();
        }
        this.contents = new MappedBufferResource(byteBuffer);
        this.contents.incRefs();
    }

    @Override
    public synchronized int size() {
        return this.bytesWritten;
    }

    @Override
    public void flush() throws IOException {
        if (this.buffer != null) {
            if (Controller.LOG) {
                Controller.log("FILEMAP STORAGE flush(): " + this.outstandingBufferCount);
            }
            this.write(this.buffer);
            this.fileChannel.force(false);
            this.buffer = null;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.fileChannel != null) {
            this.flush();
        }
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.fileChannel == null || this.closed;
    }

    private static synchronized void addUndisposed(FileMapStorage fileMapStorage) {
        undisposed.add(fileMapStorage);
    }

    private static synchronized void removeUndisposed(FileMapStorage fileMapStorage) {
        undisposed.remove(fileMapStorage);
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                for (FileMapStorage fileMapStorage : undisposed) {
                    if (fileMapStorage.contents != null) {
                        fileMapStorage.contents.releaseBuffer();
                    }
                    if (fileMapStorage.fileChannel != null && fileMapStorage.fileChannel.isOpen()) {
                        try {
                            fileMapStorage.fileChannel.close();
                        }
                        catch (IOException iOException) {
                            Exceptions.printStackTrace((Throwable)iOException);
                        }
                    }
                    if (fileMapStorage.outfile == null) continue;
                    fileMapStorage.outfile.delete();
                }
            }
        });
    }

    private class MappedBufferResource
    implements BufferResource<ByteBuffer> {
        private int refs = 0;
        private ByteBuffer buffer;

        public MappedBufferResource(ByteBuffer byteBuffer) {
            this.buffer = byteBuffer;
        }

        @Override
        public void releaseBuffer() {
            if (this.buffer != null) {
                FileMapStorage.unmap(this.buffer);
                this.buffer = null;
            }
        }

        @Override
        public ByteBuffer getBuffer() {
            return this.buffer;
        }

        synchronized void incRefs() {
            ++this.refs;
        }

        synchronized void decRefs() {
            --this.refs;
            assert (this.refs >= 0);
            if (this.refs == 0) {
                FileMapStorage.unmap(this.buffer);
                this.buffer = null;
            }
        }
    }

    private class ChildBufferResource
    implements BufferResource<ByteBuffer> {
        private ByteBuffer buffer;
        private MappedBufferResource parentResource;

        public ChildBufferResource(ByteBuffer byteBuffer, MappedBufferResource mappedBufferResource) {
            this.buffer = byteBuffer;
            this.parentResource = mappedBufferResource;
            this.parentResource.incRefs();
        }

        @Override
        public ByteBuffer getBuffer() {
            return this.buffer;
        }

        @Override
        public void releaseBuffer() {
            this.buffer = null;
            this.parentResource.decRefs();
        }
    }
}

