/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.OutputDocument;
import org.netbeans.core.output2.OutputEditorKit;
import org.netbeans.core.output2.OutputTab;
import org.netbeans.core.output2.ui.AbstractOutputPane;
import org.openide.util.NbPreferences;

class OutputPane
extends AbstractOutputPane {
    OutputTab parent;

    public OutputPane(OutputTab outputTab) {
        this.parent = outputTab;
    }

    @Override
    protected void documentChanged() {
        super.documentChanged();
        this.findOutputTab().documentChanged(this);
    }

    @Override
    protected void caretPosChanged(int n) {
        this.findOutputTab().caretPosChanged(n);
    }

    @Override
    protected void lineClicked(int n, int n2) {
        if (this.getDocument() instanceof OutputDocument) {
            this.findOutputTab().lineClicked(n, n2);
        }
    }

    @Override
    protected void postPopupMenu(Point point, Component component) {
        if (component.isShowing()) {
            this.findOutputTab().postPopupMenu(point, component);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        Document document = this.getDocument();
        if (document instanceof OutputDocument && ((OutputDocument)document).getLines().hasListeners()) {
            super.mouseMoved(mouseEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        if (!mouseEvent.isPopupTrigger()) {
            this.findOutputTab().setToFocus((Component)mouseEvent.getSource());
            this.findOutputTab().requestActive();
        }
    }

    private OutputTab findOutputTab() {
        return this.parent;
    }

    @Override
    protected void setDocument(Document document) {
        if (document == null) {
            Document document2 = this.getDocument();
            if (document2 != null) {
                document2.removeDocumentListener(this);
            }
            this.textView.setDocument(new PlainDocument());
            return;
        }
        this.textView.setEditorKit(new OutputEditorKit(this.isWrapped(), this.textView));
        super.setDocument(document);
        this.updateKeyBindings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setWrapped(boolean bl) {
        if (bl != this.isWrapped() || !(this.getEditorKit() instanceof OutputEditorKit)) {
            NbPreferences.forModule(OutputPane.class).putBoolean("wrap", bl);
            this.textView.setFont(bl ? Controller.getDefault().getCurrentFontMS() : Controller.getDefault().getCurrentFont());
            final int n = this.textView.getCaret().getDot();
            Cursor cursor = this.textView.getCursor();
            try {
                this.textView.setCursor(Cursor.getPredefinedCursor(3));
                this.setEditorKit(new OutputEditorKit(bl, this.textView));
            }
            finally {
                this.textView.setCursor(cursor);
            }
            SwingUtilities.invokeLater(new Runnable(){
                private boolean first = true;

                @Override
                public void run() {
                    if (this.first) {
                        this.first = false;
                        SwingUtilities.invokeLater(this);
                        return;
                    }
                    OutputPane.this.textView.getCaret().setDot(n);
                }
            });
            if (this.getDocument() instanceof OutputDocument && ((OutputDocument)this.getDocument()).getLines().isGrowing()) {
                this.lockScroll();
            }
            if (!bl) {
                this.getHorizontalScrollBar().setValue(this.getHorizontalScrollBar().getModel().getMinimum());
            }
            this.validate();
        }
    }

    @Override
    public boolean isWrapped() {
        if (this.getEditorKit() instanceof OutputEditorKit) {
            return this.getEditorKit() instanceof OutputEditorKit && ((OutputEditorKit)this.getEditorKit()).isWrapped();
        }
        return NbPreferences.forModule(OutputPane.class).getBoolean("wrap", false);
    }

    @Override
    protected JEditorPane createTextView() {
        JEditorPane jEditorPane = new JEditorPane();
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            jEditorPane.setBackground(UIManager.getColor("NbExplorerView.background"));
        } else if ("GTK".equals(UIManager.getLookAndFeel().getID())) {
            jEditorPane.setBackground(UIManager.getColor("text"));
        }
        jEditorPane.setDisabledTextColor(jEditorPane.getBackground());
        InputMap inputMap = jEditorPane.getInputMap();
        MyInputMap myInputMap = new MyInputMap();
        myInputMap.setParent(inputMap);
        jEditorPane.setInputMap(0, myInputMap);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutputDocument outputDocument = (OutputDocument)((JEditorPane)actionEvent.getSource()).getDocument();
                OutputPane.this.findOutputTab().inputSent(outputDocument.sendLine());
            }
        };
        jEditorPane.getActionMap().put("SENDLINE", abstractAction);
        abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutputDocument outputDocument = (OutputDocument)((JEditorPane)actionEvent.getSource()).getDocument();
                OutputPane.this.findOutputTab().inputSent(outputDocument.sendLine());
                OutputPane.this.findOutputTab().inputEof();
            }
        };
        jEditorPane.getActionMap().put("EOF", abstractAction);
        return jEditorPane;
    }

    @Override
    protected void changeFontSizeBy(int n) {
        Controller.getDefault().changeFontSizeBy(n, this.isWrapped());
    }

    protected class MyInputMap
    extends InputMap {
        @Override
        public Object get(KeyStroke keyStroke) {
            KeyStroke keyStroke2 = KeyStroke.getKeyStroke("control shift O");
            if (keyStroke.equals(keyStroke2)) {
                return null;
            }
            keyStroke2 = KeyStroke.getKeyStroke(8, 2);
            if (keyStroke.equals(keyStroke2)) {
                return null;
            }
            keyStroke2 = KeyStroke.getKeyStroke(10, 0);
            if (keyStroke.equals(keyStroke2) && OutputPane.this.findOutputTab().isInputVisible()) {
                return "SENDLINE";
            }
            keyStroke2 = KeyStroke.getKeyStroke(68, 2);
            if (keyStroke.equals(keyStroke2)) {
                return "EOF";
            }
            Object object = super.get(keyStroke);
            return object;
        }
    }
}

