/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.base;

import com.jrockit.mc.components.ui.base.AbstractUIComponent;
import com.jrockit.mc.core.StatusFactory;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.accessibility.SimpleTraverseListener;
import com.jrockit.mc.ui.handlers.FieldViewerContributionFactory;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.misc.MCLayoutFactory;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.site.AbstractSiteActivator;
import com.jrockit.mc.ui.site.HandlerActivator;
import com.jrockit.mc.ui.site.MenuFactoryActivator;
import com.jrockit.mc.ui.site.SiteFocusListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.menus.AbstractContributionFactory;

public abstract class AbstractViewerComponent
extends AbstractUIComponent {
    private StructuredViewer m_viewer;
    private Field[] m_fields;

    public abstract Field[] createFields();

    protected final void setupFieldMenu() {
        this.registerFieldFactoryContributions();
    }

    protected final StructuredViewer getViewer() {
        return this.m_viewer;
    }

    protected final void setViewer(StructuredViewer viewer) {
        this.m_viewer = viewer;
    }

    @Override
    public final Control createPart(Composite parent) {
        this.m_fields = this.createFields();
        return this.createViewerPart(parent, this.m_fields);
    }

    protected final Field[] getFields() {
        return this.m_fields;
    }

    protected Control createViewerPart(Composite parent, Field[] m_fields2) {
        Composite container = this.getFormToolkit().createComposite(parent, 0);
        container.addTraverseListener((TraverseListener)new SimpleTraverseListener());
        int colspan = 1;
        Composite topControl = this.createTopControl(container);
        Composite leftControl = this.createLeftControl(container);
        this.setViewer(this.createViewer(container));
        Composite rightControl = this.createRightControl(container);
        Composite bottomControl = this.createBottomControl(container);
        if (leftControl != null) {
            leftControl.setLayoutData(MCLayoutFactory.createFormPageLayoutData((int)-1, (int)-1, (boolean)false, (boolean)true));
            ++colspan;
        }
        if (rightControl != null) {
            rightControl.setLayoutData(MCLayoutFactory.createFormPageLayoutData((int)-1, (int)-1, (boolean)false, (boolean)false));
            ++colspan;
        }
        if (this.m_viewer != null) {
            this.m_viewer.getControl().setLayoutData(MCLayoutFactory.createFormPageLayoutData());
            ++colspan;
            this.setupViewer();
        }
        if (topControl != null) {
            topControl.setLayoutData(MCLayoutFactory.createFormPageLayoutData((int)-1, (int)-1, (int)colspan, (int)1, (boolean)true, (boolean)false));
        }
        if (bottomControl != null) {
            bottomControl.setLayoutData(MCLayoutFactory.createFormPageLayoutData((int)-1, (int)-1, (int)colspan, (int)1, (boolean)true, (boolean)false));
        }
        container.setLayout(MCLayoutFactory.createPaintBordersMarginFreeFormPageLayout((int)colspan));
        return container;
    }

    protected void setupViewer() {
        this.setupFieldMenu();
        this.setupFocousListeners();
        this.setupSelectionProvider();
        this.setupContextMenu();
        this.setupSelectionListeners();
    }

    protected void setupSelectionListeners() {
    }

    protected void setupContextMenu() {
        MenuManager menuManager = this.getMenuManager();
        if (menuManager != null) {
            Control control = this.getViewer().getControl();
            control.setMenu(menuManager.createContextMenu(control));
            this.getSite().registerContextMenu(menuManager, this.getSelectionProvider());
        }
    }

    protected ISelectionProvider getSelectionProvider() {
        return this.getViewer();
    }

    protected void setupFocousListeners() {
        this.getViewer().getControl().addFocusListener((FocusListener)new SiteFocusListener(this.getSite()));
    }

    protected Composite createBottomControl(Composite container) {
        return null;
    }

    protected Composite createRightControl(Composite container) {
        return null;
    }

    protected Composite createLeftControl(Composite container) {
        return null;
    }

    protected Composite createTopControl(Composite container) {
        return null;
    }

    protected abstract StructuredViewer createViewer(Composite var1);

    protected final void hookModelView(final ContentViewer viewer, final Observable observable) {
        observable.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                AbstractViewerComponent.this.safeViewerRefresh(viewer, observable);
            }
        });
    }

    protected final IStatus createOKStatus() {
        return StatusFactory.createOk((String)"Viewer Component Ok");
    }

    private void updateStatus(Object observable) {
        IMessageManager p = (IMessageManager)this.getServiceLocator().getService("messageManager");
        if (p != null) {
            IStatus s = this.getModelStatus(observable);
            if (s.getSeverity() == 0) {
                p.removeMessage((Object)this.getComponentDescriptor());
            }
            if (s.getSeverity() == 4) {
                p.addMessage((Object)this.getComponentDescriptor(), s.getMessage(), null, 3);
            }
            if (s.getSeverity() == 1) {
                p.addMessage((Object)this.getComponentDescriptor(), s.getMessage(), null, 1);
            }
            if (s.getSeverity() == 2) {
                p.addMessage((Object)this.getComponentDescriptor(), s.getMessage(), null, 2);
            }
        }
    }

    protected IStatus getModelStatus(Object model) {
        return this.createOKStatus();
    }

    protected final void safeViewerRefresh(final ContentViewer viewer, final Object object) {
        DisplayToolkit.safeAsyncExec((Widget)viewer.getControl(), (Runnable)new Runnable(){

            @Override
            public void run() {
                AbstractViewerComponent.this.updateStatus(object);
                AbstractViewerComponent.this.refreshViewer(viewer);
            }
        });
    }

    protected void refreshUI() {
        this.refreshViewer((ContentViewer)this.getViewer());
    }

    protected void refreshViewer(ContentViewer viewer) {
        viewer.refresh();
    }

    protected void registerFieldFactoryContributions() {
        FieldViewerContributionFactory fvcf = new FieldViewerContributionFactory(this.getFields(), this.getWorkbenhPartSite(), this.getIdentifier());
        Collection commands = fvcf.createCommands();
        Collection handlers = fvcf.createHandlers();
        if (commands.size() == handlers.size()) {
            this.registerActivators(fvcf, commands, handlers);
        } else {
            UIPlugin.getDefault().getLogger().severe("The number of handlers dosen't match the number of commands. The context menu will not be complete for" + this.getIdentifier());
        }
    }

    private void registerActivators(FieldViewerContributionFactory fvcf, Collection<Command> commands, Collection<IHandler> handlers) {
        Iterator<Command> itC = commands.iterator();
        Iterator<IHandler> itH = handlers.iterator();
        while (itH.hasNext() && itC.hasNext()) {
            Command command = itC.next();
            IHandler handler = itH.next();
            if (command == null || handler == null) continue;
            this.getSite().registerActivator((AbstractSiteActivator)new HandlerActivator(command.getId(), handler));
        }
        this.getSite().registerActivator((AbstractSiteActivator)new MenuFactoryActivator((AbstractContributionFactory)fvcf));
    }

    protected void setupSelectionProvider() {
        this.getSite().setSelectionProvider((ISelectionProvider)this.getViewer());
    }
}

