/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.components;

import com.jrockit.mc.components.ui.behaviors.IComponentDecoration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;

public final class UIScope {
    private final Vector<? super Object> m_components = new Vector();
    private final Vector<UIScope> m_uiScopes = new Vector();
    private final UIScope m_parent;

    public UIScope(UIScope parent) {
        this.m_parent = parent;
        if (parent != null) {
            this.m_parent.addChildScope(this);
        }
    }

    void addChildScope(UIScope scope) {
        this.m_uiScopes.add(scope);
    }

    public void removeChildScope(UIScope scope) {
        this.m_uiScopes.remove(scope);
    }

    public UIScope getParentScope() {
        return this.m_parent;
    }

    public UIScope getTopScope() {
        if (this.m_parent != null) {
            return this.m_parent.getTopScope();
        }
        return this;
    }

    public List<? super Object> getComponents() {
        return this.m_components;
    }

    public void addComponent(Object component) {
        this.m_components.add(component);
    }

    public void removeComponent(Object component) {
        this.m_components.remove(component);
    }

    void clear() {
        this.m_components.clear();
    }

    public <T> List<T> getCompatibles(Class<T> clazz) {
        Object[] candidates;
        ArrayList<Object> compatibles = new ArrayList<Object>();
        Object[] objectArray = candidates = this.m_components.toArray(new Object[this.m_components.size()]);
        int n = candidates.length;
        int n2 = 0;
        while (n2 < n) {
            Object candidate = objectArray[n2];
            if (clazz.isInstance(candidate)) {
                compatibles.add(candidate);
            }
            ++n2;
        }
        return compatibles;
    }

    public <T> List<T> getCompatiblesWithChildren(Class<T> clazz) {
        UIScope[] componentsContainers;
        List<T> compatibles = this.getCompatibles(clazz);
        UIScope[] uIScopeArray = componentsContainers = this.m_uiScopes.toArray(new UIScope[this.m_uiScopes.size()]);
        int n = componentsContainers.length;
        int n2 = 0;
        while (n2 < n) {
            UIScope componentsContainer = uIScopeArray[n2];
            compatibles.addAll(componentsContainer.getCompatiblesWithChildren(clazz));
            ++n2;
        }
        return compatibles;
    }

    public <T> List<T> getComponentsInAncestorScopes(Class<T> clazz) {
        List<T> compatibles = this.getCompatibles(clazz);
        UIScope parent = this.getParentScope();
        if (parent != null) {
            compatibles.addAll(parent.getComponentsInAncestorScopes(clazz));
        }
        return compatibles;
    }

    public static void print(String indent, UIScope scope) {
        System.out.println(String.valueOf(indent) + "|- Scope (" + scope + ")");
        for (UIScope uIScope : scope.m_uiScopes) {
            UIScope.print(String.valueOf(indent) + ' ', uIScope);
        }
        for (Object object : scope.m_components) {
            if (object instanceof IComponentDecoration) {
                System.out.println(String.valueOf(indent) + " |-Component (" + ((IComponentDecoration)object).getTitle() + ')');
                continue;
            }
            System.out.println(String.valueOf(indent) + " |-Component (" + object + ')');
        }
    }

    public <T> List<T> getAllComponents(Class<T> clazz) {
        ArrayList<T> components = new ArrayList<T>();
        components.addAll(this.getCompatibles(clazz));
        for (UIScope childScope : this.m_uiScopes) {
            components.addAll(childScope.getAllComponents(clazz));
        }
        return components;
    }

    public <T> Collection<T> getInAncestorAndChildrenScopes(Class<T> clazz) {
        HashSet<T> components = new HashSet<T>();
        components.addAll(this.getComponentsInAncestorScopes(clazz));
        components.addAll(this.getAllComponents(clazz));
        return components;
    }
}

