/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design;

import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.components.ui.ComponentsPlugin;
import com.jrockit.mc.components.ui.behaviors.IShowable;
import com.jrockit.mc.components.ui.components.UIScope;
import com.jrockit.mc.components.ui.contributions.PathPlacementComparator;
import com.jrockit.mc.components.ui.contributions.SettingsFileToolkit;
import com.jrockit.mc.components.ui.contributions.UserInterfaceContribution;
import com.jrockit.mc.components.ui.design.DesignModel;
import com.jrockit.mc.components.ui.design.DesignerTab;
import com.jrockit.mc.components.ui.messages.internal.Messages;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.components.ui.services.IServiceLocatorProvider;
import com.jrockit.mc.components.ui.services.ServiceLocator;
import com.jrockit.mc.components.ui.tab.BaseDescriptor;
import com.jrockit.mc.components.ui.tab.ImageConverter;
import com.jrockit.mc.components.ui.tab.TabDescriptorRepository;
import com.jrockit.mc.components.ui.tab.TabGroupDescriptor;
import com.jrockit.mc.components.ui.tab.TabItemDescriptor;
import com.jrockit.mc.components.ui.util.ImageDescriptor;
import com.jrockit.mc.ui.MCPathEditorInput;
import com.jrockit.mc.ui.MCPathFactory;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.formpage.FormPageContribution;
import com.jrockit.mc.ui.formpage.FormPageContributionFactory;
import com.jrockit.mc.ui.formpage.FormPageContributionGroup;
import com.jrockit.mc.ui.formpage.FormPageContributionItem;
import com.jrockit.mc.ui.formpage.internal.FormPageContributionToolkit;
import com.jrockit.mc.ui.formpage.internal.ToolbarFormEditor;
import com.jrockit.mc.ui.misc.DialogToolkit;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.misc.ErrorDialog;
import com.jrockit.mc.ui.misc.IInputChangedListener;
import com.jrockit.mc.ui.misc.IMCInputProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public abstract class DesignEditor
extends ToolbarFormEditor
implements IMCInputProvider,
IServiceLocatorProvider {
    private IServiceLocator m_serviceLocator;
    private List<FormPageContributionGroup> m_contributionGroups;
    private final ListenerList m_inputListener = new ListenerList();
    private IAdaptable m_page = null;
    private Job initializeJob;

    public void doSaveAs() {
    }

    public final void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, DesignEditor.getValidEditorInput(input));
        this.initializeEditor(site, input);
        this.m_serviceLocator = new ServiceLocator(null);
        this.m_serviceLocator.registerService(new DesignModel());
        this.m_serviceLocator.registerService("workbenchWindow", this.getSite().getWorkbenchWindow());
        this.m_serviceLocator.registerService("workbenchPartSite", this.getSite());
        this.initializeJob = this.initialize(this.m_serviceLocator);
        this.m_serviceLocator.registerService(this.getContainerCopy(this.getEditorSite()));
        this.initializeDefaultServices(this.m_serviceLocator);
    }

    private void initializeDefaultServices(IServiceLocator serviceLocator) {
        FormToolkit toolkit = this.createFormToolkit();
        UserInterfaceContribution container = serviceLocator.getService(UserInterfaceContribution.class);
        serviceLocator.registerService(container.getUserInterface());
        serviceLocator.registerService(new UIScope(null));
        serviceLocator.registerService(toolkit);
    }

    protected FormToolkit createFormToolkit() {
        return new FormToolkit(ComponentsPlugin.getDefault().getFormColors(this.getSite().getShell().getDisplay()));
    }

    private static IEditorInput getValidEditorInput(IEditorInput input) {
        MCPathEditorInput pathEditorInput;
        if (!(input instanceof MCPathEditorInput) && (pathEditorInput = MCPathFactory.createMCPathEditorInput((IEditorInput)input, (boolean)false)) != null) {
            return pathEditorInput;
        }
        return input;
    }

    protected void initializeEditor(IEditorSite site, IEditorInput input) throws PartInitException {
    }

    public boolean isLoadDone() {
        return this.initializeJob == null;
    }

    protected Composite createPageContainer(Composite parent) {
        if (this.isLoadDone()) {
            return super.createPageContainer(parent);
        }
        final Composite stackContainer = new Composite(parent, 0);
        stackContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        final StackLayout stackLayout = new StackLayout();
        stackContainer.setLayout((Layout)stackLayout);
        final Composite mainUiParent = new Composite(stackContainer, 0);
        Composite tabContainer = super.createPageContainer(mainUiParent);
        final Composite loadingUi = DesignEditor.createLoadingUi(this.getToolkit(), stackContainer);
        stackLayout.topControl = loadingUi;
        this.initializeJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                final boolean result = event.getResult().isOK();
                DisplayToolkit.safeAsyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!stackContainer.isDisposed()) {
                            if (result) {
                                try {
                                    DesignEditor.this.doInitializeFormPageContributions();
                                    stackLayout.topControl = mainUiParent;
                                    stackContainer.layout(true, true);
                                    loadingUi.dispose();
                                    DesignEditor.this.setFocus();
                                }
                                catch (Exception e) {
                                    DialogToolkit.showException((Shell)DesignEditor.this.getSite().getShell(), (String)Messages.DESIGN_EDITOR_FAILED_TO_LOAD_CONTENT, (Throwable)e);
                                }
                            } else {
                                DesignEditor.this.getSite().getPage().closeEditor((IEditorPart)DesignEditor.this, false);
                            }
                        }
                        DesignEditor.this.initializeJob = null;
                    }
                });
            }
        });
        this.initializeJob.schedule();
        return tabContainer;
    }

    protected void initializeFormPageContributions() {
        if (this.isLoadDone()) {
            this.doInitializeFormPageContributions();
        }
    }

    private void doInitializeFormPageContributions() {
        this.initializeTabs(this.m_serviceLocator);
        for (FormPageContributionItem item : this.getFlattenedContributions()) {
            try {
                this.addFormPageContributionItem(item, this.getEditorInput());
            }
            catch (PartInitException e) {
                ComponentsPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not initialize FormPageContribution item.", e);
            }
        }
        this.getSelectorPart().init(this.m_contributionGroups);
        this.show(this.getSelectorPart().getActive(), true);
    }

    private Object getContainerCopy(IEditorSite site) throws PartInitException {
        UserInterfaceContribution container;
        try {
            container = ComponentsPlugin.getDefault().getUserInterfaceRepository().findContribution(this.getSite().getId());
        }
        catch (IOException e) {
            throw new PartInitException("Error loading settings file for editor " + site.getId());
        }
        return PersistenceToolkit.createWorkingCopy((Object)container);
    }

    protected final void initializeTabs(IServiceLocator serviceLocator) {
        UserInterfaceContribution container = serviceLocator.getService(UserInterfaceContribution.class);
        TabDescriptorRepository tr = container.getUserInterface().getTabRepository();
        this.m_contributionGroups = this.createContributions(serviceLocator, (Device)this.getSite().getWorkbenchWindow().getShell().getDisplay(), tr.getGroups());
        if (this.m_contributionGroups.isEmpty()) {
            TabGroupDescriptor defaultTabGroupDescriptor = new TabGroupDescriptor();
            tr.getGroups().add(defaultTabGroupDescriptor);
            TabItemDescriptor tabItemDescriptor = new TabItemDescriptor();
            defaultTabGroupDescriptor.getTabs().add(tabItemDescriptor);
            this.m_contributionGroups = this.createContributions(serviceLocator, (Device)this.getSite().getWorkbenchWindow().getShell().getDisplay(), tr.getGroups());
        }
        FormPageContributionToolkit.initializeContributionsWithEditor(this.m_contributionGroups, (FormEditor)this);
        this.addShowHideListener((FormEditor)this);
    }

    protected void addShowHideListener(FormEditor editor) {
        editor.addPageChangedListener(new IPageChangedListener(){

            public void pageChanged(PageChangedEvent event) {
                if (event.getSelectedPage() != DesignEditor.this.m_page) {
                    UIScope comp;
                    IServiceLocator sl;
                    if (DesignEditor.this.m_page != null && (sl = (IServiceLocator)DesignEditor.this.m_page.getAdapter(IServiceLocator.class)) != null) {
                        comp = sl.getService(UIScope.class);
                        for (IShowable s : comp.getAllComponents(IShowable.class)) {
                            s.hide();
                        }
                    }
                    DesignEditor.this.m_page = (IAdaptable)event.getSelectedPage();
                    sl = (IServiceLocator)DesignEditor.this.m_page.getAdapter(IServiceLocator.class);
                    if (sl != null) {
                        comp = sl.getService(UIScope.class);
                        for (IShowable s : comp.getAllComponents(IShowable.class)) {
                            s.show();
                        }
                    }
                }
            }
        });
    }

    protected abstract Job initialize(IServiceLocator var1) throws PartInitException;

    public boolean isSaveAsAllowed() {
        return false;
    }

    public int promptToSaveOnClose() {
        return 3;
    }

    private List<FormPageContributionGroup> createContributions(IServiceLocator serviceLocator, Device device, List<TabGroupDescriptor> groups) {
        ArrayList<FormPageContributionGroup> contributions = new ArrayList<FormPageContributionGroup>();
        ArrayList<TabGroupDescriptor> orderedGroups = new ArrayList<TabGroupDescriptor>(groups);
        Collections.sort(orderedGroups, new PathPlacementComparator());
        for (TabGroupDescriptor group : orderedGroups) {
            FormPageContributionGroup fGroup = new FormPageContributionGroup(group.getIdentifier());
            fGroup.setLabel(group.getName());
            fGroup.setPlacementPath(group.getPlacementPath());
            fGroup.setTooltip(group.getDescription());
            fGroup.setIcon(this.getIcon(device, group, group.getIcon(), false), true);
            fGroup.setLargeIcon(this.getIcon(device, group, group.getLargeIcon(), true), true);
            fGroup.setVisible(Boolean.valueOf(true));
            contributions.add(fGroup);
            ArrayList<TabItemDescriptor> orderedTabs = new ArrayList<TabItemDescriptor>(group.getTabs());
            Collections.sort(orderedTabs, new PathPlacementComparator());
            for (TabItemDescriptor tab : orderedTabs) {
                FormPageContributionGroup grp = (FormPageContributionGroup)FormPageContributionToolkit.findWithId(contributions, (String)tab.getIdentifier(), FormPageContributionGroup.class);
                contributions.remove(grp);
                int delayTime = this.calculateDelayTime(orderedGroups, group, orderedTabs, tab);
                DesignerTab dt = new DesignerTab((FormEditor)this, tab, delayTime);
                FormPageContributionItem item = new FormPageContributionItem(tab.getIdentifier(), (IFormPage)dt);
                item.setLabel(tab.getName());
                item.setPlacementPath(tab.getPlacementPath());
                item.setTooltip(tab.getDescription());
                item.setIcon(this.getIcon(device, tab, tab.getIcon(), false), true);
                item.setVisible(Boolean.valueOf(true));
                fGroup.add((FormPageContribution)item);
            }
        }
        FormPageContributionFactory factory = new FormPageContributionFactory((Object)serviceLocator, this.getSite().getId());
        factory.addFormPageContributionsTo(contributions);
        FormPageContributionToolkit.sortRecursively(contributions);
        return FormPageContributionToolkit.transformToTwoLevels(contributions);
    }

    private int calculateDelayTime(ArrayList<TabGroupDescriptor> groups, TabGroupDescriptor currentGroup, ArrayList<TabItemDescriptor> tabs, TabItemDescriptor currentTab) {
        if (DesignEditor.backgroundLoadingEnabled()) {
            TabGroupDescriptor firstGroup = DesignEditor.getFirstInList(groups);
            TabItemDescriptor firstTab = DesignEditor.getFirstInList(tabs);
            if (firstTab == currentTab) {
                return firstGroup == currentGroup ? 0 : 50;
            }
            return 800;
        }
        return 0;
    }

    private static boolean backgroundLoadingEnabled() {
        return UIPlugin.getDefault().getPreferenceStore().getBoolean("threaded.rendering");
    }

    private static <T> T getFirstInList(List<T> list) {
        return list.size() > 0 ? (T)list.get(0) : null;
    }

    private Image getIcon(Device device, BaseDescriptor descriptor, ImageDescriptor iconData, boolean largeDefault) {
        Image image = ImageConverter.createImage(device, iconData);
        if (image == null) {
            image = largeDefault ? descriptor.createDefaultLargeIcon(device) : descriptor.createDefaultIcon(device);
        }
        return image;
    }

    private List<FormPageContributionItem> getFlattenedContributions() {
        return FormPageContributionToolkit.flatten(this.m_contributionGroups, FormPageContributionItem.class, (int)Integer.MAX_VALUE, (boolean)true);
    }

    public Object getAdapter(Class adapter) {
        IEditorPart part;
        if (IMessageManager.class.isAssignableFrom(adapter) && (part = this.getActiveEditor()) != null) {
            return part.getAdapter(adapter);
        }
        if (adapter == IPropertySheetPage.class) {
            return this.createWorkBenchPropertySheets();
        }
        part = this.getActiveEditor();
        if (part != null) {
            return part.getAdapter(adapter);
        }
        return null;
    }

    public Object getInput() {
        return this.m_serviceLocator;
    }

    @Override
    public IServiceLocator getServiceLocator() {
        return this.m_serviceLocator;
    }

    public void addInputChangedListener(IInputChangedListener listener) {
        this.m_inputListener.add((Object)listener);
    }

    public void removeInputChangedListener(IInputChangedListener listener) {
        this.m_inputListener.remove((Object)listener);
    }

    public void dispose() {
        UserInterfaceContribution contribution = this.m_serviceLocator.getService(UserInterfaceContribution.class);
        PersistenceToolkit.commit((Object)contribution);
        try {
            SettingsFileToolkit.persistContribution(contribution);
        }
        catch (IOException e) {
            ErrorDialog.showException((Shell)this.getSite().getShell(), (String)"Error saving user settings", (Throwable)e);
        }
        if (this.m_serviceLocator != null) {
            this.m_serviceLocator.dispose();
        }
        if (this.initializeJob != null) {
            this.initializeJob.cancel();
        }
        super.dispose();
    }

    private static Composite createLoadingUi(FormToolkit toolkit, Composite parent) {
        Composite loadingUi = toolkit.createComposite(parent, 0);
        loadingUi.setLayout((Layout)new GridLayout());
        Composite centerComposite = toolkit.createComposite(loadingUi, 0);
        centerComposite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        centerComposite.setLayout((Layout)new GridLayout());
        ProgressIndicator progressIndicator = new ProgressIndicator(centerComposite);
        progressIndicator.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        toolkit.adapt((Composite)progressIndicator);
        progressIndicator.beginAnimatedTask();
        Label label = toolkit.createLabel(centerComposite, Messages.DESIGN_EDITOR_PLEASE_WAIT);
        label.setLayoutData((Object)new GridData(16384, 128, false, false));
        return loadingUi;
    }
}

