/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.actions;

import com.jrockit.mc.components.ui.design.DesignModel;
import com.jrockit.mc.components.ui.design.DesignerTab;
import com.jrockit.mc.components.ui.design.view.layout.LayoutPage;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.ui.UIPlugin;
import org.eclipse.jface.action.Action;

public final class DesignModeAction
extends Action {
    private final LayoutPage m_layoutPage;
    private DesignerTab m_tab;

    public DesignModeAction(IServiceLocator serviceLocator, LayoutPage layoutPage) {
        super("Design Mode On/Off", 8);
        this.setToolTipText("Switch designer mode on and off");
        this.updateImage();
        this.m_layoutPage = layoutPage;
    }

    public void run() {
        if (this.m_tab != null) {
            this.m_tab.getDesignModel().setDesignerMode(!this.m_tab.getDesignModel().isDesignerModeOn());
            this.updateImage();
            this.m_layoutPage.update();
            this.m_tab.getDesignModel().notifyObservers();
        }
    }

    void updateImage() {
        if (this.m_tab != null) {
            DesignModel model = this.m_tab.getDesignModel();
            if (model != null) {
                this.updateImageDesignModeOn(model);
            }
        } else {
            this.updateImageDesignModeOff();
        }
    }

    private void updateImageDesignModeOff() {
        this.setEnabled(false);
        this.setImageDescriptor(UIPlugin.getDefault().getMCImageDescriptor("stop.gif"));
    }

    private void updateImageDesignModeOn(DesignModel model) {
        this.setEnabled(true);
        if (model.isDesignerModeOn()) {
            this.setImageDescriptor(UIPlugin.getDefault().getMCImageDescriptor("play.gif"));
        } else {
            this.setImageDescriptor(UIPlugin.getDefault().getMCImageDescriptor("stop.gif"));
        }
    }

    public void setTab(DesignerTab tab) {
        this.m_tab = tab;
        this.updateImage();
    }
}

