/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.view;

import com.jrockit.mc.components.ui.design.DesignEditor;
import com.jrockit.mc.components.ui.design.DesignerTab;
import com.jrockit.mc.components.ui.design.view.layout.LayoutPage;
import com.jrockit.mc.components.ui.design.view.toolbar.TabPage;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.core.AdapterUtil;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;

public final class DesignView
extends PageBookView
implements IPageChangedListener {
    private TabPage m_tabPage;
    private IPageChangeProvider m_lastEditor;
    private Object m_lastPage;

    public void partActivated(IWorkbenchPart part) {
        if (this.isImportant(part)) {
            IPageChangeProvider pageChanger = (IPageChangeProvider)AdapterUtil.getAdapter((Object)part, IPageChangeProvider.class);
            if (this.m_lastEditor != null) {
                this.m_lastEditor.removePageChangedListener((IPageChangedListener)this);
                this.m_lastEditor = null;
                this.m_lastPage = null;
            }
            this.m_lastEditor = pageChanger;
            this.m_lastEditor.addPageChangedListener((IPageChangedListener)this);
            super.partActivated(part);
            this.pageChanged(part, pageChanger.getSelectedPage());
        }
    }

    protected IPage createDefaultPage(PageBook book) {
        this.m_tabPage = new TabPage();
        this.initPage((IPageBookViewPage)this.m_tabPage);
        this.m_tabPage.createControl((Composite)book);
        return this.m_tabPage;
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        if (part instanceof DesignEditor) {
            DesignEditor editor = (DesignEditor)part;
            IServiceLocator s = editor.getServiceLocator();
            LayoutPage p = new LayoutPage(s);
            this.initPage((IPageBookViewPage)p);
            p.createControl((Composite)this.getPageBook());
            return new PageBookView.PageRec(part, (IPage)p);
        }
        return null;
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        if (part instanceof DesignEditor) {
            pageRecord.page.dispose();
            pageRecord.dispose();
            if (this.m_tabPage != null) {
                this.m_tabPage.refresh();
            }
        }
    }

    protected IWorkbenchPart getBootstrapPart() {
        IEditorPart part = this.getSite().getWorkbenchWindow().getActivePage().getActiveEditor();
        if (this.isImportant((IWorkbenchPart)part)) {
            return part;
        }
        return null;
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof DesignEditor;
    }

    public void pageChanged(PageChangedEvent event) {
        this.pageChanged((IWorkbenchPart)this.m_lastEditor, event.getSelectedPage());
    }

    private void pageChanged(IWorkbenchPart part, Object page) {
        DesignerTab tab = null;
        if (page != this.m_lastPage) {
            this.m_lastPage = page;
            PageBookView.PageRec rec = this.getPageRec(part);
            if (rec != null && rec.page instanceof LayoutPage) {
                IEditorPart editorPart;
                if (part instanceof DesignEditor && (editorPart = ((DesignEditor)part).getActiveEditor()) instanceof DesignerTab) {
                    tab = (DesignerTab)editorPart;
                }
                ((LayoutPage)rec.page).setTab(tab);
                ((LayoutPage)rec.page).update();
            }
        }
    }
}

