/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.view.toolbar;

import com.jrockit.mc.components.ui.contributions.BundleVersion;
import com.jrockit.mc.components.ui.contributions.ContributionDescriptor;
import com.jrockit.mc.components.ui.messages.internal.Messages;
import com.jrockit.mc.ui.wizards.IPerformFinishable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PluginPropertiesPage
extends WizardPage
implements IPerformFinishable {
    private final ContributionDescriptor m_containerExtension;
    private Text m_pluginIdentifier;
    private Text m_version;
    private Text m_name;

    protected PluginPropertiesPage(ContributionDescriptor ce) {
        super("pluginPropertiesPage");
        this.m_containerExtension = ce;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        container.setLayout((Layout)layout);
        this.createPluginId(container);
        this.createBundleName(container);
        this.createPluginVersion(container);
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
    }

    private void createBundleName(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false);
        Label l = new Label(parent, 0);
        l.setText(Messages.PLUGIN_PROPERTIES_PAGE_BUNDLE_NAME_LABEL);
        l.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false);
        this.m_name = new Text(parent, 2048);
        this.m_name.setText(this.m_containerExtension.getName());
        this.m_name.setLayoutData((Object)gd2);
    }

    private void createPluginVersion(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false);
        Label l = new Label(parent, 0);
        l.setText(Messages.PLUGIN_PROPERTIES_PAGE_VERSION_LABEL);
        l.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false);
        this.m_version = new Text(parent, 2048);
        this.m_version.setText(this.m_containerExtension.getVersion());
        this.m_version.setLayoutData((Object)gd2);
    }

    private void createPluginId(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false);
        Label l = new Label(parent, 0);
        l.setText(Messages.PLUGIN_PROPERTIES_PAGE_PLUGIN_IDENTIFIER_LABEL);
        l.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false);
        this.m_pluginIdentifier = new Text(parent, 2048);
        this.m_pluginIdentifier.setText(this.m_containerExtension.getIdentifier());
        this.m_pluginIdentifier.setLayoutData((Object)gd2);
    }

    public boolean performFinish() {
        this.m_containerExtension.setIdentifier(this.m_pluginIdentifier.getText());
        this.m_containerExtension.setName(this.m_name.getText());
        this.m_containerExtension.setVersion(BundleVersion.valueOf(this.m_version.getText()));
        return true;
    }

    public ContributionDescriptor getContainerExtension() {
        return this.m_containerExtension;
    }
}

