/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.l10n;

import com.jrockit.mc.components.ui.l10n.ClearAction;
import com.jrockit.mc.components.ui.l10n.ExportAction;
import com.jrockit.mc.components.ui.l10n.ImportAction;
import com.jrockit.mc.components.ui.l10n.LocalizarionStringProvider;
import com.jrockit.mc.components.ui.l10n.LocalizationModel;
import com.jrockit.mc.components.ui.l10n.RemoveDuplicatesAction;
import com.jrockit.mc.components.ui.messages.internal.Messages;
import com.jrockit.mc.ui.fields.FieldTableViewer;
import com.jrockit.mc.ui.fields.FieldViewerFilterControl;
import com.jrockit.mc.ui.formpage.internal.MCFormPage;
import com.jrockit.mc.ui.handlers.MCContextMenuManager;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.model.fields.StringField;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;

final class LocalizationPage
extends MCFormPage {
    private final LocalizationModel m_model;
    private Composite m_container;
    private FieldTableViewer m_viewer;
    private FieldViewerFilterControl m_fv;

    public LocalizationPage(FormEditor editor, LocalizationModel model) {
        super(editor, "localization.keys.editor", Messages.LOCALIZATION_LOCALIZATION_EDITOR_TEXT);
        this.m_model = model;
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        Composite body = managedForm.getForm().getBody();
        managedForm.getToolkit().paintBordersFor(body);
        body.setLayout((Layout)new GridLayout());
        this.m_container = managedForm.getToolkit().createComposite(body);
        managedForm.getToolkit().paintBordersFor(this.m_container);
        this.m_container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_container.setLayout((Layout)new GridLayout());
        this.m_fv = new FieldViewerFilterControl(this.m_container, managedForm.getToolkit(), true);
        this.m_fv.setLayoutData((Object)new GridData(4, 4, true, false));
        managedForm.getToolkit().adapt((Composite)this.m_fv);
        this.m_viewer = this.createViewer(this.m_container);
        this.addActions(this.m_container.getShell(), managedForm.getForm().getToolBarManager());
        this.hookModelListener(this.m_model);
        this.m_fv.initialize((StructuredViewer)this.m_viewer, this.m_viewer.getFields());
    }

    private void addActions(Shell shell, IToolBarManager tm) {
        tm.add((IAction)new RemoveDuplicatesAction(this.m_model));
        tm.add((IAction)new ImportAction(shell, this.m_model));
        tm.add((IAction)new ExportAction(shell, this.m_model));
        tm.update(true);
    }

    private FieldTableViewer createViewer(Composite container) {
        FieldTableViewer viewer = FieldTableViewer.createWithStandardTable((Composite)container, (Field[])this.createFields());
        viewer.setContentProvider((IContentProvider)new LocalizarionStringProvider());
        viewer.setInput((Object)this.m_model);
        this.hookModelListener(this.m_model);
        viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.createMenuManager(viewer);
        return viewer;
    }

    private void createMenuManager(FieldTableViewer viewer) {
        MCContextMenuManager m = new MCContextMenuManager("contextmenu");
        m.add((IAction)new ClearAction(this.m_model, (ISelectionProvider)viewer));
        Menu menu = m.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
    }

    private void hookModelListener(LocalizationModel model) {
        model.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                LocalizationPage.this.m_viewer.getControl().dispose();
                LocalizationPage.this.m_viewer = LocalizationPage.this.createViewer(LocalizationPage.this.m_container);
                LocalizationPage.this.m_fv.initialize((StructuredViewer)LocalizationPage.this.m_viewer, LocalizationPage.this.m_viewer.getFields());
                LocalizationPage.this.m_container.layout();
            }
        });
    }

    private Field[] createFields() {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(LocalizarionStringProvider.FIELD_KEY);
        fields.add(LocalizarionStringProvider.FIELD_DUPLICATE);
        fields.add(LocalizarionStringProvider.FIELD_PLACEMENT);
        for (String locale : this.m_model.getUsedLocales()) {
            fields.add(this.createLocaleField(fields.size(), locale));
        }
        return fields.toArray(new Field[fields.size()]);
    }

    private Field createLocaleField(int index, String locale) {
        StringField field = new StringField(index);
        if (locale.length() == 0) {
            field.setName("Default");
        } else {
            field.setName(locale);
        }
        field.setMinWidth(100);
        field.setWidthWeight(100);
        return field;
    }
}

