/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.settings;

import com.jrockit.mc.components.ui.messages.internal.Messages;
import com.jrockit.mc.components.ui.settings.BrowseInput;
import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.MCFile;
import com.jrockit.mc.ui.idesupport.BasicIDESupport;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Shell;

public class FileInput
extends BrowseInput {
    private final BasicIDESupport m_basicIdeSupport = new BasicIDESupport();
    private String m_browseTitle = Messages.FILE_INPUT_SELECT_FILE_TITLE;
    private String m_suffix = "txt";
    private String m_prefix = "file";
    private String m_description = "";
    private boolean m_allowDirectory = true;
    private boolean m_allowFile = true;
    private boolean m_mustExists = false;

    public FileInput(String property, String name) {
        super(property, name);
    }

    public void setAllowDirectory(boolean allowDirectory) {
        this.m_allowDirectory = allowDirectory;
    }

    public void setAllowFile(boolean allowfile) {
        this.m_allowFile = allowfile;
    }

    public boolean getAllowFile() {
        return this.m_allowFile;
    }

    public boolean getAllowDirectory() {
        return this.m_allowDirectory;
    }

    public void setMustExist(boolean mustExist) {
        this.m_mustExists = mustExist;
    }

    public boolean getMustExits() {
        return this.m_mustExists;
    }

    @Override
    protected boolean hasValidData() {
        MCFile mcfile = this.m_basicIdeSupport.fromPath((IPath)new Path(this.getPropertyValue()));
        File file = mcfile.toFile();
        if (!file.exists() && this.getMustExits()) {
            return false;
        }
        if (!this.getAllowDirectory() && file.isDirectory()) {
            return false;
        }
        return this.getAllowFile() || file.isDirectory();
    }

    public void setBrowseTitle(String browseTitle) {
        this.m_browseTitle = browseTitle;
    }

    String getSuggestName() {
        return this.m_basicIdeSupport.getValidDefaultFile(this.getPrefix(), this.getSuffix()).getPath().toString();
    }

    public void setSuffix(String suffix) {
        this.m_suffix = suffix;
    }

    public void setPrefix(String prefix) {
        this.m_prefix = prefix;
    }

    public String getSuffix() {
        return this.m_suffix;
    }

    public String getPrefix() {
        return this.m_prefix;
    }

    @Override
    protected boolean browse(Shell shell) {
        MCFile file;
        String s = this.getPropertyValue();
        if (s.trim().length() == 0) {
            s = CorePlugin.getDefault().getWorkspaceDirectory().toString();
        }
        if ((file = this.m_basicIdeSupport.browseForOpenFile(this.m_browseTitle, (IPath)new Path(s), "de")) != null) {
            this.setPropertyValue(file.getPath().toString());
            return true;
        }
        return false;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public IPath getWorkspace() {
        return new Path(CorePlugin.getDefault().getWorkspaceDirectory().toString());
    }

    @Override
    protected String getTextualRepresentation() {
        return this.getPropertyValue();
    }

    public void setFile(File file) {
        this.setPropertyValue(file.getPath());
        this.refresh();
    }
}

