/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.overview;

import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.console.ui.ConsolePlugin;
import com.jrockit.mc.console.ui.actions.NewVisualizerAction;
import com.jrockit.mc.console.ui.actions.ResetToDefaultsAction;
import com.jrockit.mc.console.ui.editor.ConsoleEditor;
import com.jrockit.mc.console.ui.editor.ConsoleTab;
import com.jrockit.mc.console.ui.overview.Messages;
import com.jrockit.mc.console.ui.overview.OverviewPlugin;
import com.jrockit.mc.console.ui.sections.SectionPartManager;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.ui.AttributeVisualizerBuilder;
import com.jrockit.mc.rjmx.ui.IAttributeVisualizer;
import com.jrockit.mc.rjmx.ui.internal.ChartModel;
import com.jrockit.mc.rjmx.ui.internal.CombinedChartSectionPart;
import com.jrockit.mc.rjmx.ui.internal.CombinedDialsSectionPart;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.layout.ReflowExpansionListener;
import com.jrockit.mc.ui.layout.SimpleLayout;
import com.jrockit.mc.ui.layout.SimpleLayoutData;
import com.jrockit.mc.ui.sections.MCSectionPart;
import java.util.List;
import java.util.logging.Level;
import javax.management.MalformedObjectNameException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OverviewTab
extends ConsoleTab
implements XmlEnabled,
ISaveablePart2 {
    private static final String PREFERENCE_KEY_OVERVIEW_DATA = "overviewData";
    private SectionPartManager m_sectionPartManager;

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        SimpleLayout layout = new SimpleLayout();
        layout.setAlignment(1);
        layout.setHorizontalOrientation(false);
        form.getBody().setLayout((Layout)layout);
        ConsoleEditor ce = (ConsoleEditor)this.getEditor();
        this.m_sectionPartManager = new SectionPartManager(this.getTitle(), managedForm, new AttributeVisualizerBuilder(managedForm, this.getConnectionHandle()));
        ce.addSectionManager(this.m_sectionPartManager);
        OverviewTab.initializeToolbar(form.getToolBarManager(), this.m_sectionPartManager);
        if (!this.initTabFromStore(OverviewPlugin.getDefault().getPreferenceStore(), PREFERENCE_KEY_OVERVIEW_DATA, this)) {
            OverviewTab.createDefaults(this.m_sectionPartManager);
        }
        this.getManagedForm().reflow(true);
    }

    public void doSave(IProgressMonitor monitor) {
        this.exportTabToStore(OverviewPlugin.getDefault().getPreferenceStore(), PREFERENCE_KEY_OVERVIEW_DATA, this);
    }

    public void exportToXml(Element parentNode) {
        Element e = XmlToolkit.createElement((Element)parentNode, (String)this.getComponentTag());
        e.setAttribute("uid", this.getConnectionHandle().getServerDescriptor().getGUID());
        for (IFormPart part : this.m_sectionPartManager.getParts()) {
            if (!(part instanceof XmlEnabled)) continue;
            ((XmlEnabled)part).exportToXml(e);
        }
    }

    public String getComponentTag() {
        return "OverviewTab";
    }

    public void initializeFromXml(Element node) throws Exception {
        this.initializeDialsFromXml(node);
        this.initializeChartsFromXml(node);
    }

    private static void initializeToolbar(IToolBarManager iToolBarManager, SectionPartManager spm) {
        if (!(iToolBarManager instanceof ContributionManager)) {
            ConsolePlugin.getDefault().getLogger().severe("Eclipse implementation change! Cannot initialize toolbar!");
            return;
        }
        ContributionManager cm = (ContributionManager)iToolBarManager;
        ActionContributionItem aci = new ActionContributionItem((IAction)new ResetAction(spm));
        aci.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        cm.insert(0, (IContributionItem)aci);
        NewVisualizerAction action = NewVisualizerAction.createAddChartAction((SectionPartManager)spm);
        aci = new ActionContributionItem((IAction)action);
        aci.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        cm.insert(0, (IContributionItem)aci);
        cm.update(true);
    }

    private static void createDefaults(SectionPartManager spm) {
        IManagedForm form = spm.getManagementForm();
        AttributeVisualizerBuilder builder = spm.getGuiBuilder();
        OverviewTab.createDefaultDials(spm, form, builder);
        OverviewTab.createDefaultCharts(spm, form, builder);
    }

    private static void createDefaultDials(SectionPartManager spm, IManagedForm form, AttributeVisualizerBuilder builder) {
        builder.clearProperties();
        builder.setProperty("sectionIdentifier", (Object)"com.jrockit.mc.console.ui.overview.help_DialsDashboard");
        builder.setProperty("title", (Object)Messages.OverviewTab_SECTION_DASHBOARD_TEXT);
        CombinedDialsSectionPart section = builder.createDialDashboard();
        OverviewTab.setupDialLayoutData((IAttributeVisualizer)section);
        OverviewTab.setUpExpansionHandling((SectionPart)section, form);
        spm.add((MCSectionPart)section);
        OverviewTab.initializeDialPanel((IAttributeVisualizer)section);
    }

    private static void createDefaultCharts(SectionPartManager spm, IManagedForm form, AttributeVisualizerBuilder builder) {
        builder.clearProperties();
        builder.setProperty("sectionIdentifier", (Object)"com.jrockit.mc.console.ui.overview.help_ProcessorGraph");
        builder.setProperty("title", (Object)Messages.OverviewTab_SECTION_PROCESSOR_TEXT);
        builder.setProperty("dataType", (Object)ChartModel.DataType.PERCENT);
        builder.setProperty("axisX", (Object)Messages.OverviewTab_CHARTS_DEFAULT_X_AXIS_TITLE_TEXT);
        CombinedChartSectionPart section = builder.createChart();
        OverviewTab.setupChartLayoutData((IAttributeVisualizer)section);
        OverviewTab.setUpExpansionHandling((SectionPart)section, form);
        spm.add((MCSectionPart)section);
        OverviewTab.initializeProcessorChart((IAttributeVisualizer)section);
        builder.clearProperties();
        builder.setProperty("sectionIdentifier", (Object)"com.jrockit.mc.console.ui.overview.help_MemoryGraph");
        builder.setProperty("title", (Object)Messages.OverviewTab_SECTION_MEMORY_TEXT);
        builder.setProperty("dataType", (Object)ChartModel.DataType.PERCENT);
        builder.setProperty("axisX", (Object)Messages.OverviewTab_CHARTS_DEFAULT_X_AXIS_TITLE_TEXT);
        section = builder.createChart();
        OverviewTab.setupChartLayoutData((IAttributeVisualizer)section);
        OverviewTab.setUpExpansionHandling((SectionPart)section, form);
        spm.add((MCSectionPart)section);
        OverviewTab.initializeMemoryChart((IAttributeVisualizer)section);
    }

    private static void initializeDialPanel(IAttributeVisualizer dialPanel) {
        dialPanel.clear();
        dialPanel.add(new MRI(MRI.Type.ATTRIBUTE, "java.lang:type=Memory", "HeapMemoryUsage/used"));
        dialPanel.add(new MRI(MRI.Type.ATTRIBUTE, "java.lang:type=OperatingSystem", "ProcessCpuLoad"));
        dialPanel.add(new MRI(MRI.Type.NOTIFICATION, "com.sun.management:type=GarbageCollectionAggregator", "com.sun.management.gc.heapLiveSet"));
    }

    private static void initializeMemoryChart(IAttributeVisualizer memoryChart) {
        memoryChart.clear();
        memoryChart.add(new MRI(MRI.Type.ATTRIBUTE, "java.lang:type=OperatingSystem", "PhysicalMemoryUsagePercent"));
        memoryChart.add(new MRI(MRI.Type.ATTRIBUTE, "java.lang:type=Memory", "HeapMemoryUsagePercent"));
    }

    private static void initializeProcessorChart(IAttributeVisualizer processorChart) {
        processorChart.clear();
        processorChart.add(new MRI(MRI.Type.ATTRIBUTE, "java.lang:type=OperatingSystem", "SystemCpuLoad"));
        processorChart.add(new MRI(MRI.Type.ATTRIBUTE, "java.lang:type=OperatingSystem", "ProcessCpuLoad"));
    }

    private void initializeChartsFromXml(Element node) throws Exception {
        List l = XmlToolkit.getChildElementsByTag((Node)node, (String)"CombinedChartSectionPart");
        if (l != null) {
            AttributeVisualizerBuilder builder = this.m_sectionPartManager.getGuiBuilder();
            for (Element element : l) {
                try {
                    CombinedChartSectionPart sectionPart = builder.createChart();
                    OverviewTab.setupChartLayoutData((IAttributeVisualizer)sectionPart);
                    OverviewTab.setUpExpansionHandling((SectionPart)sectionPart, this.m_sectionPartManager.getManagementForm());
                    this.m_sectionPartManager.add((MCSectionPart)sectionPart);
                    sectionPart.initializeFromXml(element);
                }
                catch (MalformedObjectNameException e) {
                    UIPlugin.getDefault().getLogger().log(Level.WARNING, "Unable to instantiate graph", e);
                }
            }
        }
    }

    private static void setUpExpansionHandling(SectionPart sectionPart, IManagedForm form) {
        sectionPart.getSection().addExpansionListener((IExpansionListener)new ReflowExpansionListener(form));
    }

    private static void setupDialLayoutData(IAttributeVisualizer adv) {
        SimpleLayoutData sd1 = new SimpleLayoutData();
        GC tempGc = new GC((Drawable)adv.getControl());
        int fontHeight = tempGc.getFontMetrics().getHeight();
        sd1.setMinSize(147 + 3 * fontHeight);
        sd1.setMaxSize(147 + 3 * fontHeight);
        sd1.setWeight(1.0f);
        adv.getControl().setLayoutData((Object)sd1);
    }

    private static void setupChartLayoutData(IAttributeVisualizer adv) {
        SimpleLayoutData sd3 = new SimpleLayoutData();
        sd3.setMinSize(150);
        sd3.setWeight(1.0f);
        adv.getControl().setLayoutData((Object)sd3);
    }

    private void initializeDialsFromXml(Element node) throws Exception {
        List l = XmlToolkit.getChildElementsByTag((Node)node, (String)"CombinedDialsSectionPart");
        if (l != null) {
            AttributeVisualizerBuilder builder = this.m_sectionPartManager.getGuiBuilder();
            for (Element element : l) {
                CombinedDialsSectionPart sectionPart = builder.createDialDashboard();
                OverviewTab.setupDialLayoutData((IAttributeVisualizer)sectionPart);
                OverviewTab.setUpExpansionHandling((SectionPart)sectionPart, this.m_sectionPartManager.getManagementForm());
                this.m_sectionPartManager.add((MCSectionPart)sectionPart);
                sectionPart.initializeFromXml(element);
            }
        }
    }

    private static class ResetAction
    extends ResetToDefaultsAction {
        private final SectionPartManager m_sectionPartManager;

        public ResetAction(SectionPartManager spm) {
            this.m_sectionPartManager = spm;
        }

        protected void reset() {
            this.m_sectionPartManager.destroyAllParts();
            OverviewTab.createDefaults(this.m_sectionPartManager);
        }
    }
}

