/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.persistence;

import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Type;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Setting {
    private Map<String, String> m_properties = new LinkedHashMap<String, String>();
    private List<Setting> m_children = new ArrayList<Setting>();
    private Map<String, Object> m_cache = new HashMap<String, Object>();
    private Setting m_parent;
    private String m_name;
    private Setting m_source;

    Setting() {
        this.m_parent = null;
    }

    public Setting(String name) {
        this(null, name);
    }

    Setting(Setting parent, String name) {
        this.m_name = name;
        this.m_parent = parent;
    }

    public final void removeChild(Setting child) {
        this.m_children.remove(child);
    }

    public final String getName() {
        return this.m_name;
    }

    public <T> T getChildObject(String key, Class<T> clazz) {
        Object object = this.m_cache.get(key);
        if (object != null) {
            return (T)object;
        }
        if (clazz == String.class) {
            return (T)this.getStringProperty(key);
        }
        if (clazz == Integer.class) {
            return (T)Integer.valueOf(this.getIntProperty(key));
        }
        if (clazz == Long.class) {
            return (T)Long.valueOf(this.getLongProperty(key));
        }
        if (clazz == Float.class) {
            return (T)Float.valueOf(this.getFloatProperty(key));
        }
        if (clazz == Double.class) {
            return (T)Double.valueOf(this.getDoubleProperty(key));
        }
        if (clazz == Boolean.class) {
            return (T)Boolean.valueOf(this.getBooleanProperty2(key));
        }
        return (T)this.childCreate(key, new Type(clazz));
    }

    public <T> T getChildObject(String key, Type type) {
        Object object = this.m_cache.get(key);
        if (object == null) {
            return (T)this.childCreate(key, type);
        }
        return (T)object;
    }

    private Object childCreate(String key, Type type) {
        Object object;
        if (this.hasChildSetting(key)) {
            Setting childSetting = this.getChild(key);
            int index = this.m_children.indexOf(childSetting);
            object = PersistenceToolkit.create(type);
            Setting newSetting = PersistenceToolkit.getSetting(object);
            Setting.injectSetting(childSetting, newSetting);
            newSetting.m_parent = this;
            this.m_children.add(index, newSetting);
            this.m_children.remove(index + 1);
            this.m_cache.put(key, object);
        } else {
            object = PersistenceToolkit.create(type);
            Setting setting = PersistenceToolkit.getSetting(object);
            setting.setName(key);
            this.addChild(setting);
            this.m_cache.put(key, object);
        }
        return object;
    }

    public final Setting getChild(String name) {
        Setting setting = this.getChildSetting(name);
        if (setting == null) {
            return this.createChild(name);
        }
        return setting;
    }

    public final Setting getChildSetting(String name) {
        for (Setting setting : this.m_children) {
            if (!name.equals(setting.getName())) continue;
            return setting;
        }
        return null;
    }

    public final String toString() {
        StringWriter sw = new StringWriter();
        try {
            PersistenceToolkit.prettyPrintShallow(sw, this, true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sw.toString();
    }

    public void setChildObject(String key, Object value) {
        if (value == null) {
            this.removeChild(key);
        } else {
            if (value instanceof Boolean) {
                this.setProperty(key, (Boolean)value);
                return;
            }
            if (value instanceof String) {
                this.setProperty(key, (String)value);
                return;
            }
            if (value instanceof Integer) {
                this.setProperty(key, (Integer)value);
                return;
            }
            if (value instanceof Long) {
                this.setProperty(key, (Long)value);
                return;
            }
            if (value instanceof Double) {
                this.setProperty(key, (Double)value);
                return;
            }
            if (value instanceof Float) {
                this.setProperty(key, ((Float)value).floatValue());
                return;
            }
            Setting source = PersistenceToolkit.getSetting(value);
            Setting destination = this.getChild(key);
            Setting.injectSetting(source, destination);
            destination.setName(key);
            this.m_cache.put(key, value);
        }
    }

    final void setName(String name) {
        this.m_name = name;
    }

    final void addChild(Setting child) {
        this.m_children.add(child);
        child.m_parent = this;
    }

    void addChild(int index, Setting setting) {
        this.m_children.add(index, setting);
        setting.m_parent = this;
    }

    final void clear() {
        this.m_children.clear();
        this.m_properties.clear();
        this.m_cache.clear();
    }

    public final List<Setting> getChildren() {
        return this.m_children;
    }

    final Setting createChild(String name) {
        Setting child = new Setting(this, name);
        this.addChild(child);
        return child;
    }

    private final void setProperty(String key, String value) {
        this.m_properties.put(key, value);
    }

    final Setting getParent() {
        return this.m_parent;
    }

    public final Map<String, String> getProperties() {
        return this.m_properties;
    }

    private void setProperty(String key, int value) {
        this.m_properties.put(key, Integer.toString(value));
    }

    private void setProperty(String key, float value) {
        this.m_properties.put(key, Float.toString(value));
    }

    private void setProperty(String key, long value) {
        this.m_properties.put(key, Long.toString(value));
    }

    private void setProperty(String key, double value) {
        this.m_properties.put(key, Double.toString(value));
    }

    private float getFloatProperty(String key) {
        String value = this.m_properties.get(key);
        if (value == null) {
            return 0.0f;
        }
        return Float.parseFloat(value);
    }

    private int getIntProperty(String key) {
        String value = this.m_properties.get(key);
        if (value == null) {
            return 0;
        }
        return Integer.parseInt(value);
    }

    private double getDoubleProperty(String key) {
        String value = this.m_properties.get(key);
        if (value == null) {
            return 0.0;
        }
        return Double.parseDouble(value);
    }

    private String getStringProperty(String key) {
        String prop = this.m_properties.get(key);
        return prop == null ? "" : prop;
    }

    private long getLongProperty(String key) {
        String value = this.m_properties.get(key);
        if (value == null) {
            return 0L;
        }
        return Long.parseLong(value);
    }

    private boolean getBooleanProperty2(String key) {
        String value = this.m_properties.get(key);
        if (value == null) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }

    static void injectSetting(Setting source, Setting destintaion) {
        destintaion.m_name = source.m_name;
        destintaion.m_properties = source.m_properties;
        destintaion.m_source = source.m_source;
        destintaion.m_cache = source.m_cache;
        destintaion.m_children = source.m_children;
    }

    private void setProperty(String key, boolean value) {
        this.m_properties.put(key, Boolean.toString(value));
    }

    void removeChild(String key) {
        this.m_children.remove(this.getChildSetting(key));
        this.m_properties.remove(key);
        this.m_cache.remove(key);
    }

    boolean hasChildSetting(String name) {
        return this.getChildSetting(name) != null;
    }

    void setSource(Setting source) {
        this.m_source = source;
    }

    Setting getSource() {
        return this.m_source;
    }

    void removeChild(int index) {
        this.m_children.remove(index);
    }

    void setChild(int index, Setting setting) {
        this.m_children.set(index, setting);
        setting.m_parent = this;
    }

    Setting getRoot() {
        if (this.getParent() != null) {
            return this.getParent().getRoot();
        }
        return this;
    }

    public boolean hasChild(String key) {
        if (this.m_properties.containsKey(key)) {
            return true;
        }
        return this.hasChildSetting(key);
    }
}

