/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.string;

import com.jrockit.mc.common.io.IOToolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public final class StringToolkit {
    private StringToolkit() {
        throw new AssertionError((Object)"This is not the constructor you are looking for!");
    }

    public static String readString(InputStream in) throws IOException {
        return StringToolkit.readString(new BufferedReader(new InputStreamReader(in), 8192));
    }

    public static String readString(InputStream in, String charsetName) throws IOException {
        return StringToolkit.readString(new BufferedReader(new InputStreamReader(in, charsetName), 8192));
    }

    private static String readString(BufferedReader reader) throws IOException {
        String s;
        StringBuilder builder = new StringBuilder();
        try {
            while ((s = reader.readLine()) != null) {
                builder.append(String.valueOf(s) + "\r");
            }
            s = builder.toString();
        }
        finally {
            IOToolkit.closeSilently(reader);
        }
        return s;
    }

    public static String readString(File f) throws IOException {
        FileInputStream is = new FileInputStream(f);
        try {
            String string = StringToolkit.readString(is);
            return string;
        }
        finally {
            IOToolkit.closeSilently(is);
        }
    }

    public static String join(Collection<?> s, String delimiter) {
        StringBuilder builder = new StringBuilder();
        Iterator<?> iter = s.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) break;
            builder.append(delimiter);
        }
        return builder.toString();
    }

    public static String toString(Object o) {
        if (o == null) {
            return "null";
        }
        if (o.getClass().isArray()) {
            if (o instanceof Object[]) {
                if (o.getClass().getComponentType().isArray()) {
                    o = StringToolkit.toStringArray(o);
                }
                return Arrays.toString(o);
            }
            if (o instanceof int[]) {
                return Arrays.toString((int[])o);
            }
            if (o instanceof char[]) {
                return Arrays.toString((char[])o);
            }
            if (o instanceof byte[]) {
                return Arrays.toString((byte[])o);
            }
            if (o instanceof boolean[]) {
                return Arrays.toString((boolean[])o);
            }
            if (o instanceof float[]) {
                return Arrays.toString((float[])o);
            }
            if (o instanceof double[]) {
                return Arrays.toString((double[])o);
            }
            if (o instanceof long[]) {
                return Arrays.toString((long[])o);
            }
            if (o instanceof short[]) {
                return Arrays.toString((short[])o);
            }
        }
        return o.toString();
    }

    private static String[] toStringArray(Object[] array) {
        String[] ret = new String[array.length];
        int i = 0;
        while (i < ret.length) {
            ret[i] = StringToolkit.toString(array[i]);
            ++i;
        }
        return ret;
    }

    public static String wrapString(String text, int rowLength, String splitDelim, String lineDelim) {
        StringToolkit.assertValidArguments(rowLength, splitDelim, lineDelim);
        if (!StringToolkit.shouldSplit(text, rowLength, splitDelim)) {
            return text;
        }
        int splitIndex = StringToolkit.findSplit(text, rowLength, splitDelim);
        String row = text.substring(0, splitIndex);
        String rest = text.substring(splitIndex + splitDelim.length());
        return String.valueOf(row) + lineDelim + StringToolkit.wrapString(rest, rowLength, splitDelim, lineDelim);
    }

    private static void assertValidArguments(int rowLength, String splitDelim, String lineDelim) {
        if (rowLength <= 0 || splitDelim == null || lineDelim == null) {
            throw new IllegalArgumentException("Can't run wrapString with negative row length, or splitDelim/lineDelim that are null");
        }
    }

    private static boolean shouldSplit(String text, int rowLength, String splitDelim) {
        return text.length() > rowLength && text.contains(splitDelim);
    }

    private static int findSplit(String text, int rowLength, String splitDelim) {
        int index = StringToolkit.findBeforeRowLength(text, rowLength, splitDelim);
        if (index == -1) {
            index = StringToolkit.findAfterRowLength(text, rowLength, splitDelim);
        }
        if (index == -1) {
            index = text.length();
        }
        return index;
    }

    private static int findAfterRowLength(String text, int rowLength, String splitDelim) {
        return text.indexOf(splitDelim, StringToolkit.searchLength(text, rowLength));
    }

    private static int findBeforeRowLength(String text, int rowLength, String splitDelim) {
        return text.substring(0, StringToolkit.searchLength(text, rowLength)).lastIndexOf(splitDelim);
    }

    private static int searchLength(String text, int rowLength) {
        return Math.min(text.length(), rowLength);
    }
}

