/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.unit;

public final class BinaryPrefix
extends Enum<BinaryPrefix> {
    public static final /* enum */ BinaryPrefix NONE = new BinaryPrefix();
    public static final /* enum */ BinaryPrefix KIBI = new BinaryPrefix(1, 'k');
    public static final /* enum */ BinaryPrefix MEBI = new BinaryPrefix(2, 'M');
    public static final /* enum */ BinaryPrefix GIBI = new BinaryPrefix(3, 'G');
    public static final /* enum */ BinaryPrefix TEBI = new BinaryPrefix(4, 'T');
    public static final /* enum */ BinaryPrefix PEBI = new BinaryPrefix(5, 'P');
    public static final /* enum */ BinaryPrefix EXBI = new BinaryPrefix(6, 'E');
    public static final /* enum */ BinaryPrefix ZEBI = new BinaryPrefix(7, 'Z');
    public static final /* enum */ BinaryPrefix YOBI = new BinaryPrefix(8, 'Y');
    private static BinaryPrefix[] PREFIXES;
    private final int shift;
    private final float inverse;
    public final String prefixSI;
    public final String prefixIEC;
    private static final /* synthetic */ BinaryPrefix[] ENUM$VALUES;

    static {
        ENUM$VALUES = new BinaryPrefix[]{NONE, KIBI, MEBI, GIBI, TEBI, PEBI, EXBI, ZEBI, YOBI};
        PREFIXES = BinaryPrefix.values();
    }

    private BinaryPrefix() {
        assert (this.ordinal() == 0) : "Implementation error in enum: (ordinal = " + this.ordinal() + ") != 0";
        this.shift = 0;
        this.inverse = 1.0f;
        this.prefixSI = "";
        this.prefixIEC = "";
    }

    private BinaryPrefix(int powerOf1024, char prefixSI) {
        assert (powerOf1024 == this.ordinal()) : "Implementation error in enum: (ordinal = " + this.ordinal() + ") != (powerOf1024 = " + powerOf1024 + ')';
        this.shift = powerOf1024 * 10;
        this.inverse = (float)Math.pow(2.0, -this.shift);
        this.prefixSI = String.valueOf(prefixSI);
        this.prefixIEC = "" + Character.toUpperCase(prefixSI) + 'i';
    }

    public int shift() {
        return this.shift;
    }

    public int log1024() {
        return this.ordinal();
    }

    public long convertTo(long value) {
        return value >>> this.shift;
    }

    public float convertTo(float value) {
        return value * this.inverse;
    }

    public double convertTo(double value) {
        return value * (double)this.inverse;
    }

    public static int getFloorLog1024(long value) {
        int log2 = 63 - Long.numberOfLeadingZeros(Math.abs(value));
        return log2 / 10;
    }

    public static BinaryPrefix getFloorPrefix(long value) {
        return PREFIXES[BinaryPrefix.getFloorLog1024(value)];
    }

    public static int getFloorLog1024(double value) {
        int log2 = Math.getExponent(value);
        if (log2 < 0) {
            return 0;
        }
        return log2 / 10;
    }

    public static BinaryPrefix getFloorPrefix(double value) {
        return PREFIXES[BinaryPrefix.getFloorLog1024(value)];
    }

    public static BinaryPrefix[] values() {
        BinaryPrefix[] binaryPrefixArray = ENUM$VALUES;
        int n = binaryPrefixArray.length;
        BinaryPrefix[] binaryPrefixArray2 = new BinaryPrefix[n];
        System.arraycopy(ENUM$VALUES, 0, binaryPrefixArray2, 0, n);
        return binaryPrefixArray2;
    }

    public static BinaryPrefix valueOf(String string) {
        return Enum.valueOf(BinaryPrefix.class, string);
    }
}

