/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.unit;

import com.jrockit.mc.common.unit.DisplayUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ContentType {
    private final List<DisplayUnit> m_displayUnits = new ArrayList<DisplayUnit>();
    private final String m_name;
    private final String m_identifier;

    ContentType(String name, String identifier) {
        this.m_name = name;
        this.m_identifier = identifier;
    }

    public Map<String, String> createDisplayUnitMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (DisplayUnit unit : this.m_displayUnits) {
            map.put(unit.getIdentifier(), unit.getName());
        }
        return map;
    }

    void addDisplayUnit(DisplayUnit displayUnit) {
        this.m_displayUnits.add(displayUnit);
    }

    void removeDisplayUnit(DisplayUnit displayUnit) {
        this.m_displayUnits.remove(displayUnit);
    }

    public List<DisplayUnit> getDisplayUnits() {
        return Collections.unmodifiableList(this.m_displayUnits);
    }

    public String getName() {
        return this.m_name;
    }

    public String getIdentifier() {
        return this.m_identifier;
    }

    public DisplayUnit getDisplayUnit(String displayUnitIdentifier) {
        for (DisplayUnit du : this.m_displayUnits) {
            if (!displayUnitIdentifier.equals(du.getIdentifier())) continue;
            return du;
        }
        return this.m_displayUnits.get(0);
    }
}

