/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.unit;

import com.jrockit.mc.common.util.Messages;
import java.text.MessageFormat;

public abstract class QuantityConversionException
extends Exception {
    private static final long serialVersionUID = 1L;
    protected final Problem problem;
    protected final String badString;

    public static QuantityConversionException unparsable(String badString, String prototype) {
        return new Fixed(Problem.UNPARSEABLE, badString, prototype);
    }

    public static QuantityConversionException noUnit(String badString, String prototype) {
        return new Fixed(Problem.NO_UNIT, badString, prototype);
    }

    public static QuantityConversionException unknownUnit(String badString, String prototype) {
        return new Fixed(Problem.UNKNOWN_UNIT, badString, prototype);
    }

    public static QuantityConversionException tooLow(String badString, String min) {
        return new Fixed(Problem.TOO_LOW, badString, min);
    }

    public static QuantityConversionException tooHigh(String badString, String max) {
        return new Fixed(Problem.TOO_HIGH, badString, max);
    }

    public static QuantityConversionException belowPrecision(String badString, String ulp) {
        return new Fixed(Problem.TOO_SMALL_MAGNITUDE, badString, ulp);
    }

    protected QuantityConversionException(Problem problem, String badString) {
        this.problem = problem;
        this.badString = badString;
    }

    public Problem getProblem() {
        return this.problem;
    }

    public String getBadString() {
        return this.badString;
    }

    public abstract String getPersistablePrototype();

    public abstract String getHumanPrototype();

    @Override
    public String getMessage() {
        return this.problem != null ? MessageFormat.format(this.problem.logMsg, this.badString, this.getPersistablePrototype()) : null;
    }

    @Override
    public String getLocalizedMessage() {
        return this.problem != null ? MessageFormat.format(this.problem.localizedMsg, this.badString, this.getHumanPrototype()) : null;
    }

    public static class Fixed
    extends QuantityConversionException {
        private static final long serialVersionUID = 1L;
        protected final String prototype;

        public Fixed(Problem problem, String badString, String prototype) {
            super(problem, badString);
            this.prototype = prototype;
        }

        @Override
        public String getPersistablePrototype() {
            return this.prototype;
        }

        @Override
        public String getHumanPrototype() {
            return this.prototype;
        }
    }

    public static enum Problem {
        UNPARSEABLE("Unparsable {0}, expected {1}", "QuantityConversionException_UNPARSEABLE_MSG"),
        NO_UNIT("No unit in {0}, expected {1}", "QuantityConversionException_NO_UNIT_MSG"),
        UNKNOWN_UNIT("Unknown unit in {0}, expected {1}", "QuantityConversionException_UNKNOWN_UNIT_MSG"),
        TOO_LOW("Value {0} too low, min is {1}", "QuantityConversionException_TOO_LOW_MSG"),
        TOO_HIGH("Value {0} too high, max is {1}", "QuantityConversionException_TOO_HIGH_MSG"),
        TOO_SMALL_MAGNITUDE("Value {0} below precision, smallest unit is {1}", "QuantityConversionException_TOO_SMALL_MAGNITUDE_MSG");

        public final String logMsg;
        public final String localizedMsg;

        private Problem(String logMsg, String localizedMsgKey) {
            this.logMsg = logMsg;
            this.localizedMsg = Messages.getString(localizedMsgKey);
        }
    }
}

