/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class BoundedList<T>
implements Iterable<T> {
    private final int maxSize;
    private int size;
    private Node<T> first;
    private Node<T> last;

    public BoundedList(int maxSize) {
        this.maxSize = maxSize;
    }

    public synchronized void add(T t) {
        Node<T> node = new Node<T>(t);
        if (this.first == null) {
            this.first = node;
            this.last = node;
        } else {
            ((Node)this.last).next = (Node)node;
            this.last = node;
        }
        ++this.size;
        if (this.size > this.maxSize) {
            this.first = ((Node)this.first).next;
            --this.size;
        }
    }

    @Override
    public synchronized Iterator<T> iterator() {
        BoundedIterator iter = new BoundedIterator(this.size, this.first, this.last);
        return iter;
    }

    public synchronized int getSize() {
        return this.size;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public String toString() {
        return this.iterator().toString();
    }

    public synchronized void clear() {
        this.size = 0;
        this.first = null;
        this.last = null;
    }

    private class BoundedIterator
    implements Iterator<T>,
    Iterable<T> {
        private final int size;
        private Node<T> current;
        private final Node<T> last;

        BoundedIterator(int size, Node<T> first, Node<T> last) {
            this.current = first;
            this.last = last;
            this.size = size;
        }

        @Override
        public boolean hasNext() {
            return this.current != null && this.current != this.last.next;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements!");
            }
            Object value = this.current.value;
            this.current = this.current.next;
            return value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("BoundedList does not support remove!");
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }

        public String toString() {
            return String.format("BoundedIterator size=%d, maxSize=%d, current=%d, last=%d ", this.size, BoundedList.this.getMaxSize(), this.current.value, this.last.value);
        }
    }

    private static class Node<T> {
        private final T value;
        private Node<T> next;

        public Node(T value) {
            this.value = value;
        }
    }
}

