/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.management.openmbean.OpenType;

public final class DefaultWhiteList {
    private static final Set<String> WHITE_LIST = new HashSet<String>();

    static {
        for (String className : OpenType.ALLOWED_CLASSNAMES_LIST) {
            DefaultWhiteList.addClass(className);
        }
        DefaultWhiteList.addClass(Object.class.getName());
        DefaultWhiteList.addClass(Class.class.getName());
        DefaultWhiteList.addClass(ArrayList.class.getName());
        DefaultWhiteList.addClass(HashMap.class.getName());
        DefaultWhiteList.addClass("java.util.HashMap$Entry");
        DefaultWhiteList.addClass("java.util.Collections$UnmodifiableMap$UnmodifiableEntrySet$UnmodifiableEntry");
        DefaultWhiteList.addClass("com.jrockit.mc.common.xml.XmlToolkit$NullValueReplacement");
    }

    private static void addClass(String className) {
        WHITE_LIST.add(className);
    }

    public static boolean isWhiteListed(String className) {
        return WHITE_LIST.contains(DefaultWhiteList.stripArray(className));
    }

    private static String stripArray(String className) {
        int dim = 0;
        while (className.startsWith("[", dim)) {
            ++dim;
        }
        if (dim > 0) {
            if (className.startsWith("L", dim) && className.endsWith(";")) {
                return className.substring(dim + 1, className.length() - 1);
            }
            throw new IllegalArgumentException("Argument className=\"" + className + "\" is not a valid class name");
        }
        return className;
    }
}

