/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.xml;

import com.jrockit.mc.common.util.DefaultWhitelistClassFactory;
import com.jrockit.mc.common.xml.ClassFactory;
import com.jrockit.mc.common.xml.ITypeFilter;
import com.jrockit.mc.common.xml.IXMLCodec;
import com.jrockit.mc.common.xml.internal.CollectionCodec;
import com.jrockit.mc.common.xml.internal.MapCodec;
import com.jrockit.mc.common.xml.internal.MapElementCodec;
import com.jrockit.mc.common.xml.internal.UnmodifiableMapCodec;
import com.jrockit.mc.common.xml.internal.XMLEnabledCodec;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XmlToolkit {
    private static final Logger LOGGER = Logger.getLogger("com.jrockit.mc.common.xml");
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String ATTRIBUTE_SIZE = "size";
    private static final String ELEMENT_ARRAY_ELEMENT = "element";
    private static final List<IXMLCodec> CODECS = new LinkedList<IXMLCodec>();
    private static final List<ITypeFilter> FILTERS = new LinkedList<ITypeFilter>();
    static final ClassFactory LOCAL_FACTORY = new ClassFactory(){

        @Override
        public Class<?> forName(String name) throws ClassNotFoundException {
            for (IXMLCodec codec : CODECS) {
                if (!codec.getType().getName().equals(name)) continue;
                return codec.getType();
            }
            return DefaultWhitelistClassFactory.getDefault().forName(name);
        }
    };
    private static NullValueReplacement NULL_VALUE = new NullValueReplacement();

    static {
        XmlToolkit.addCodec(new CollectionCodec());
        XmlToolkit.addCodec(new MapCodec());
        XmlToolkit.addCodec(new MapElementCodec());
        XmlToolkit.addCodec(new UnmodifiableMapCodec());
        XmlToolkit.addCodec(new XMLEnabledCodec());
        XmlToolkit.addFilter(new ITypeFilter(){

            @Override
            public boolean filterType(Class<?> clazz) {
                return clazz.getName().contains(".swt.");
            }
        });
    }

    private XmlToolkit() {
    }

    public static Element getOrCreateElement(Element parentNode, String tagName) {
        NodeList list = parentNode.getElementsByTagName(tagName);
        if (list.getLength() == 0) {
            Element newElement = parentNode.getOwnerDocument().createElement(tagName);
            parentNode.appendChild(newElement);
            return newElement;
        }
        return (Element)list.item(0);
    }

    public static Element createElement(Element parentNode, String tagName) {
        Element newElement = parentNode.getOwnerDocument().createElement(tagName);
        parentNode.appendChild(newElement);
        return newElement;
    }

    public static double getSetting(Element parent, String settingName, double defaultValue) {
        Element settingsNode = XmlToolkit.getOrCreateElement(parent, settingName);
        String value = XmlToolkit.getStringValue(settingsNode);
        if (value == null) {
            XmlToolkit.setSetting(parent, settingName, "" + defaultValue);
            return defaultValue;
        }
        return Double.parseDouble(value);
    }

    public static boolean getSetting(Element parent, String settingName, boolean defaultValue) {
        Element settingsNode = XmlToolkit.getOrCreateElement(parent, settingName);
        String value = XmlToolkit.getStringValue(settingsNode);
        if (value == null) {
            XmlToolkit.setSetting(parent, settingName, "" + defaultValue);
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    public static int getSetting(Element parent, String settingName, int defaultValue) {
        Element settingsNode = XmlToolkit.getOrCreateElement(parent, settingName);
        String value = XmlToolkit.getStringValue(settingsNode);
        if (value == null) {
            XmlToolkit.setSetting(parent, settingName, "" + defaultValue);
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public static void setSetting(Element parentNode, String settingsName, double value) {
        XmlToolkit.setSetting(parentNode, settingsName, Double.toString(value));
    }

    public static void setSetting(Element parentNode, String settingsName, long value) {
        XmlToolkit.setSetting(parentNode, settingsName, Long.toString(value));
    }

    public static void setSetting(Element parentNode, String settingsName, int value) {
        XmlToolkit.setSetting(parentNode, settingsName, Integer.toString(value));
    }

    public static void setSetting(Element parentNode, String settingsName, boolean value) {
        XmlToolkit.setSetting(parentNode, settingsName, Boolean.toString(value));
    }

    public static void setSetting(Element parentNode, String settingName, String settingValue) {
        String sValue;
        Element settingElement = XmlToolkit.getOrCreateElement(parentNode, settingName);
        String string = sValue = settingValue != null ? settingValue : "";
        if (settingElement == null) {
            settingElement = parentNode.getOwnerDocument().createElement(settingName);
            parentNode.appendChild(settingElement);
        }
        XmlToolkit.setStringValue(settingElement, sValue);
    }

    public static void setSettingAsCData(Element parentNode, String settingName, String settingValue) {
        Element settingElement = XmlToolkit.getOrCreateElement(parentNode, settingName);
        String sValue = settingValue != null ? settingValue : "";
        CDATASection cdata = parentNode.getOwnerDocument().createCDATASection(sValue);
        settingElement.appendChild(cdata);
    }

    public static Document createNewDocument() throws IOException {
        return XmlToolkit.createNewDocument("console");
    }

    public static Document createNewDocument(String rootElementName) throws IOException {
        Document doc = null;
        try {
            InputSource xml = new InputSource(new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?><" + rootElementName + "/>"));
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(xml);
        }
        catch (IOException e) {
            throw e;
        }
        catch (SAXException e) {
            LOGGER.log(Level.WARNING, "Error in creating new XML document", e);
        }
        catch (ParserConfigurationException e) {
            LOGGER.log(Level.WARNING, "Error in creating new XML document", e);
        }
        catch (FactoryConfigurationError e) {
            LOGGER.log(Level.WARNING, "Error in creating new XML document", e);
        }
        return doc;
    }

    public static void setStringValue(Element parent, String value) {
        if (parent == null) {
            return;
        }
        if (parent.getFirstChild() == null) {
            parent.appendChild(parent.getOwnerDocument().createTextNode(value));
        } else {
            parent.getFirstChild().setNodeValue(value);
        }
    }

    public static String getSetting(Element parent, String settingName, String defaultValue) {
        Element settingsNode = XmlToolkit.getOrCreateElement(parent, settingName);
        String value = XmlToolkit.getStringValue(settingsNode);
        if (value == null) {
            XmlToolkit.setSetting(parent, settingName, defaultValue);
            value = defaultValue;
        }
        return value;
    }

    public static String getSettingFromCData(Element parent, String settingName, String defaultValue) {
        Element settingsNode = XmlToolkit.getOrCreateElement(parent, settingName);
        NodeList list = settingsNode.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node n = list.item(i);
            if (n.getNodeType() == 4) {
                return n.getNodeValue();
            }
            ++i;
        }
        return null;
    }

    public static String getStringValue(Element element) {
        if (element == null) {
            return null;
        }
        Node n = element.getFirstChild();
        if (n == null || n.getNodeType() != 3) {
            return null;
        }
        return element.getFirstChild().getNodeValue();
    }

    private static String getNonNullStringValue(Element element) {
        String s = XmlToolkit.getStringValue(element);
        if (s == null) {
            s = "";
        }
        return s;
    }

    public static String prettyPrint(Element node) {
        StringWriter wrt = new StringWriter();
        XmlToolkit.prettyPrint(node, wrt);
        return wrt.toString();
    }

    private static void prettyPrint(Element node, Writer wrt) {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            try {
                factory.setAttribute("indent-number", "4");
            }
            catch (IllegalArgumentException iae) {
                LOGGER.info("Could not set indent-number attribute on the transformer factory.");
            }
            Transformer passThrough = factory.newTransformer();
            passThrough.setOutputProperty("indent", "yes");
            passThrough.transform(new DOMSource(node), new StreamResult(wrt));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't serialize the document to string!", e);
        }
    }

    public static List<Element> getChildElementsByTag(Node contextNode, String tag) {
        LinkedList<Element> resultList = new LinkedList<Element>();
        NodeList fullList = contextNode.getChildNodes();
        int i = 0;
        while (i < fullList.getLength()) {
            Node n = fullList.item(i);
            if (fullList.item(i).getNodeName().equals(tag) && n instanceof Element) {
                resultList.add((Element)n);
            }
            ++i;
        }
        return resultList;
    }

    public static Element getFirstChildNodeByTag(Element contextNode, String tag) {
        NodeList fullList = contextNode.getElementsByTagName(tag);
        int i = 0;
        while (i < fullList.getLength()) {
            if (fullList.item(i).getNodeName().equals(tag)) {
                return (Element)fullList.item(i);
            }
            ++i;
        }
        return null;
    }

    public static DocumentBuilder getDocumentBuilder() {
        DocumentBuilder docBuilder = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            LOGGER.log(Level.WARNING, "Parser configuration error", e);
        }
        return docBuilder;
    }

    public static Document loadDocumentFromFile(File file) throws SAXException, IOException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            Document document = XmlToolkit.loadDocumentFromStream(new BufferedInputStream(is));
            return document;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public static Document loadDocumentFromStream(InputStream stream) throws SAXException, IOException {
        return XmlToolkit.getDocumentBuilder().parse(stream);
    }

    public static Document loadDocumentFromString(String doc) throws SAXException {
        if (doc == null) {
            return null;
        }
        try {
            return XmlToolkit.getDocumentBuilder().parse(new InputSource(new StringReader(doc)));
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "If this happens I'm a duck.", e);
            return null;
        }
    }

    public static void storeDocumentToFile(Document doc, File file) throws IOException {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(file, "UTF-8");
            XmlToolkit.prettyPrint(doc.getDocumentElement(), pw);
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    public static String storeDocumentToString(Document doc) {
        return XmlToolkit.prettyPrint(doc.getDocumentElement());
    }

    public static void setNameTypeValue(Element parent, String name, Object value) {
        if (value == null || XmlToolkit.isFiltered(value)) {
            value = NULL_VALUE;
        }
        Element elem = XmlToolkit.createElement(parent, name);
        Class<?> c = value.getClass();
        elem.setAttribute(ATTRIBUTE_TYPE, c.getName());
        if (Number.class.isAssignableFrom(c) || Boolean.class.isAssignableFrom(c) || c.equals(String.class)) {
            XmlToolkit.setStringValue(elem, value.toString());
        } else if (c.isArray() && !c.getComponentType().isArray()) {
            int size = Array.getLength(value);
            elem.setAttribute(ATTRIBUTE_SIZE, Integer.toString(size));
            int i = 0;
            while (i < size) {
                Object element = Array.get(value, i);
                XmlToolkit.setNameTypeValue(elem, ELEMENT_ARRAY_ELEMENT + Integer.toString(i), element);
                ++i;
            }
        } else if (NullValueReplacement.class.isAssignableFrom(c)) {
            XmlToolkit.setStringValue(elem, "null");
        } else if (Class.class.isAssignableFrom(c)) {
            XmlToolkit.setStringValue(elem, ((Class)value).getName());
        } else {
            try {
                IXMLCodec codec = XmlToolkit.findAppropriateCodec(c);
                codec.encode(value, elem);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Tried to serialize an object of an unsupported type: " + c.getName());
            }
        }
    }

    private static boolean isFiltered(Object value) {
        for (ITypeFilter filter : FILTERS) {
            if (!filter.filterType(value.getClass())) continue;
            return true;
        }
        return false;
    }

    public static Element getChildElementOrNull(Element parent, String name) {
        List<Element> nodes = XmlToolkit.getChildElementsByTag(parent, name);
        if (nodes.isEmpty()) {
            return null;
        }
        return nodes.get(0);
    }

    public static Object getNameTypeValue(Element parent, String name) throws DOMException {
        return XmlToolkit.getNameTypeValue(parent, name, LOCAL_FACTORY);
    }

    public static Object getNameTypeValue(Element parent, String name, ClassFactory factoryToUse) throws DOMException {
        Class<?> c;
        Element elem;
        block8: {
            elem = XmlToolkit.getChildElementOrNull(parent, name);
            if (elem == null) {
                throw new DOMException(8, "Could not find a type value by the name " + name);
            }
            try {
                c = factoryToUse.forName(elem.getAttribute(ATTRIBUTE_TYPE));
                if (Number.class.isAssignableFrom(c) || Boolean.class.isAssignableFrom(c) || c.equals(String.class)) {
                    Object[] arg = new String[]{XmlToolkit.getNonNullStringValue(elem)};
                    Constructor<?> constructor = c.getConstructor(String.class);
                    return constructor.newInstance(arg);
                }
                if (c.isArray()) {
                    int size = Integer.parseInt(elem.getAttribute(ATTRIBUTE_SIZE));
                    Object arrayObj = Array.newInstance(c.getComponentType(), size);
                    int i = 0;
                    while (i < size) {
                        Array.set(arrayObj, i, XmlToolkit.getNameTypeValue(elem, ELEMENT_ARRAY_ELEMENT + Integer.toString(i), factoryToUse));
                        ++i;
                    }
                    return arrayObj;
                }
                if (Class.class.isAssignableFrom(c)) {
                    return factoryToUse.forName(XmlToolkit.getNonNullStringValue(elem));
                }
                if (!NullValueReplacement.class.isAssignableFrom(c)) break block8;
                return null;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Problem recreating the XML-serialized name-type-value element: " + name, e);
                return null;
            }
        }
        IXMLCodec codec = XmlToolkit.findAppropriateCodec(c);
        return codec.decode(elem, factoryToUse);
    }

    private static IXMLCodec findAppropriateCodec(Class<?> c) throws Exception {
        int i = 0;
        while (i < CODECS.size()) {
            IXMLCodec codec = CODECS.get(i);
            if (codec.getType().isAssignableFrom(c)) {
                return codec;
            }
            ++i;
        }
        throw new Exception("Could not find an appropriate codec for " + c.getName());
    }

    public static boolean parseBoolean(String s) {
        return s != null && s.equalsIgnoreCase("true");
    }

    public static void addCodec(IXMLCodec codec) {
        CODECS.add(0, codec);
    }

    public static void addFilter(ITypeFilter filter) {
        FILTERS.add(filter);
    }

    static class NullValueReplacement {
        NullValueReplacement() {
        }
    }
}

