/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.information.model;

import com.jrockit.mc.common.jvm.JVMDescriptor;
import com.jrockit.mc.console.ui.information.messages.internal.Messages;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.services.IVirtualMachineService;
import com.jrockit.mc.rjmx.subscription.IMBeanHelperService;
import com.jrockit.mc.rjmx.subscription.MRI;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.eclipse.osgi.util.NLS;

public class ServerInformationModel {
    private final IConnectionHandle m_connectionHandle;
    private Properties m_serverProperties;

    public ServerInformationModel(IConnectionHandle connectionHandle) {
        this.m_connectionHandle = connectionHandle;
    }

    public String getConnectionInformation() {
        return NLS.bind((String)Messages.CONNECTION_INFORMATION_VALUE, (Object)this.m_connectionHandle.getServerDescriptor().getDisplayName(), (Object)this.m_connectionHandle.toString());
    }

    public String getOsVersion() {
        return String.valueOf(this.getServerProperty("os.name")) + ' ' + this.getServerProperty("os.version");
    }

    public String getOsArchitecture() {
        return this.getServerProperty("os.arch");
    }

    public int getNumberOfProcessors() {
        return ((Number)this.getAttributeValue("java.lang:type=OperatingSystem", "AvailableProcessors", -1)).intValue();
    }

    public long getTotalPhysicalMemory() {
        return (Long)this.getAttributeValue("java.lang:type=OperatingSystem", "TotalPhysicalMemorySize", -1L);
    }

    public int getPID() {
        return ((IVirtualMachineService)this.m_connectionHandle.getServiceOrDummy(IVirtualMachineService.class)).getPID();
    }

    public String getVmVersion() {
        Object[] values = new String[]{this.getServerProperty("java.vm.name"), this.getServerProperty("java.vm.version"), this.getServerProperty("java.runtime.version")};
        return NLS.bind((String)Messages.VM_VERSION_VALUE, (Object[])values);
    }

    public String getVmVendor() {
        return this.getServerProperty("java.vm.vendor");
    }

    public String getStartTime() {
        Object o = this.getAttributeValue("java.lang:type=Runtime", "StartTime", null);
        if (o instanceof Long) {
            DateFormat f = DateFormat.getDateTimeInstance(3, 2);
            return f.format(new Date((Long)o));
        }
        return "";
    }

    public String getClassPath() {
        return this.getServerProperty("java.class.path");
    }

    public String getVmArguments() {
        String[] arguments;
        try {
            arguments = (String[])this.getMBeanHelperService().getAttribute(new MRI(MRI.Type.ATTRIBUTE, new ObjectName("java.lang:type=Runtime"), "InputArguments")).getValue();
        }
        catch (MalformedObjectNameException e) {
            return "";
        }
        catch (IOException e) {
            return "";
        }
        catch (JMException e) {
            return "";
        }
        StringBuilder argBuilder = new StringBuilder();
        String[] stringArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            String argument = stringArray[n2];
            if (argBuilder.length() > 0) {
                argBuilder.append(' ');
            }
            argBuilder.append(argument);
            ++n2;
        }
        return argBuilder.toString();
    }

    public String getApplicationArguments() {
        String arguments = this.getAttributeValue("oracle.jrockit.management:type=PerfCounters", "sun.rt.javaCommand", "").toString();
        if (arguments.length() > 0) {
            return arguments;
        }
        arguments = this.getServerProperty("sun.java.command");
        if (arguments == null || arguments.length() == 0) {
            JVMDescriptor jvmInfo = this.m_connectionHandle.getServerDescriptor().getJvmInfo();
            arguments = jvmInfo != null && jvmInfo.getJavaCommandLine() != null ? jvmInfo.getJavaCommandLine() : "";
        }
        return arguments;
    }

    public String getLibraryPath() {
        return this.getServerProperty("java.library.path");
    }

    public String getBootClassPath() {
        return this.getServerProperty("sun.boot.class.path");
    }

    public long getCurrentHeapSize() {
        return (Long)this.getAttributeValue("java.lang:type=Memory", "HeapMemoryUsage/used", -1L);
    }

    public long getCommitedHeapSize() {
        return (Long)this.getAttributeValue("java.lang:type=Memory", "HeapMemoryUsage/committed", -1L);
    }

    public long getMaximumHeapSize() {
        return (Long)this.getAttributeValue("java.lang:type=Memory", "HeapMemoryUsage/max", -1L);
    }

    private String getServerProperty(String property) {
        if (this.m_serverProperties == null) {
            this.m_serverProperties = this.getServerProperties();
        }
        return this.m_serverProperties.getProperty(property);
    }

    private Properties getServerProperties() {
        IMBeanHelperService helper = this.getMBeanHelperService();
        try {
            return this.indexServerProperties((TabularData)helper.getAttribute(new MRI(MRI.Type.ATTRIBUTE, "java.lang:type=Runtime", "SystemProperties")).getValue());
        }
        catch (IOException e) {
            return new Properties();
        }
        catch (JMException e) {
            return new Properties();
        }
    }

    private Properties indexServerProperties(TabularData serverProperties) {
        Properties props = new Properties();
        for (Object obj : serverProperties.values()) {
            CompositeData data = (CompositeData)obj;
            Object[] row = data.values().toArray();
            props.put(row[0], row[1]);
        }
        return props;
    }

    private Object getAttributeValue(MRI attribute, Object defaultValue) {
        IMBeanHelperService helper = this.getMBeanHelperService();
        try {
            return helper.getAttribute(attribute).getValue();
        }
        catch (IOException e) {
            return defaultValue;
        }
        catch (JMException e) {
            return defaultValue;
        }
    }

    private Object getAttributeValue(String mBean, String attribute, Object defaultValue) {
        try {
            return this.getAttributeValue(new MRI(MRI.Type.ATTRIBUTE, new ObjectName(mBean), attribute), defaultValue);
        }
        catch (MalformedObjectNameException e) {
            return defaultValue;
        }
    }

    private IMBeanHelperService getMBeanHelperService() {
        return (IMBeanHelperService)this.m_connectionHandle.getServiceOrDummy(IMBeanHelperService.class);
    }
}

