/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.selector.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.ui.SwingWorker;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.CellTipManager;
import org.netbeans.lib.profiler.ui.components.JCheckTree;
import org.netbeans.lib.profiler.ui.components.tree.CheckTreeNode;
import org.netbeans.lib.profiler.utils.formatting.DefaultMethodNameFormatter;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatter;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatterFactory;
import org.netbeans.modules.profiler.api.GestureSubmitter;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProgressDisplayer;
import org.netbeans.modules.profiler.api.java.SourceMethodInfo;
import org.netbeans.modules.profiler.selector.api.SelectionTreeBuilderType;
import org.netbeans.modules.profiler.selector.api.nodes.ClassNode;
import org.netbeans.modules.profiler.selector.api.nodes.ConstructorNode;
import org.netbeans.modules.profiler.selector.api.nodes.ContainerNode;
import org.netbeans.modules.profiler.selector.api.nodes.MethodNode;
import org.netbeans.modules.profiler.selector.api.nodes.PackageNode;
import org.netbeans.modules.profiler.selector.api.nodes.SelectorNode;
import org.netbeans.modules.profiler.selector.spi.SelectionTreeBuilder;
import org.netbeans.modules.profiler.selector.ui.Bundle;
import org.netbeans.modules.profiler.selector.ui.CancellableController;
import org.netbeans.modules.profiler.selector.ui.SearchPanel;
import org.netbeans.modules.profiler.selector.ui.TreePathSearch;
import org.netbeans.modules.profiler.utilities.trees.NodeFilter;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;

public class RootSelectorTree
extends JPanel {
    private static final MethodNameFormatterFactory methodFormatterFactory = MethodNameFormatterFactory.getDefault((MethodNameFormatter)new DefaultMethodNameFormatter(5));
    private static final Comparator<ClientUtils.SourceCodeSelection> containmentComparator = new Comparator<ClientUtils.SourceCodeSelection>(){

        @Override
        public int compare(ClientUtils.SourceCodeSelection sourceCodeSelection, ClientUtils.SourceCodeSelection sourceCodeSelection2) {
            if (sourceCodeSelection == null && sourceCodeSelection2 != null) {
                return 1;
            }
            if (sourceCodeSelection != null && sourceCodeSelection2 == null) {
                return -1;
            }
            if (sourceCodeSelection == null && sourceCodeSelection2 == null) {
                return 0;
            }
            if (sourceCodeSelection.equals((Object)sourceCodeSelection2)) {
                return 0;
            }
            if (sourceCodeSelection.contains(sourceCodeSelection2)) {
                return -1;
            }
            if (sourceCodeSelection2.contains(sourceCodeSelection)) {
                return 1;
            }
            return sourceCodeSelection.toFlattened().compareTo(sourceCodeSelection2.toFlattened());
        }
    };
    private JCheckTree tree = new JCheckTree(){

        public String getToolTipText(MouseEvent mouseEvent) {
            TreePath treePath = RootSelectorTree.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath != null && treePath.getPathCount() > 1) {
                while (treePath != null) {
                    TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
                    if (treeNode instanceof SelectorNode) {
                        SourceMethodInfo sourceMethodInfo;
                        if (treePath.getPathCount() == 2) {
                            return ((SelectorNode)treeNode).getDisplayName();
                        }
                        String string = null;
                        if (treeNode instanceof PackageNode) {
                            string = ((PackageNode)treeNode).getPackageInfo().getBinaryName();
                        } else if (treeNode instanceof ClassNode) {
                            string = ((ClassNode)treeNode).getClassInfo().getQualifiedName();
                        } else if (treeNode instanceof MethodNode) {
                            sourceMethodInfo = ((MethodNode)treeNode).getMethodInfo();
                            string = methodFormatterFactory.getFormatter().formatMethodName(sourceMethodInfo.getClassName(), sourceMethodInfo.getName(), sourceMethodInfo.getSignature()).toFormatted();
                        } else if (treeNode instanceof ConstructorNode) {
                            sourceMethodInfo = ((ConstructorNode)treeNode).getMethodInfo();
                            string = methodFormatterFactory.getFormatter().formatMethodName(sourceMethodInfo.getClassName(), sourceMethodInfo.getName(), sourceMethodInfo.getSignature()).toFormatted();
                        }
                        if (string != null) {
                            if (string.isEmpty()) {
                                string = "<default>";
                            }
                            return string;
                        }
                    }
                    treePath = treePath.getParentPath();
                }
            }
            return super.getToolTipText(mouseEvent);
        }
    };
    private static final NodeFilter<SelectorNode> DEFAULT_FILTER_INNER = new NodeFilter<SelectorNode>(){

        public boolean match(SelectorNode selectorNode) {
            return true;
        }

        public boolean maymatch(SelectorNode selectorNode) {
            return true;
        }
    };
    public static NodeFilter<SelectorNode> DEFAULT_FILTER = DEFAULT_FILTER_INNER;
    private static final TreeModel DEFAULTMODEL = new DefaultTreeModel(new DefaultMutableTreeNode(Bundle.RootSelectorTree_EmptyString()));
    public static final String SELECTION_TREE_VIEW_LIST_PROPERTY = "SELECTION_TREE_VIEW_LIST";
    private final Set<ClientUtils.SourceCodeSelection> currentSelectionSet = new HashSet<ClientUtils.SourceCodeSelection>();
    private ProgressDisplayer progress = ProgressDisplayer.DEFAULT;
    private Lookup context = Lookup.EMPTY;
    private SelectionTreeBuilderType builderType = null;
    private SearchPanel searchPanel = null;
    private final TreePathSearch.ClassIndex ci;
    private Cancellable cancellHandler;
    private final AtomicBoolean isActive = new AtomicBoolean(true);
    private final Semaphore semaphore = new Semaphore(1);
    private final Semaphore lazyOpeningSemaphore = new Semaphore(1);
    private TreePathSearch sCont;
    private AtomicBoolean searchInProgress = new AtomicBoolean(false);

    public RootSelectorTree(ProgressDisplayer progressDisplayer, TreePathSearch.ClassIndex classIndex) {
        this.progress = progressDisplayer;
        this.ci = classIndex;
        this.init();
    }

    public void setContext(Lookup lookup) {
        this.context = lookup;
        this.firePropertyChange(SELECTION_TREE_VIEW_LIST_PROPERTY, null, null);
    }

    public void setCancelHandler(Cancellable cancellable) {
        this.cancellHandler = cancellable;
    }

    public void setSelection(ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray, Lookup lookup) {
        this.setSelection(sourceCodeSelectionArray);
        this.setContext(lookup);
    }

    private void setSelection(ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray) {
        new SelectionSetter(sourceCodeSelectionArray).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientUtils.SourceCodeSelection[] getSelection() {
        Set<ClientUtils.SourceCodeSelection> set = this.currentSelectionSet;
        synchronized (set) {
            if (this.currentSelectionSet.isEmpty()) {
                return new ClientUtils.SourceCodeSelection[0];
            }
            ArrayList<ClientUtils.SourceCodeSelection> arrayList = new ArrayList<ClientUtils.SourceCodeSelection>(this.currentSelectionSet);
            Collections.sort(arrayList, containmentComparator);
            this.currentSelectionSet.clear();
            ClientUtils.SourceCodeSelection sourceCodeSelection = null;
            for (ClientUtils.SourceCodeSelection sourceCodeSelection2 : arrayList) {
                if (sourceCodeSelection != null && sourceCodeSelection.contains(sourceCodeSelection2)) continue;
                sourceCodeSelection = sourceCodeSelection2;
                this.currentSelectionSet.add(sourceCodeSelection2);
            }
            return this.currentSelectionSet.toArray(new ClientUtils.SourceCodeSelection[this.currentSelectionSet.size()]);
        }
    }

    public List<SelectionTreeBuilderType> getBuilderTypes() {
        ArrayList<TypeEntry> arrayList = new ArrayList<TypeEntry>();
        for (Object object : this.context.lookupAll(SelectionTreeBuilder.class)) {
            if (object.estimatedNodeCount() == -1) continue;
            SelectionTreeBuilderType object2 = object.getType();
            TypeEntry typeEntry = new TypeEntry(object2);
            if (arrayList.contains(typeEntry)) {
                int n = arrayList.indexOf(typeEntry);
                typeEntry = (TypeEntry)arrayList.get(n);
                typeEntry.frequency = typeEntry.frequency + (object.isPreferred() ? 2 : 1);
                continue;
            }
            typeEntry.frequency = object.isPreferred() ? 2 : 1;
            arrayList.add(typeEntry);
        }
        Collections.sort(arrayList, new Comparator<TypeEntry>(){

            @Override
            public int compare(TypeEntry typeEntry, TypeEntry typeEntry2) {
                if (typeEntry.frequency < typeEntry2.frequency) {
                    return 1;
                }
                if (typeEntry.frequency > typeEntry2.frequency) {
                    return -1;
                }
                return 0;
            }
        });
        ArrayList arrayList2 = new ArrayList(arrayList.size());
        for (TypeEntry typeEntry : arrayList) {
            arrayList2.add(typeEntry.type);
        }
        return arrayList2;
    }

    public void setBuilderType(SelectionTreeBuilderType selectionTreeBuilderType) {
        this.builderType = selectionTreeBuilderType;
        this.refreshTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.isActive.set(true);
        this.tree.setModel(DEFAULTMODEL);
        this.context = Lookup.EMPTY;
        this.sCont = null;
        this.searchPanel.reset();
        Set<ClientUtils.SourceCodeSelection> set = this.currentSelectionSet;
        synchronized (set) {
            this.currentSelectionSet.clear();
        }
    }

    public void setRowHeight(int n) {
        this.tree.setRowHeight(n);
    }

    public static boolean canBeShown(Lookup lookup) {
        return lookup.lookup(SelectionTreeBuilder.class) != null;
    }

    private void init() {
        CellTipManager.sharedInstance().unregisterComponent((JComponent)this.tree);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.tree);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new BorderLayout());
        UIUtils.makeTreeAutoExpandable((JTree)this.tree, (boolean)true);
        this.setupTreeNodeToggleLogic();
        this.addTreeLazyOpening();
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setModel(DEFAULTMODEL);
        JScrollPane jScrollPane = new JScrollPane((Component)this.tree, 20, 30);
        this.add((Component)jScrollPane, "Center");
        this.searchPanel = new SearchPanel((JComponent)this.tree){

            @Override
            protected void performFind() {
                RootSelectorTree.this.tree.requestFocus();
                RootSelectorTree.this.findNode(this.getSearchText());
            }

            @Override
            protected void performNext() {
                RootSelectorTree.this.tree.requestFocus();
                RootSelectorTree.this.find(false);
            }

            @Override
            protected void performPrevious() {
                RootSelectorTree.this.tree.requestFocus();
                RootSelectorTree.this.find(true);
            }

            @Override
            protected void onCancel() {
                RootSelectorTree.this.tree.requestFocus();
            }

            @Override
            protected void onClose() {
                RootSelectorTree.this.searchPanel.setPermanent(false);
            }
        };
        this.add((Component)this.searchPanel, "South");
        jScrollPane.setPreferredSize(this.tree.getPreferredSize());
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    private void addTreeLazyOpening() {
        this.tree.addTreeWillExpandListener(new TreeWillExpandListener(){
            private volatile boolean openingSubtree = false;

            @Override
            public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(final TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                TreeNode treeNode = (TreeNode)treeExpansionEvent.getPath().getLastPathComponent();
                if (!(treeNode instanceof DefaultMutableTreeNode)) {
                    return;
                }
                final DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeNode;
                if (defaultMutableTreeNode.getChildCount() == -1) {
                    if (this.openingSubtree) {
                        throw new ExpandVetoException(treeExpansionEvent);
                    }
                    this.openingSubtree = true;
                    new SwingWorker(RootSelectorTree.this.lazyOpeningSemaphore){

                        protected void doInBackground() {
                            RootSelectorTree.checkNodeChildren(defaultMutableTreeNode, false);
                        }

                        protected void nonResponding() {
                            RootSelectorTree.this.progress.showProgress(Bundle.NodeLoadingMessage());
                        }

                        protected void done() {
                            RootSelectorTree.this.progress.close();
                            RootSelectorTree.this.tree.expandPath(treeExpansionEvent.getPath());
                            RootSelectorTree.this.doLayout();
                            openingSubtree = false;
                        }
                    }.execute();
                    throw new ExpandVetoException(treeExpansionEvent);
                }
                RootSelectorTree.checkNodeChildren(defaultMutableTreeNode, false);
            }
        });
    }

    private void setupTreeNodeToggleLogic() {
        this.tree.addCheckTreeListener(new JCheckTree.CheckTreeListener(){

            public void checkTreeChanged(Collection<CheckTreeNode> collection) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void checkNodeToggled(TreePath treePath, boolean bl) {
                if (!bl) {
                    SelectorNode selectorNode = (SelectorNode)treePath.getLastPathComponent();
                    Collection collection = selectorNode.getRootMethods(true);
                    if (selectorNode.isFullyChecked()) {
                        ArrayList<ClientUtils.SourceCodeSelection> arrayList = new ArrayList<ClientUtils.SourceCodeSelection>();
                        Set set = RootSelectorTree.this.currentSelectionSet;
                        synchronized (set) {
                            for (ClientUtils.SourceCodeSelection sourceCodeSelection : collection) {
                                for (ClientUtils.SourceCodeSelection sourceCodeSelection2 : RootSelectorTree.this.currentSelectionSet) {
                                    if (!sourceCodeSelection.contains(sourceCodeSelection2)) continue;
                                    arrayList.add(sourceCodeSelection2);
                                }
                            }
                        }
                        RootSelectorTree.this.removeSelection(arrayList.toArray(new ClientUtils.SourceCodeSelection[arrayList.size()]));
                        RootSelectorTree.this.applySelection(collection.toArray(new ClientUtils.SourceCodeSelection[collection.size()]));
                    } else {
                        Object object4;
                        Object object2;
                        Object object3;
                        ContainerNode containerNode = selectorNode.getParent();
                        ArrayList arrayList = new ArrayList();
                        if (containerNode != null) {
                            object3 = containerNode.children();
                            while (object3.hasMoreElements()) {
                                object2 = (SelectorNode)object3.nextElement();
                                if (object2 == selectorNode || !object2.isFullyChecked()) continue;
                                arrayList.addAll(object2.getRootMethods(true));
                            }
                            arrayList.removeAll(collection);
                        }
                        object3 = new ArrayList();
                        for (Object object4 : collection) {
                            for (ClientUtils.SourceCodeSelection sourceCodeSelection : RootSelectorTree.this.currentSelectionSet) {
                                if (!sourceCodeSelection.contains(object4) && !object4.contains(sourceCodeSelection)) continue;
                                object3.add(sourceCodeSelection);
                            }
                        }
                        object3.addAll(collection);
                        object2 = (TreeNode)RootSelectorTree.this.tree.getModel().getRoot();
                        object4 = new ArrayList();
                        int n = object2.getChildCount();
                        for (int i = 0; i < n; ++i) {
                            RootSelectorTree.calculateInflatedSelection((SelectorNode)containerNode, (SelectorNode)object2.getChildAt(i), (Collection)object4, (Collection)object3);
                        }
                        RootSelectorTree.addRequiredPackages((Collection)object4, arrayList);
                        RootSelectorTree.this.removeSelection(object3.toArray(new ClientUtils.SourceCodeSelection[object3.size()]));
                        RootSelectorTree.this.applySelection(arrayList.toArray(new ClientUtils.SourceCodeSelection[arrayList.size()]));
                    }
                }
            }
        });
    }

    private void findNode(String string) {
        GestureSubmitter.logRMSSearch((String)string);
        this.sCont = new TreePathSearch((TreeNode)this.tree.getModel().getRoot(), string, this.ci);
        this.find(false);
    }

    private void find(final boolean bl) {
        if (this.sCont == null) {
            return;
        }
        if (this.searchInProgress.compareAndSet(false, true)) {
            new SwingWorker(){
                private volatile TreePath rsltPath;
                private volatile ProgressDisplayer pd;

                protected void doInBackground() {
                    this.rsltPath = bl ? (TreePath)RootSelectorTree.this.sCont.back() : (TreePath)RootSelectorTree.this.sCont.forward();
                }

                protected void nonResponding() {
                    this.pd = RootSelectorTree.this.progress.showProgress(Bundle.MSG_SEARCHING(), new ProgressDisplayer.ProgressController(){

                        public boolean cancel() {
                            if (RootSelectorTree.this.sCont != null) {
                                RootSelectorTree.this.sCont.cancel();
                            }
                            return true;
                        }
                    });
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void done() {
                    try {
                        if (this.pd != null) {
                            this.pd.close();
                        }
                        if (this.rsltPath != null) {
                            RootSelectorTree.this.tree.makeVisible(this.rsltPath);
                            RootSelectorTree.this.tree.setSelectionPath(this.rsltPath);
                            RootSelectorTree.this.tree.scrollPathToVisible(this.rsltPath);
                        } else {
                            ProfilerDialogs.displayWarning((String)Bundle.MSG_NOMATCH(), (String)Bundle.CAP_SEARCHRSLT(), null);
                        }
                    }
                    finally {
                        RootSelectorTree.this.searchInProgress.set(false);
                    }
                }
            }.execute();
        }
    }

    private static void checkNodeChildren(DefaultMutableTreeNode defaultMutableTreeNode, boolean bl) {
        RootSelectorTree.checkNodeChildren(defaultMutableTreeNode, bl, null);
    }

    private static void checkNodeChildren(DefaultMutableTreeNode defaultMutableTreeNode, boolean bl, CancellableController cancellableController) {
        if (cancellableController != null && cancellableController.isCancelled()) {
            return;
        }
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        if (defaultMutableTreeNode instanceof CheckTreeNode && ((CheckTreeNode)defaultMutableTreeNode).isFullyChecked()) {
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode = enumeration.nextElement();
                if (!(treeNode instanceof CheckTreeNode)) continue;
                ((CheckTreeNode)treeNode).setChecked(true);
                if (!bl) continue;
                RootSelectorTree.checkNodeChildren((DefaultMutableTreeNode)((CheckTreeNode)treeNode), bl, cancellableController);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applySelection(ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray) {
        Object object;
        if (!this.isActive.get()) {
            return;
        }
        TreeNode treeNode = (TreeNode)this.tree.getModel().getRoot();
        Enumeration<? extends TreeNode> enumeration = treeNode.children();
        while (enumeration.hasMoreElements()) {
            if (!this.isActive.get()) {
                return;
            }
            object = enumeration.nextElement();
            if (!(object instanceof SelectorNode)) continue;
            for (ClientUtils.SourceCodeSelection sourceCodeSelection : sourceCodeSelectionArray) {
                this.applySelection((SelectorNode)object, sourceCodeSelection);
            }
        }
        object = this.currentSelectionSet;
        synchronized (object) {
            this.currentSelectionSet.addAll(Arrays.asList(sourceCodeSelectionArray));
        }
    }

    private void applySelection(SelectorNode selectorNode, ClientUtils.SourceCodeSelection sourceCodeSelection) {
        if (!this.isActive.get()) {
            return;
        }
        ClientUtils.SourceCodeSelection sourceCodeSelection2 = selectorNode.getSignature();
        if (sourceCodeSelection2 != null) {
            if (sourceCodeSelection2.equals((Object)sourceCodeSelection) || sourceCodeSelection.contains(sourceCodeSelection2)) {
                selectorNode.setChecked(true);
                return;
            }
            if (!sourceCodeSelection2.contains(sourceCodeSelection)) {
                return;
            }
        }
        Enumeration enumeration = selectorNode.children();
        while (enumeration.hasMoreElements()) {
            if (!this.isActive.get()) {
                return;
            }
            Object e = enumeration.nextElement();
            if (!(e instanceof SelectorNode)) continue;
            this.applySelection((SelectorNode)e, sourceCodeSelection);
        }
    }

    private void removeSelection(ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray) {
        TreeNode treeNode = (TreeNode)this.tree.getModel().getRoot();
        Enumeration<? extends TreeNode> enumeration = treeNode.children();
        while (enumeration.hasMoreElements()) {
            TreeNode treeNode2 = enumeration.nextElement();
            if (!(treeNode2 instanceof SelectorNode)) continue;
            for (ClientUtils.SourceCodeSelection sourceCodeSelection : sourceCodeSelectionArray) {
                this.removeSelection((SelectorNode)treeNode2, sourceCodeSelection);
            }
        }
        this.currentSelectionSet.removeAll(Arrays.asList(sourceCodeSelectionArray));
    }

    private void removeSelection(SelectorNode selectorNode, ClientUtils.SourceCodeSelection sourceCodeSelection) {
        ClientUtils.SourceCodeSelection sourceCodeSelection2 = selectorNode.getSignature();
        if (sourceCodeSelection2 != null) {
            if (sourceCodeSelection2.equals((Object)sourceCodeSelection)) {
                selectorNode.setChecked(false);
                return;
            }
            if (!sourceCodeSelection2.contains(sourceCodeSelection)) {
                return;
            }
        }
        Enumeration enumeration = selectorNode.children();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof SelectorNode)) continue;
            this.removeSelection((SelectorNode)e, sourceCodeSelection);
        }
    }

    private static void calculateInflatedSelection(SelectorNode selectorNode, SelectorNode selectorNode2, Collection<ClientUtils.SourceCodeSelection> collection, Collection<ClientUtils.SourceCodeSelection> collection2) {
        if (selectorNode == null || selectorNode2 == null || collection == null || collection2 == null) {
            return;
        }
        if (selectorNode2.isFullyChecked() || selectorNode2.isPartiallyChecked()) {
            if (selectorNode2.getSignature() != null && selectorNode2.isFullyChecked() && !collection2.contains(selectorNode2.getSignature())) {
                collection.add(selectorNode2.getSignature());
            }
            if (selectorNode2.getSignature() == null || selectorNode.getSignature() == null || selectorNode2.getSignature().contains(selectorNode.getSignature())) {
                int n = selectorNode2.getChildCount();
                for (int i = 0; i < n; ++i) {
                    SelectorNode selectorNode3 = (SelectorNode)selectorNode2.getChildAt(i);
                    RootSelectorTree.calculateInflatedSelection(selectorNode, selectorNode3, collection, collection2);
                }
            }
        }
    }

    private static void addRequiredPackages(Collection<ClientUtils.SourceCodeSelection> collection, Collection<ClientUtils.SourceCodeSelection> collection2) {
        for (ClientUtils.SourceCodeSelection sourceCodeSelection : collection) {
            boolean bl = true;
            for (ClientUtils.SourceCodeSelection sourceCodeSelection2 : collection2) {
                bl = bl && !sourceCodeSelection.contains(sourceCodeSelection2);
            }
            if (!bl) continue;
            collection2.add(sourceCodeSelection);
        }
    }

    private void refreshTree() {
        this.tree.setModel((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode(Bundle.RootSelectorTree_LoadingString())));
        this.tree.setRootVisible(true);
        this.tree.setShowsRootHandles(false);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setModel((TreeModel)new DefaultTreeModel(this.getTreeRoot()));
        this.tree.treeDidChange();
        this.applyCurrentSelection();
    }

    private DefaultMutableTreeNode getTreeRoot() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(Bundle.RootSelectorTree_RootString());
        if (this.builderType != null) {
            for (SelectionTreeBuilder selectionTreeBuilder : this.context.lookupAll(SelectionTreeBuilder.class)) {
                if (!selectionTreeBuilder.getType().equals((Object)this.builderType)) continue;
                for (SelectorNode selectorNode : selectionTreeBuilder.buildSelectionTree()) {
                    defaultMutableTreeNode.add((MutableTreeNode)selectorNode);
                }
            }
        }
        return defaultMutableTreeNode;
    }

    private void applyCurrentSelection() {
        new SelectionSetter(new SelectionGetter(){

            @Override
            public ClientUtils.SourceCodeSelection[] getSelection() {
                return RootSelectorTree.this.getSelection();
            }
        }).execute();
    }

    private final class SelectionSetter
    extends SwingWorker {
        private volatile ProgressDisplayer pd;
        private final SelectionGetter getter;

        private SelectionSetter(SelectionGetter selectionGetter) {
            super(RootSelectorTree.this.semaphore);
            this.pd = null;
            this.getter = selectionGetter;
        }

        private SelectionSetter(final ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray) {
            this(new SelectionGetter(){

                @Override
                public ClientUtils.SourceCodeSelection[] getSelection() {
                    return sourceCodeSelectionArray;
                }
            });
        }

        protected void doInBackground() {
            RootSelectorTree.this.isActive.set(true);
            ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray = this.getter.getSelection();
            RootSelectorTree.this.removeSelection(RootSelectorTree.this.getSelection());
            RootSelectorTree.this.applySelection(sourceCodeSelectionArray);
        }

        protected void nonResponding() {
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RootSelectorTree.this.setEnabled(false);
                    countDownLatch.countDown();
                }
            });
            final SelectionSetter selectionSetter = this;
            this.pd = RootSelectorTree.this.progress.showProgress(Bundle.MSG_ApplyingSelection(), new ProgressDisplayer.ProgressController(){

                public boolean cancel() {
                    selectionSetter.cancel();
                    return true;
                }
            });
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }

        protected void done() {
            this.closeProgress();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RootSelectorTree.this.setEnabled(true);
                }
            });
            RootSelectorTree.this.tree.treeDidChange();
        }

        private void closeProgress() {
            if (this.pd != null && this.pd.isOpened()) {
                this.pd.close();
                this.pd = null;
            }
        }

        protected int getWarmup() {
            return 50;
        }

        protected void cancelled() {
            RootSelectorTree.this.isActive.set(false);
            this.closeProgress();
            if (RootSelectorTree.this.cancellHandler != null) {
                RootSelectorTree.this.cancellHandler.cancel();
            }
        }
    }

    private static interface SelectionGetter {
        public ClientUtils.SourceCodeSelection[] getSelection();
    }

    private static class TypeEntry {
        SelectionTreeBuilderType type;
        int frequency;

        public TypeEntry(SelectionTreeBuilderType selectionTreeBuilderType) {
            this.type = selectionTreeBuilderType;
            this.frequency = 0;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            TypeEntry typeEntry = (TypeEntry)object;
            return this.type == typeEntry.type || this.type != null && this.type.equals((Object)typeEntry.type);
        }

        public int hashCode() {
            int n = 5;
            n = 53 * n + (this.type != null ? this.type.hashCode() : 0);
            return n;
        }
    }
}

