/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core;

import com.jrockit.mc.core.MCVersion;
import com.jrockit.mc.core.idesupport.IDESupportFactory;
import com.jrockit.mc.core.idesupport.IIDESupport;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class CorePlugin
implements BundleActivator {
    public static final String PLUGIN_ID = "com.jrockit.mc.core";
    private static CorePlugin plugin;
    private IEclipsePreferences preferences;
    private final Logger m_logger;

    public CorePlugin() {
        plugin = this;
        this.m_logger = Logger.getLogger(PLUGIN_ID);
    }

    public static CorePlugin getDefault() {
        return plugin;
    }

    public Logger getLogger() {
        return this.m_logger;
    }

    public File getWorkspaceDirectory() {
        URL url = Platform.getInstanceLocation().getURL();
        return new File(url.getPath());
    }

    protected String getVersion() {
        return MCVersion.getFullVersion();
    }

    public File getSettingsDirectory() throws IOException {
        File file = new File(this.getWorkspaceDirectory(), this.getVersion());
        if (!file.exists() && !file.mkdir()) {
            throw new IOException("Could not create file for user settings in " + file);
        }
        return file;
    }

    public IIDESupport getIDESupport() {
        return IDESupportFactory.getIDESupport();
    }

    public IEclipsePreferences getPreferences() {
        if (this.preferences == null) {
            InstanceScope scope = new InstanceScope();
            this.preferences = scope.getNode(PLUGIN_ID);
        }
        return this.preferences;
    }

    public void start(BundleContext context) throws Exception {
    }

    public void stop(BundleContext context) throws Exception {
    }
}

