/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core;

import com.jrockit.mc.core.ITreeNode;
import org.eclipse.core.runtime.IAdaptable;

public class DefaultTreeNode
implements ITreeNode {
    private ITreeNode parent;
    private Object userData;
    private ITreeNode[] children;

    public DefaultTreeNode(Object userData) {
        this(null, userData);
    }

    public DefaultTreeNode(ITreeNode parent, Object userData) {
        this.setParent(parent);
        this.setUserData(userData);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(this.getUserData().getClass())) {
            return this.getUserData();
        }
        if (this.getUserData() instanceof IAdaptable) {
            return ((IAdaptable)this.getUserData()).getAdapter(adapter);
        }
        return null;
    }

    public void setParent(ITreeNode parent) {
        this.parent = parent;
    }

    @Override
    public ITreeNode getParent() {
        return this.parent;
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }

    @Override
    public Object getUserData() {
        return this.userData;
    }

    public void setChildren(ITreeNode[] children) {
        this.children = children;
    }

    @Override
    public ITreeNode[] getChildren() {
        return this.children;
    }

    public ITreeNode[] getCopyOfChildren() {
        ITreeNode[] copyOfChildren = null;
        if (this.children != null) {
            copyOfChildren = new ITreeNode[this.children.length];
            System.arraycopy(this.children, 0, copyOfChildren, 0, this.children.length);
        }
        return copyOfChildren;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append("[userData=[");
        sb.append(this.userData.toString());
        if (this.children == null) {
            sb.append("]]");
        } else {
            sb.append("], children=[");
            int i = 0;
            while (i < this.children.length) {
                if (i > 0) {
                    sb.append(", ");
                }
                if (!this.equals(this.children[i].getParent())) {
                    throw new IllegalStateException("Child has other parent than this!");
                }
                sb.append(this.children[i].toString());
                ++i;
            }
            sb.append("]]");
        }
        return sb.toString();
    }
}

