/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.idesupport;

import com.jrockit.mc.core.MCFile;
import com.jrockit.mc.core.idesupport.JobFileAppend;
import com.jrockit.mc.core.idesupport.JobFileDelete;
import com.jrockit.mc.core.idesupport.JobFileWrite;
import com.jrockit.mc.core.idesupport.JobFileWriteUnique;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.jobs.Job;

public final class IDESupportToolkit {
    private IDESupportToolkit() {
        throw new AssertionError((Object)"Toolkit - do not instantiate!");
    }

    public static Job appendAsJob(String jobName, MCFile file, InputStream stream) {
        JobFileAppend appendJob = new JobFileAppend(jobName, file, stream);
        appendJob.schedule();
        return appendJob;
    }

    public static Job writeAsJob(String jobName, MCFile file, InputStream stream) {
        JobFileWrite writeJob = new JobFileWrite(jobName, file, stream);
        writeJob.schedule();
        return writeJob;
    }

    public static Job writeUniqueAsJob(String jobName, MCFile file, InputStream stream) {
        JobFileWriteUnique writeJob = new JobFileWriteUnique(jobName, file, stream);
        writeJob.schedule();
        return writeJob;
    }

    public static Job deleteAsJob(String jobName, MCFile file) {
        JobFileDelete deleteJob = new JobFileDelete(jobName, file);
        deleteJob.schedule();
        return deleteJob;
    }

    public static InputStream createStream(String string) {
        try {
            return new ByteArrayInputStream(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            Logger.getLogger("com.jrockit.mc.ide.ui.idesupport").log(Level.SEVERE, "Could not create input stream for string " + string);
            return null;
        }
    }

    public static String createString(InputStream stream) throws IOException {
        if (stream != null) {
            StringWriter writer;
            block7: {
                writer = new StringWriter();
                char[] buffer = new char[256];
                try {
                    try {
                        int n;
                        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
                        while ((n = reader.read(buffer)) != -1) {
                            ((Writer)writer).write(buffer, 0, n);
                        }
                    }
                    catch (UnsupportedEncodingException e) {
                        Logger.getLogger("com.jrockit.mc.ide.ui.idesupport").log(Level.SEVERE, "Could not create string for input stream.");
                        stream.close();
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    stream.close();
                    throw throwable;
                }
                stream.close();
            }
            return ((Object)writer).toString();
        }
        return "";
    }
}

