/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.labelingrules;

import com.jrockit.mc.core.labelingrules.Messages;
import java.util.HashMap;

final class Constants {
    private static final HashMap<String, Object> constants = new HashMap();
    private static final Constants instance = new Constants();

    static Constants getInstance() {
        return instance;
    }

    public Constants() {
        this.initDefaultConstants();
    }

    private void initDefaultConstants() {
        this.setConstant("JDK", "{0}");
        this.setConstant("JVMType", "{1}");
        this.setConstant("Name", "{2}");
        this.setConstant("CmdLine", "{3}");
        this.setConstant("PID", "{4,number,#}");
        this.setConstant("IsDebug", "{5}");
        this.setConstant("ThisPID", "{6}");
        this.setConstant("StrConstDebug", Messages.NameConverter_DEBUG);
        this.setConstant("StrConstJVMJRockit", Messages.NameConverter_JVM_TYPE_JROCKIT);
        this.setConstant("StrConstJVMUnknown", Messages.NameConverter_JVM_TYPE_UNKNOWN);
    }

    public void setConstant(String key, Object value) {
        if (value == null) {
            throw new IllegalArgumentException("You may not add a variable which has a value that is null!");
        }
        constants.put(key, value);
    }

    public Object getConstant(String key) {
        return constants.get(key);
    }

    public boolean containsConstant(String key) {
        return constants.containsKey(key);
    }
}

