/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.labelingrules;

import com.jrockit.mc.common.jvm.JVMType;
import com.jrockit.mc.common.util.JavaVersion;
import com.jrockit.mc.core.labelingrules.IVariableEvaluator;
import com.jrockit.mc.core.labelingrules.Messages;
import java.util.HashMap;

class Variables {
    private static final HashMap<String, IVariableEvaluator> variables = new HashMap();
    private static final Variables instance = new Variables();

    public Variables() {
        this.initDefaultVariables();
    }

    private void initDefaultVariables() {
        variables.put("StrJVMType", new IVariableEvaluator(){

            @Override
            public String evaluate(Object[] input) {
                JVMType type = (JVMType)input[1];
                String typeStr = this.getLocalizedTypeStr(type);
                if (typeStr == null) {
                    return "";
                }
                return "[" + typeStr + "]";
            }

            private String getLocalizedTypeStr(JVMType type) {
                if (type == JVMType.JROCKIT) {
                    return Messages.NameConverter_JVM_TYPE_JROCKIT;
                }
                if (type == JVMType.HOTSPOT) {
                    return Messages.NameConverter_JVM_TYPE_HOTSPOT;
                }
                return Messages.NameConverter_JVM_TYPE_UNKNOWN;
            }
        });
        variables.put("UnsupportedStrJVMType", new IVariableEvaluator(){

            @Override
            public String evaluate(Object[] input) {
                JVMType type = (JVMType)input[1];
                String typeStr = this.getLocalizedTypeStr(type);
                if (typeStr == null) {
                    return "";
                }
                return "[" + typeStr + "]";
            }

            private String getLocalizedTypeStr(JVMType type) {
                if (type == JVMType.JROCKIT) {
                    return Messages.NameConverter_JVM_TYPE_JROCKIT;
                }
                if (type == JVMType.HOTSPOT) {
                    return null;
                }
                return Messages.NameConverter_JVM_TYPE_UNKNOWN;
            }
        });
        variables.put("StrDebug", new IVariableEvaluator(){

            @Override
            public String evaluate(Object[] input) {
                return "true".equals(input[4]) ? "[" + Messages.NameConverter_DEBUG + "]" : "";
            }
        });
        variables.put("StrJDK", new IVariableEvaluator(){

            @Override
            public String evaluate(Object[] input) {
                String version = (String)input[0];
                return version == null ? "" : version;
            }
        });
        variables.put("UnsupportedStrJDK", new IVariableEvaluator(){

            @Override
            public String evaluate(Object[] input) {
                String version = (String)input[0];
                if (!this.isSupportedVersion(version)) {
                    return "0".equals(version) ? "" : "[" + input[0] + "]";
                }
                return "";
            }

            private boolean isSupportedVersion(String version) {
                if (version == null) {
                    return true;
                }
                JavaVersion javaVersion = new JavaVersion(version);
                if (javaVersion.getMinor() != 7) {
                    return false;
                }
                return javaVersion.getMicro() > 0 || javaVersion.getUpdate() >= 40;
            }
        });
    }

    public static Variables getInstance() {
        return instance;
    }

    public boolean containsVariable(String content) {
        return variables.containsKey(content);
    }

    public IVariableEvaluator getVariable(String content) {
        return variables.get(content);
    }
}

